/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Index;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.Tablespace;
import oracle.javatools.db.ora.MaterializedView;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.OracleTablespaceProperties;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

public class OracleStorageProperties
extends AbstractChildDBObject {
    public static final String TYPE = "OracleStorageProperties";
    @PropertyKey(value=OracleStorageProperties.class, childOf={Table.class, MaterializedViewLog.class, Index.class, OracleTablespaceProperties.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleStorageProperties";
    @PropertyKey(value=OracleStorageProperties.class, childOf={MaterializedView.class}, provider=OracleDatabase.class)
    public static final String MV_INDEX_KEY = "MatViewIndexStorageProperties";

    public OracleStorageProperties() {
        this.setBufferMode(BufferModes.DEFAULT);
    }

    public String getType() {
        return "OracleStorageProperties";
    }

    public void setTablespaceID(DBObjectID tablespaceID) {
        this.setProperty("tablespaceID", tablespaceID);
    }

    @References(value=Tablespace.class)
    public DBObjectID getTablespaceID() {
        return (DBObjectID)this.getProperty("tablespaceID");
    }

    @Deprecated
    @Transient
    public void setTablespace(String tablespace) {
        ReferenceID id = null;
        if (ModelUtil.hasLength((String)tablespace)) {
            id = new ReferenceID("TABLESPACE", (Schema)null, tablespace);
        }
        this.setTablespaceID(id);
    }

    public String getTablespace() {
        DBObjectID id = this.getTablespaceID();
        return id == null ? null : DBUtil.getDBObjectName(id);
    }

    public void setPercentFree(Integer percentFree) {
        this.setProperty("percentFree", percentFree);
    }

    public Integer getPercentFree() {
        return (Integer)this.getProperty("percentFree");
    }

    public void setPercentUsed(Integer percentUsed) {
        this.setProperty("percentUsed", percentUsed);
    }

    public Integer getPercentUsed() {
        return (Integer)this.getProperty("percentUsed");
    }

    public void setInitrans(Integer initrans) {
        this.setProperty("initrans", initrans);
    }

    public Integer getInitrans() {
        return (Integer)this.getProperty("initrans");
    }

    public void setMaxtrans(Integer maxTrans) {
        this.setProperty("maxtrans", maxTrans);
    }

    public Integer getMaxtrans() {
        return (Integer)this.getProperty("maxtrans");
    }

    public void setInitialExtent(Integer initialExtent) {
        this.setProperty("initialExtent", initialExtent);
    }

    public Integer getInitialExtent() {
        return (Integer)this.getProperty("initialExtent");
    }

    public void setNextExtent(Integer nextExtent) {
        this.setProperty("nextExtent", nextExtent);
    }

    public Integer getNextExtent() {
        return (Integer)this.getProperty("nextExtent");
    }

    public void setMinExtent(Integer minExtent) {
        this.setProperty("minExtent", minExtent);
    }

    public Integer getMinExtent() {
        return (Integer)this.getProperty("minExtent");
    }

    public void setMaxExtent(Integer maxExtent) {
        this.setProperty("maxExtent", maxExtent);
    }

    public Integer getMaxExtent() {
        return (Integer)this.getProperty("maxExtent");
    }

    public void setPercentIncrease(Integer percentIncrease) {
        this.setProperty("percentIncrease", percentIncrease);
    }

    public Integer getPercentIncrease() {
        return (Integer)this.getProperty("percentIncrease");
    }

    public void setLogging(Boolean logging) {
        this.setProperty("logging", logging);
    }

    public Boolean getLogging() {
        return (Boolean)this.getProperty("logging");
    }

    public void setFreelists(Integer freelists) {
        this.setProperty("freelists", freelists);
    }

    public Integer getFreelists() {
        return (Integer)this.getProperty("freelists");
    }

    public void setFreelistGroups(Integer freelistGroups) {
        this.setProperty("freelistGroups", freelistGroups);
    }

    public Integer getFreelistGroups() {
        return (Integer)this.getProperty("freelistGroups");
    }

    public void setBufferMode(BufferModes bufferMode) {
        this.setProperty("bufferMode", (Object)bufferMode);
    }

    public BufferModes getBufferMode() {
        return (BufferModes)((Object)this.getProperty("bufferMode"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BufferModes {
        DEFAULT,
        KEEP,
        RECYCLE;

    }
}

