/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.DeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryOwner;

public class MaterializedView
extends Table
implements SQLQueryOwner {
    public static final String TYPE = "MATERIALIZED VIEW";

    public MaterializedView() {
        this((String)null, (Schema)null);
    }

    public MaterializedView(String name, Schema schema) {
        super(name, schema);
        this.setUpdatable(false);
        this.setRewrite(false);
        this.setRewriteType(RewriteCapability.NONE);
        this.setRefreshMode(RefreshMode.DEMAND);
        this.setRefreshMethod(RefreshMethod.COMPLETE);
        this.setFastRefresh(FastRefreshable.NO);
        this.setLastRefreshType(RefreshMethod.COMPLETE);
        this.setStaleness(Staleness.FRESH);
        this.setBuildType(BuildType.IMMEDIATE);
        this.setOnPrebuilt(PrebuiltType.NONE);
        this.setUseNoIndex(false);
        this.setKeyType(RefreshWith.UNSPECIFIED);
        this.setUsingConstraints(UsingConstraints.ENFORCED);
        this.setRollbackSegmentType(RollbackSegmentType.NONE);
        this.setCache(false);
        this.setParallel(1);
        this.setCompression(false);
    }

    public String getType() {
        return TYPE;
    }

    public SQLQuery getSQLQuery() {
        return (SQLQuery)this.getProperty("SQLQuery");
    }

    public void setSQLQuery(SQLQuery query) {
        this.setProperty("SQLQuery", query);
    }

    @Transient
    public String getViewText() {
        SQLQuery query = this.getSQLQuery();
        return query == null ? null : query.getSQLText().trim();
    }

    public void setUpdatable(boolean updatable) {
        this.setProperty("updatable", updatable);
    }

    public boolean isUpdatable() {
        return (Boolean)this.getProperty("updatable", false);
    }

    public void setRewrite(boolean rewrite) {
        this.setProperty("rewrite", rewrite);
    }

    public boolean isRewrite() {
        return (Boolean)this.getProperty("rewrite", false);
    }

    public void setRewriteType(RewriteCapability rewriteType) {
        this.setProperty("rewriteType", (Object)rewriteType);
    }

    public RewriteCapability getRewriteType() {
        return (RewriteCapability)((Object)this.getProperty("rewriteType"));
    }

    public void setRefreshMode(RefreshMode refreshMode) {
        this.setProperty("refreshMode", (Object)refreshMode);
    }

    public RefreshMode getRefreshMode() {
        return (RefreshMode)((Object)this.getProperty("refreshMode"));
    }

    public void setRefreshMethod(RefreshMethod refreshMethod) {
        this.setProperty("refreshMethod", (Object)refreshMethod);
    }

    public RefreshMethod getRefreshMethod() {
        return (RefreshMethod)((Object)this.getProperty("refreshMethod"));
    }

    public void setFastRefresh(FastRefreshable fastRefresh) {
        this.setProperty("fastRefresh", (Object)fastRefresh);
    }

    public FastRefreshable getFastRefresh() {
        return (FastRefreshable)((Object)this.getProperty("fastRefresh"));
    }

    public void setLastRefreshType(RefreshMethod lastRefreshType) {
        this.setProperty("lastRefreshType", (Object)lastRefreshType);
    }

    public RefreshMethod getLastRefreshType() {
        return (RefreshMethod)((Object)this.getProperty("lastRefreshType"));
    }

    public void setLastRefreshDate(Date lastRefreshDate) {
        this.setProperty("lastRefreshDate", lastRefreshDate);
    }

    public Date getLastRefreshDate() {
        return (Date)this.getProperty("lastRefreshDate");
    }

    public void setNextRefreshDate(Date nextRefreshDate) {
        this.setProperty("nextRefreshDate", nextRefreshDate);
    }

    public Date getNextRefreshDate() {
        return (Date)this.getProperty("nextRefreshDate");
    }

    @Deprecated
    @Transient
    public String getNextRefresh() {
        Date d = this.getNextRefreshDate();
        return d == null ? null : d.toString();
    }

    @Deprecated
    @Transient
    public void setNextRefresh(String nextStr) {
        try {
            SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.S");
            this.setNextRefreshDate(fmt.parse(nextStr));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public String getInterval() {
        return (String)this.getProperty("interval");
    }

    public void setInterval(String interval) {
        this.setProperty("interval", interval);
    }

    public void setStaleness(Staleness staleness) {
        this.setProperty("staleness", (Object)staleness);
    }

    public Staleness getStaleness() {
        return (Staleness)((Object)this.getProperty("staleness"));
    }

    public void setBuildType(BuildType buildType) {
        this.setProperty("buildType", (Object)buildType);
    }

    public BuildType getBuildType() {
        return (BuildType)((Object)this.getProperty("buildType"));
    }

    public void setOnPrebuilt(PrebuiltType onPrebuilt) {
        this.setProperty("onPrebuilt", (Object)onPrebuilt);
    }

    public PrebuiltType getOnPrebuilt() {
        return (PrebuiltType)((Object)this.getProperty("onPrebuilt"));
    }

    public void setUseNoIndex(boolean useNoIndex) {
        this.setProperty("useNoIndex", useNoIndex);
    }

    public boolean isUseNoIndex() {
        return (Boolean)this.getProperty("useNoIndex", false);
    }

    @Deprecated
    @Transient
    public void setIndexPercentFree(int indexPctFree) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setPercentFree(indexPctFree);
    }

    @Deprecated
    public int getIndexPercentFree() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getPercentFree();
    }

    @Deprecated
    @Transient
    public void setIndexPercentUsed(int indexPctUsed) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setPercentUsed(indexPctUsed);
    }

    @Deprecated
    @Transient
    public int getIndexPercentUsed() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getPercentUsed();
    }

    @Transient
    @Deprecated
    public void setIndexInitTrans(int indexInitTrans) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setInitrans(indexInitTrans);
    }

    @Deprecated
    public int getIndexInitTrans() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getInitrans();
    }

    @Transient
    @Deprecated
    public void setMaxTrans(int maxTrans) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
        osp.setMaxtrans(maxTrans);
    }

    @Deprecated
    public int getMaxTrans() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getMaxtrans();
    }

    @Transient
    @Deprecated
    public void setMinTrans(int minTrans) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
        osp.setInitrans(minTrans);
    }

    @Deprecated
    public int getMinTrans() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getInitrans();
    }

    @Transient
    @Deprecated
    public void setInitExtent(int initExtent) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
        osp.setInitialExtent(initExtent);
    }

    @Deprecated
    public int getInitExtent() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getInitialExtent();
    }

    @Deprecated
    @Transient
    public void setNextExtent(int nextExtent) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, true);
        osp.setNextExtent(nextExtent);
    }

    @Deprecated
    public int getNextExtent() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(false, false);
        return osp == null ? 0 : osp.getNextExtent();
    }

    @Transient
    @Deprecated
    public void setIndexMinExtent(int indexMinExtent) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setMinExtent(indexMinExtent);
    }

    @Deprecated
    public int getIndexMinExtent() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getMinExtent();
    }

    @Transient
    @Deprecated
    public void setIndexMaxExtent(int indexMaxExtent) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setMaxExtent(indexMaxExtent);
    }

    @Deprecated
    public int getIndexMaxExtent() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? 0 : osp.getMaxExtent();
    }

    @Deprecated
    public String getTablespace() {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, false);
        return osp == null ? null : osp.getTablespace();
    }

    @Transient
    @Deprecated
    public void setTablespace(String tablespace) {
        this.checkInit(TYPE);
        OracleStorageProperties osp = this.getOracleStorageProperties(true, true);
        osp.setTablespace(tablespace);
    }

    public void setCache(boolean cache) {
        this.setProperty("cache", cache);
    }

    public boolean isCache() {
        return (Boolean)this.getProperty("cache", false);
    }

    public void setMasters(String[] masters) {
        this.getChildSupport("masters").setChildArray(masters);
    }

    public String[] getMasters() {
        return this.getChildSupport("masters").getChildArray(String.class);
    }

    public RefreshWith getKeyType() {
        return (RefreshWith)((Object)this.getProperty("keyType"));
    }

    public void setKeyType(RefreshWith keyType) {
        this.setProperty("keyType", (Object)keyType);
    }

    public UsingConstraints getUsingConstraints() {
        return (UsingConstraints)((Object)this.getProperty("usingConstraints"));
    }

    public void setUsingConstraints(UsingConstraints usingConstraints) {
        this.setProperty("usingConstraints", (Object)usingConstraints);
    }

    public RollbackSegmentType getRollbackSegmentType() {
        return (RollbackSegmentType)((Object)this.getProperty("rollbackSegmentType"));
    }

    public void setRollbackSegmentType(RollbackSegmentType rollbackSegmentType) {
        this.setProperty("rollbackSegmentType", (Object)rollbackSegmentType);
    }

    public String getRollbackSegmentName() {
        return (String)this.getProperty("rollbackSegmentName");
    }

    public void setRollbackSegmentName(String rollbackSegmentName) {
        this.setProperty("rollbackSegmentName", rollbackSegmentName);
    }

    public boolean isDeclarative() {
        SQLQuery query = this.getSQLQuery();
        return query != null && query instanceof DeclarativeSQLQuery;
    }

    public void setParallel(int parallel) {
        this.setProperty("parallel", parallel);
    }

    public int getParallel() {
        return (Integer)this.getProperty("parallel", 1);
    }

    public void setCompression(boolean compression) {
        this.setProperty("compression", compression);
    }

    public boolean isCompression() {
        return (Boolean)this.getProperty("compression", false);
    }

    private OracleStorageProperties getOracleStorageProperties(boolean onIndex, boolean createIfNotFound) {
        String key = onIndex ? "MatViewIndexStorageProperties" : "OracleStorageProperties";
        OracleStorageProperties osp = (OracleStorageProperties)this.getProperty(key);
        if (osp == null && createIfNotFound) {
            osp = new OracleStorageProperties();
            this.setProperty(key, osp);
        }
        return osp;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum UsingConstraints {
        TRUSTED,
        ENFORCED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RollbackSegmentType {
        NONE,
        LOCAL,
        MASTER;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RefreshWith {
        UNSPECIFIED,
        PRIMARY_KEY,
        ROWID;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BuildType {
        IMMEDIATE,
        DEFERRED,
        PREBUILT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PrebuiltType {
        NONE,
        UNSPECIFIED_PRECISION,
        WITH_REDUCED_PRECISION,
        WITHOUT_REDUCED_PRECISION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Staleness {
        FRESH,
        STALE,
        UNUSABLE,
        UNKNOWN,
        UNDEFINED,
        NEEDS_COMPILE,
        COMPILATION_ERROR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FastRefreshable {
        NO,
        DIRLOAD,
        DML,
        DIRLOAD_DML,
        DIRLOAD_LIMITEDDML;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RefreshMethod {
        NEVER,
        FAST,
        COMPLETE,
        FORCE,
        NA;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RefreshMode {
        DEMAND,
        COMMIT,
        NEVER,
        SPECIFY;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RewriteCapability {
        NONE,
        TEXTMATCH,
        GENERAL;

    }
}

