/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.logging.Level;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.ora.OracleColumnProperties;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.util.ModelUtil;

public class LOBDescriptor
extends AbstractChildDBObject {
    public static final String TYPE = "LOB DESCRIPTOR";
    public static final String LOB_PARAMETER_CACHE = "CACHE";
    public static final String LOB_PARAMETER_NOCACHE = "NOCACHE";
    public static final String LOB_PARAMETER_CACHEREADS = "CACHE READS";

    public LOBDescriptor() {
        this.setStorageEnabledInRow(true);
        this.setRetention(false);
    }

    public String getName() {
        String name = super.getName();
        Relation rel = this.findParent(Relation.class);
        if (rel != null && !ModelUtil.hasLength((String)name)) {
            name = "";
            for (DBObjectID colID : this.getColumns()) {
                DBObject col;
                if (colID == null || !((col = rel.findOwnedObject(colID)) instanceof Column)) continue;
                if (name.length() > 0) {
                    name = name + ", ";
                }
                name = name + col.getName();
            }
            this.setName(name);
        }
        return name;
    }

    public String getType() {
        return TYPE;
    }

    public void setLOBSegName(String name) {
        this.setProperty("LOBSegName", name);
    }

    public String getLOBSegName() {
        return (String)this.getProperty("LOBSegName");
    }

    public void setColumns(DBObjectID[] columns) {
        this.getChildSupport("columns").setChildArray(columns);
    }

    public DBObjectID[] getColumns() {
        return this.getChildSupport("columns").getChildArray(DBObjectID.class);
    }

    public void addColumn(DBObjectID column) {
        if (column != null) {
            this.getChildSupport("columns").addChild(column);
        }
    }

    public void removeColumn(DBObjectID column) {
        this.getChildSupport("columns").removeChild(column);
    }

    public void setChunk(Integer chunk) {
        this.setProperty("chunk", chunk);
    }

    public Integer getChunk() {
        return (Integer)this.getProperty("chunk");
    }

    public void setPctVersion(Integer pctVersion) {
        this.setProperty("pctVersion", pctVersion);
    }

    public Integer getPctVersion() {
        return (Integer)this.getProperty("pctVersion");
    }

    public void setFreepools(Integer freepools) {
        this.setProperty("freepools", freepools);
    }

    public Integer getFreepools() {
        return (Integer)this.getProperty("freepools");
    }

    public void setStorage(OracleStorageProperties storage) {
        this.setProperty("storage", storage);
    }

    public OracleStorageProperties getStorage() {
        return (OracleStorageProperties)this.getProperty("storage");
    }

    public void setRetention(boolean retention) {
        this.setProperty("retention", retention);
    }

    public boolean isRetention() {
        return (Boolean)this.getProperty("retention", false);
    }

    public void setStorageEnabledInRow(boolean storageEnabledInRow) {
        this.setProperty("storageEnabledInRow", storageEnabledInRow);
    }

    public boolean isStorageEnabledInRow() {
        return (Boolean)this.getProperty("storageEnabledInRow", true);
    }

    public void setCache(String cache) {
        this.setProperty("cache", cache);
    }

    public String getCache() {
        return (String)this.getProperty("cache");
    }

    public static boolean isLOBColumn(DBObjectID colID) {
        try {
            Column column = (Column)colID.resolveID();
            if (column != null) {
                return LOBDescriptor.isLOBColumn(column);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isLOBColumn(Column column) {
        try {
            DataType dt = DataTypeHelper.getDataType(column.getDataTypeUsage());
            if (dt != null) {
                String name = dt.getName();
                return "BLOB".equalsIgnoreCase(name) || "CLOB".equalsIgnoreCase(name) || "NCLOB".equalsIgnoreCase(name);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isVARRAYColumn(DBObjectID colID) {
        Column column = null;
        Object dt = null;
        try {
            column = (Column)colID.resolveID();
            if (column != null) {
                return LOBDescriptor.isVARRAYColumn(column);
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isVARRAYColumn(Column column) {
        block3: {
            try {
                DataTypeUsage dtu = column.getDataTypeUsage();
                if (!(dtu instanceof ObjectTypeUsage)) break block3;
                ComplexType typ = (ComplexType)dtu.getDataTypeID().resolveID();
                if (typ == null) {
                    DBLog.getLogger().log(Level.WARNING, column.getName() + " has invalid data type usage");
                    break block3;
                }
                return "VARYING ARRAY".equals(typ.getCollectionType());
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return false;
    }

    public static LOBDescriptor findLOBDescriptorForColumn(Column column) {
        OracleColumnProperties ocp = (OracleColumnProperties)column.getProperty("OracleColumnProperties");
        if (ocp != null) {
            if (LOBDescriptor.isLOBColumn(column.getID())) {
                return ocp.getLOBProperties();
            }
            if (LOBDescriptor.isVARRAYColumn(column.getID())) {
                return ocp.getVAProperties();
            }
        }
        return null;
    }
}

