/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.extension.DatabaseMatcher;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MatcherCache<T> {
    private Map<String, Map<DatabaseMatcher, Map<String, T>>> m_cache = new TreeMap<String, Map<DatabaseMatcher, Map<String, T>>>();

    MatcherCache() {
    }

    public void put(String objType, T obj, DatabaseMatcher matcher) {
        String dbType = matcher.getDatabaseType();
        if (objType != null && obj != null && dbType != null) {
            T existing;
            Map<String, T> map;
            Map<DatabaseMatcher, Map<String, T>> cache = this.m_cache.get(dbType);
            if (cache == null) {
                cache = new HashMap<DatabaseMatcher, Map<String, T>>();
                this.m_cache.put(dbType, cache);
            }
            if ((map = cache.get(matcher)) == null) {
                map = new TreeMap<String, T>();
                cache.put(matcher, map);
            }
            if ((existing = map.get(objType)) == null) {
                map.put(objType, obj);
            } else if (ModelUtil.areDifferent(existing, obj)) {
                DBLog.getLogger(this).log(Level.WARNING, "Cannot register {0}: {1} already has {2} already registered", new String[]{this.getClass(obj).getName(), objType, this.getClass(existing).getName()});
            }
        }
    }

    private Class getClass(Object obj) {
        if (obj instanceof Class) {
            return (Class)obj;
        }
        return obj.getClass();
    }

    public Map<String, T> getAll(String dbType, int version) {
        TreeMap<String, T> retval = null;
        Map<DatabaseMatcher, Map<String, T>> cache = this.m_cache.get(dbType);
        if (cache != null) {
            for (Map.Entry<DatabaseMatcher, Map<String, T>> entry : cache.entrySet()) {
                if (!entry.getKey().matches(dbType, version)) continue;
                if (retval == null) {
                    retval = new TreeMap<String, T>();
                }
                retval.putAll(entry.getValue());
            }
        }
        return retval;
    }
}

