/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import java.util.Map;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.property.PropertyAction;

public final class DelegateDDLGenerator
implements DDLGenerator {
    private final DDLGenerator m_base;
    private final DatabaseDescriptor m_desc;
    private final DBObjectProvider m_pro;
    private Map<String, DDLGenerator> m_extras;

    public DelegateDDLGenerator(DDLGenerator base, DatabaseDescriptor desc, DBObjectProvider pro) {
        if (base == null || desc == null) {
            throw new IllegalArgumentException("must provide a base generator and database descriptor");
        }
        this.m_base = base;
        this.m_desc = desc;
        this.m_pro = pro;
    }

    private DDLGenerator getDelegate(Difference diff) {
        return this.getDelegate((DBObject)diff.getOriginalObject(), (DBObject)diff.getUpdatedObject());
    }

    private DDLGenerator getDelegate(DBObject original, DBObject update) {
        String type = null;
        if (original != null) {
            type = original.getType();
        } else if (update != null) {
            type = update.getType();
        }
        return this.getDelegate(type);
    }

    private DDLGenerator getDelegate(String type) {
        DDLGenerator retval;
        if (this.m_extras == null && DBObjectRegistry.isActive()) {
            this.m_extras = DBObjectRegistry.getInstance().getDDLGenerators(this.m_desc.getDatabaseType(), this.m_desc.getDatabaseVersion(), this.m_pro);
        }
        return (retval = this.m_extras.get(type)) == null ? this.m_base : retval;
    }

    public boolean canAlterProperty(DBObject original, DBObject update, String prop) {
        return this.getDelegate(original, update).canAlterProperty(original, update, prop);
    }

    public PropertyAction canChangeProperty(DBObject original, DBObject update, String prop) {
        return this.getDelegate(original, update).canChangeProperty(original, update, prop);
    }

    public PropertyAction canUpdateObject(DBObject original, DBObject update) {
        return this.getDelegate(original, update).canUpdateObject(original, update);
    }

    public PropertyAction canUpdateObject(Difference diff) {
        return this.getDelegate(diff).canUpdateObject(diff);
    }

    public DDL getCreateDDL(DDLOptions options, DBObject ... objects) {
        DDL retval = null;
        if (objects != null) {
            for (DBObject obj : objects) {
                DDL next = this.getDelegate(obj, null).getCreateDDL(options, obj);
                if (next == null) continue;
                if (retval == null) {
                    retval = next;
                    continue;
                }
                retval.append(next);
            }
        }
        return retval;
    }

    public DDL getDeleteDDL(DDLOptions options, DBObject ... objects) {
        DDL retval = null;
        if (objects != null) {
            for (DBObject obj : objects) {
                DDL next = this.getDelegate(obj, null).getDeleteDDL(options, obj);
                if (next == null) continue;
                if (retval == null) {
                    retval = next;
                    continue;
                }
                retval.append(next);
            }
        }
        return retval;
    }

    public DDL getUndeleteDDL(DDLOptions options, DBObject ... objects) {
        DDL retval = null;
        if (objects != null) {
            for (DBObject obj : objects) {
                DDL next = this.getDelegate(obj, null).getUndeleteDDL(options, obj);
                if (next == null) continue;
                if (retval == null) {
                    retval = next;
                    continue;
                }
                retval.append(next);
            }
        }
        return retval;
    }

    public DDL getUpdateDDL(DDLOptions options, Difference diff) {
        DDL ddl = new DDL();
        if ((diff.isMap() || diff.isLeaf()) && SystemObject.class.isAssignableFrom(diff.getDifferenceClass())) {
            this.processDifference(options, diff, ddl);
        } else if (diff.isList()) {
            for (Difference difference : diff.getChildren()) {
                this.processDifference(options, difference, ddl);
            }
        } else {
            DBLog.getLogger(this).warning("unexpected Difference type for DDL");
        }
        return ddl;
    }

    private void processDifference(DDLOptions options, Difference diff, DDL ddl) {
        DDL next = this.getDelegate(diff).getUpdateDDL(options, diff);
        if (next != null) {
            ddl.append(next);
        }
    }

    public boolean supportsAction(String type, PropertyAction.Type action) {
        return this.getDelegate(type).supportsAction(type, action);
    }

    public boolean supportsProperty(String type, String prop) {
        return this.getDelegate(type).supportsProperty(type, prop);
    }
}

