/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import oracle.javatools.util.ModelUtil;

public class DatabaseMatcher {
    private final String m_type;
    private final int m_version;
    private final Comparison m_comparison;

    public DatabaseMatcher(String dbType) {
        this(dbType, -1, Comparison.MINIMUM);
    }

    public DatabaseMatcher(String dbType, int version, Comparison comparison) {
        this.m_type = dbType;
        this.m_version = version;
        this.m_comparison = comparison;
    }

    public String getDatabaseType() {
        return this.m_type;
    }

    protected boolean matchesType(String dbType) {
        return ModelUtil.areEqual((Object)dbType, (Object)this.m_type);
    }

    protected boolean matchesVersion(int version) {
        switch (this.m_comparison) {
            case EXACT: {
                return this.m_version == version;
            }
            case MAXIMUM: {
                return this.m_version >= version;
            }
            case MINIMUM: {
                return this.m_version <= version;
            }
        }
        return false;
    }

    public boolean matches(String dbType, int version) {
        return this.matchesType(dbType) && this.matchesVersion(version);
    }

    public boolean equals(Object obj) {
        return obj instanceof DatabaseMatcher && this.equalsImpl((DatabaseMatcher)obj);
    }

    private boolean equalsImpl(DatabaseMatcher other) {
        return ModelUtil.areEqual((Object)this.m_type, (Object)other.m_type) && this.m_version == other.m_version && ModelUtil.areEqual((Object)((Object)this.m_comparison), (Object)((Object)other.m_comparison));
    }

    public int hashCode() {
        return this.m_type == null ? 0 : this.m_type.hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Comparison {
        EXACT,
        MINIMUM,
        MAXIMUM;

    }
}

