/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.extension;

import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.extension.DatabaseMatcher;
import oracle.javatools.db.extension.MatcherCache;
import oracle.javatools.db.property.Metadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectRegistry {
    private MatcherCache<Class<? extends DBObjectValidator>> m_validators = new MatcherCache();
    private MatcherCache<Class<? extends DBObjectBuilder>> m_builders = new MatcherCache();
    private MatcherCache<Class<? extends DBObjectLister>> m_lists = new MatcherCache();
    private MatcherCache<Class<? extends DDLGenerator>> m_ddlgens = new MatcherCache();

    public Map<String, DBObjectValidator> getValidators(String dbType, int version, DBObjectProvider pro) {
        Map clzMap = this.m_validators.getAll(dbType, version);
        return this.instantiateClasses(clzMap, pro);
    }

    public Map<String, DBObjectBuilder> getBuilders(String dbType, int version, DBObjectProvider pro) {
        Map clzMap = this.m_builders.getAll(dbType, version);
        return this.instantiateClasses(clzMap, pro);
    }

    public Map<String, DBObjectLister> getListers(String dbType, int version, DBObjectProvider pro) {
        Map clzMap = this.m_lists.getAll(dbType, version);
        return this.instantiateClasses(clzMap, pro);
    }

    public Map<String, DDLGenerator> getDDLGenerators(String dbType, int version, DBObjectProvider pro) {
        Map clzMap = this.m_ddlgens.getAll(dbType, version);
        return this.instantiateClasses(clzMap, pro);
    }

    private <T> Map<String, T> instantiateClasses(Map<String, Class<? extends T>> clzMap, DBObjectProvider pro) {
        TreeMap retval = new TreeMap();
        if (clzMap != null) {
            for (Map.Entry<String, Class<T>> entry : clzMap.entrySet()) {
                Class<T> clz = entry.getValue();
                try {
                    boolean found = false;
                    for (Constructor<?> c : clz.getConstructors()) {
                        Class<?>[] params = c.getParameterTypes();
                        if (params == null || params.length != 1 || !DBObjectProvider.class.isAssignableFrom(params[0])) continue;
                        try {
                            Object v = c.newInstance(pro);
                            retval.put(entry.getKey(), v);
                            found = true;
                            break;
                        }
                        catch (Exception e) {
                            DBLog.getLogger(this).log(Level.FINE, "Could not instatiate class:" + clz.getName(), e);
                        }
                    }
                    if (found) continue;
                    DBLog.getLogger(this).log(Level.SEVERE, "Class {0} is missing constructor that takes a DBObjectProvider", new String[]{clz.getName()});
                }
                catch (Exception e) {
                    DBLog.getLogger(this).log(Level.SEVERE, "Could not process class:" + clz.getName(), e);
                }
            }
        }
        return retval;
    }

    public void registerObject(String objType, DatabaseMatcher dbMatch, Class<? extends DBObjectValidator> validatorClz, Class<? extends DBObjectBuilder> builderClz, Class<? extends DBObjectLister> listClz, Class<? extends DDLGenerator> ddlGenClz) {
        this.m_validators.put(objType, validatorClz, dbMatch);
        this.m_builders.put(objType, builderClz, dbMatch);
        this.m_lists.put(objType, listClz, dbMatch);
        this.m_ddlgens.put(objType, ddlGenClz, dbMatch);
    }

    public void registerClass(String objType, Class<? extends DBObject> objClz) {
        if (objType == null) {
            throw new IllegalArgumentException("object type must be defined");
        }
        if (!DBObject.class.isAssignableFrom(objClz)) {
            throw new IllegalArgumentException("object class must subclass DBObject");
        }
        Metadata.getInstance().registerObjectClass(objType, objClz);
    }

    public static synchronized DBObjectRegistry getInstance() {
        DBCore core = DBCore.getInstance();
        DBObjectRegistry reg = core.get(DBObjectRegistry.class);
        if (reg == null) {
            reg = new DBObjectRegistry();
            core.put(reg);
        }
        return reg;
    }

    public static boolean isActive() {
        DBCore core = DBCore.getInstance();
        DBObjectRegistry reg = core.get(DBObjectRegistry.class);
        return reg != null;
    }

    public static boolean isExtensionType(String objType, String dbType, int dbVersion) {
        boolean retval = false;
        if (DBObjectRegistry.isActive()) {
            Map<String, Class<? extends DDLGenerator>> map = DBObjectRegistry.getInstance().m_ddlgens.getAll(dbType, dbVersion);
            retval = map != null && map.containsKey(objType);
        }
        return retval;
    }
}

