/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.execute;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.javatools.db.DBException;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.StatementWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionWrapper {
    private final Database m_db;
    private final String m_desc;

    public ConnectionWrapper(Database db, String desc) {
        if (db == null) {
            throw new IllegalArgumentException("Database cannot be null.");
        }
        this.m_db = db;
        this.m_desc = desc;
    }

    public void run(SQLRunnable r) throws DBException {
        this.call(r);
    }

    public <T> T call(SQLCallable<T> c) throws DBException {
        return this.call(c, true);
    }

    private <T> T call(SQLCallable<T> c, boolean tryAgain) throws DBException {
        Object retval;
        block8: {
            retval = null;
            try {
                retval = ((SQLCallable)c).callImpl();
            }
            catch (SQLException sqe) {
                boolean throwIt = true;
                if (tryAgain) {
                    Boolean cclosed = this.m_db.isConnectionClosed(sqe);
                    if (cclosed == null) {
                        cclosed = !this.m_db.isConnectionAlive();
                    }
                    if (Boolean.TRUE.equals(cclosed)) {
                        try {
                            Connection conn = this.m_db.getConnection(false);
                            Connection conn2 = this.m_db.getConnection(true);
                            if (conn2 != conn) {
                                throwIt = false;
                                retval = this.call(c, false);
                            }
                        }
                        catch (DBException dbe) {
                            throwIt = true;
                        }
                    }
                }
                if (!throwIt) break block8;
                throw StatementWrapper.createDBSQLException(this.m_db, null, this.m_desc, sqe);
            }
        }
        return (T)retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class SQLRunnable
    extends SQLCallable<Object> {
        @Override
        public final Object call() throws SQLException, DBException {
            this.run();
            return null;
        }

        public abstract void run() throws SQLException, DBException;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class SQLCallable<T> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T callImpl() throws SQLException, DBException {
            Connection connection = this.getConnection();
            synchronized (connection) {
                return this.call();
            }
        }

        public abstract T call() throws SQLException, DBException;

        protected final Connection getConnection() {
            try {
                return ConnectionWrapper.this.m_db.getConnection(false);
            }
            catch (DBException dbe) {
                throw new RuntimeException(dbe);
            }
        }
    }
}

