/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.ResultSet;

public class ListDiffer
implements Differ {
    private final boolean m_order;

    public ListDiffer() {
        this(false);
    }

    public ListDiffer(boolean diffOrder) {
        this.m_order = diffOrder;
    }

    public boolean diff(Object a, Object b) {
        assert (null != a || null != b);
        assert (null == a || a instanceof List);
        assert (null == b || b instanceof List);
        ResultSet rs = new ResultSet(null, a, b, null, "LIST");
        DiffEngine de = new DiffEngine();
        DiffContext dc = new DiffContext(de, rs);
        return this.diff(a, b, rs, dc);
    }

    public boolean diff(Object a, Object b, ResultSet rlist, DiffContext dc) {
        ArrayList blist = b != null ? new ArrayList((List)b) : new ArrayList();
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        boolean same = true;
        HashSet<Integer> foundFromB = new HashSet<Integer>();
        if (a == null) {
            if (b == null) {
                throw new IllegalStateException("no list to diff");
            }
        } else {
            for (int aIndex = 0; aIndex < ((List)a).size(); ++aIndex) {
                Object ao = ((List)a).get(aIndex);
                if (null == ao) continue;
                Comparator cmp = dc.getEngine().getComparator(ao.getClass());
                boolean found = false;
                for (int bIndex = 0; bIndex < blist.size(); ++bIndex) {
                    Object bo;
                    if (foundFromB.contains(bIndex) || cmp.compare(ao, bo = blist.get(bIndex)) != 0) continue;
                    ResultSet rm = new ResultSet(rlist, ao, bo, aIndex, bIndex, this.getName(ao), "MAP");
                    dc.getEngine().diff(ao, bo, rm, dc);
                    foundFromB.add(bIndex);
                    boolean bl = same = same && rm.isSame();
                    if (this.m_order && aIndex != bIndex) {
                        rlist.setListReordered(true);
                        same = false;
                    }
                    found = true;
                    break;
                }
                if (found) continue;
                removed.add(ao);
                ResultSet rm = new ResultSet(rlist, ao, null, aIndex, -1, this.getName(ao), "MAP");
                dc.getEngine().diff(ao, null, rm, dc);
                rm.setSame(false);
                rm.setA(ao);
                same = false;
            }
        }
        for (int bIndex = 0; bIndex < blist.size(); ++bIndex) {
            Object bo;
            if (foundFromB.contains(bIndex) || (bo = blist.get(bIndex)) == null) continue;
            added.add(bo);
            ResultSet rm = new ResultSet(rlist, null, bo, -1, bIndex, null, "MAP");
            dc.getEngine().diff(null, bo, rm, dc);
            rm.setSame(false);
            rm.setB(bo);
            same = false;
        }
        rlist.setSame(same);
        return true;
    }

    private String getName(Object obj) {
        String itemName = null;
        if (obj instanceof DBObjectID) {
            itemName = DBUtil.getDBObjectName((DBObjectID)obj);
        } else if (obj instanceof DBObject) {
            itemName = ((DBObject)obj).getName();
        }
        return itemName;
    }
}

