/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.Differ;
import oracle.javatools.db.diff.ResultSet;

public class GenericMapDiffer
implements Differ {
    public boolean diff(Object a, Object b, ResultSet r, DiffContext c) {
        Map aMap = (Map)a;
        Map bMap = (Map)b;
        r.setType("MAP");
        boolean result = true;
        Set keySuperSet = this.getCombinedKeySet(aMap, bMap);
        for (Object key : keySuperSet) {
            if (this.ignoreKey(key)) continue;
            ResultSet propertyRS = this.diffValue(aMap, bMap, key, r, c);
            result &= propertyRS.isSame();
        }
        r.setSame(result);
        return true;
    }

    protected Set getCombinedKeySet(Map aMap, Map bMap) {
        HashSet keySuperSet = new HashSet();
        if (aMap != null) {
            keySuperSet.addAll(aMap.keySet());
        }
        if (bMap != null) {
            keySuperSet.addAll(bMap.keySet());
        }
        return keySuperSet;
    }

    protected ResultSet diffValue(Map aMap, Map bMap, Object key, ResultSet mapRS, DiffContext c) {
        Object aValue = aMap == null ? null : aMap.get(key);
        Object bValue = bMap == null ? null : bMap.get(key);
        return this.diffValue((Object)aValue, (Object)bValue, key, mapRS, c);
    }

    protected ResultSet diffValue(Object aValue, Object bValue, Object key, ResultSet mapRS, DiffContext c) {
        ResultSet propertyRS = new ResultSet(mapRS, aValue, bValue, key.toString(), "MAP");
        if (aValue == null && bValue == null) {
            propertyRS.setSame(true);
        } else {
            c.getEngine().diff(aValue, bValue, propertyRS, c);
        }
        return propertyRS;
    }

    protected boolean ignoreKey(Object key) {
        return false;
    }
}

