/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Comparator;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.marshal.ToStringManager;

public class GenericComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        String s2;
        String s1;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -100;
        }
        if (o2 == null) {
            return 100;
        }
        if (o1 instanceof Comparable && o1.getClass().isAssignableFrom(o2.getClass())) {
            try {
                return ((Comparable)o1).compareTo(o2);
            }
            catch (Exception e) {
                DBLog.getLogger(this).log(Level.FINER, "Objects not comparable", e);
            }
        }
        if (o2 instanceof Comparable && o2.getClass().isAssignableFrom(o1.getClass())) {
            try {
                return 0 - ((Comparable)o2).compareTo(o1);
            }
            catch (Exception e) {
                DBLog.getLogger(this).log(Level.FINER, "Objects not comparable", e);
            }
        }
        if (ToStringManager.converterAvailable((Object)(o1 == null ? o1 : o2))) {
            s1 = ToStringManager.toString((Object)o1);
            s2 = ToStringManager.toString((Object)o2);
        } else {
            s1 = o1.toString();
            s2 = o2.toString();
        }
        try {
            Number i1 = o1 instanceof Number ? (Number)((Number)o1) : (Number)Double.parseDouble(s1);
            Number i2 = o2 instanceof Number ? (Number)((Number)o2) : (Number)Double.parseDouble(s2);
            return Double.valueOf(i1.doubleValue()).compareTo(i2.doubleValue());
        }
        catch (NumberFormatException nfe) {
            return s1.compareTo(s2);
        }
    }

    public boolean equals(Object obj) {
        return obj instanceof GenericComparator;
    }
}

