/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.db.diff.ResultSet;

public class DefaultResultSetFilter
implements DifferenceFilter {
    private Collection<String> m_filteredProps = new ArrayList<String>();

    public void addFilteredProps(String commaSepPropertyPaths) {
        String[] arrayList = commaSepPropertyPaths.split(",");
        for (int i = 0; i < arrayList.length; ++i) {
            arrayList[i] = arrayList[i].trim();
        }
        this.addFilteredProps(arrayList);
    }

    public void addFilteredProps(String[] propertyPathsArray) {
        for (int i = 0; i < propertyPathsArray.length; ++i) {
            this.m_filteredProps.add(propertyPathsArray[i].replaceAll("//", "/[^/]*/"));
        }
    }

    @Deprecated
    public boolean isFilteredProperty(ResultSet rs, String prop) {
        return this.isFilteredProperty((Difference)rs, prop);
    }

    public boolean isFilteredProperty(Difference rs, String prop) {
        if (prop != null) {
            for (String filteredProp : this.m_filteredProps) {
                if (prop.equals(filteredProp)) {
                    return true;
                }
                if (Pattern.matches(filteredProp, prop)) {
                    return true;
                }
                if (!Pattern.matches(filteredProp + "/.*", prop + "/")) continue;
                return true;
            }
        }
        return false;
    }
}

