/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Map;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.diff.DBObjectDiffer;
import oracle.javatools.db.diff.DiffContext;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BuildableDBObjectDiffer
extends DBObjectDiffer {
    private final PropertyHelper m_helper = new PropertyHelper();

    BuildableDBObjectDiffer() {
    }

    @Override
    protected ResultSet diffProperty(Object a, Object b, ResultSet r, DiffContext c, PropertyInfo prop, Map<String, PropertyInfo> beanProps) {
        DBObjectID bID;
        ResultSet retval = null;
        String propertyName = prop.getPropertyName();
        AbstractBuildableObject aObj = (AbstractBuildableObject)a;
        AbstractBuildableObject bObj = (AbstractBuildableObject)b;
        DBObjectID aID = aObj == null ? null : aObj.getID();
        DBObjectID dBObjectID = bID = bObj == null ? null : bObj.getID();
        if ((this.isTempCopy(aID, bID) || this.isTempCopy(bID, aID)) && this.bothNeedsBuilding(aObj, bObj, propertyName)) {
            retval = new LazyResultSet(r, prop);
        }
        if (retval == null) {
            retval = super.diffProperty(a, b, r, c, prop, beanProps);
        }
        return retval;
    }

    private boolean isTempCopy(DBObjectID id1, DBObjectID id2) {
        boolean retval = false;
        if (id1 instanceof TemporaryObjectID) {
            try {
                DBObjectID origID;
                DBObject orig = ((TemporaryObjectID)id1).resolveOriginalID();
                if (orig != null && (origID = orig.getID()) != null) {
                    retval = origID.equals(id2) || this.isTempCopy(origID, id2);
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        return retval;
    }

    private boolean bothNeedsBuilding(AbstractBuildableObject a, AbstractBuildableObject b, String propertyName) {
        boolean aNeedsBuilding = DBUtil.needsBuilding(a, propertyName);
        boolean bNeedsBuilding = DBUtil.needsBuilding(b, propertyName);
        return aNeedsBuilding && bNeedsBuilding;
    }

    private static String getResultSetType(PropertyInfo prop) {
        Class propClz = prop.getPropertyClass();
        if (propClz != null && propClz.isArray()) {
            return "LIST";
        }
        return "MAP";
    }

    private class LazyResultSet
    extends ResultSet {
        private final PropertyInfo m_prop;
        private final Object m_parentA;
        private final Object m_parentB;

        LazyResultSet(ResultSet parent, PropertyInfo prop) {
            this(parent, parent.a(), parent.b(), prop);
        }

        LazyResultSet(ResultSet parent, Object parentA, Object parentB, PropertyInfo prop) {
            super(parent, null, null, prop.getPropertyName(), BuildableDBObjectDiffer.getResultSetType(prop));
            this.m_prop = prop;
            this.m_parentA = parentA;
            this.m_parentB = parentB;
            this.setSame(true);
        }

        public Object a() {
            return BuildableDBObjectDiffer.this.m_helper.getPropertyValue(this.m_parentA, this.m_prop.getPropertyName());
        }

        public Object b() {
            return BuildableDBObjectDiffer.this.m_helper.getPropertyValue(this.m_parentB, this.m_prop.getPropertyName());
        }
    }
}

