/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Pattern;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ddl.DefaultTokenGenerator;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenGenerator;
import oracle.javatools.db.diff.DefaultResultSetFilter;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.marshal.ToStringManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TokenProcessor {
    private final Map<String, TokenGenerator> m_tokenGenerators = new HashMap<String, TokenGenerator>();
    private final PropertyHelper m_propHelper;
    private Collection<String> m_propSearch;

    TokenProcessor() {
        this(new PropertyHelper());
    }

    TokenProcessor(PropertyHelper propHelper) {
        this.registerDefaults();
        this.m_propHelper = propHelper;
    }

    private void registerDefaults() {
        this.registerGenerator("replace", new TokenGenerator.ReplaceGenerator());
        this.registerGenerator("cascade", new TokenGenerator.CascadeGenerator());
        this.registerGenerator("schema.name", new TokenGenerator.NameGenerator());
    }

    public void registerGenerator(String name, TokenGenerator generator) {
        String[] reservedWords;
        for (String s : reservedWords = new String[]{"each", "old", "this"}) {
            if (!name.startsWith(s)) continue;
            throw new TokenProcessorException("cannot register generator token names starting with \"" + s + "\"");
        }
        generator.setProcessor(this);
        TokenGenerator replaced = this.m_tokenGenerators.put(name, generator);
        if (replaced != null) {
            // empty if block
        }
    }

    PropertyHelper getPropertyHelper() {
        return this.m_propHelper;
    }

    boolean canProcess(Object obj) {
        return this.m_tokenGenerators.containsKey(this.getKey(obj));
    }

    private String getKey(Object obj) {
        if (obj instanceof DBObject) {
            String type = ((DBObject)obj).getType();
            if (obj instanceof Constraint) {
                return type + "." + ((Constraint)obj).getConstraintType();
            }
            return type;
        }
        return null;
    }

    void process(Object obj, TokenContext context) {
        String key = this.getKey(obj);
        TokenGenerator gen = this.m_tokenGenerators.get(key);
        if (gen == null) {
            throw new TokenProcessorException("No generator found for object " + key);
        }
        context.setProcessor(this);
        gen.generateToken(context);
    }

    public void process(String code, TokenContext context) {
        context.setProcessor(this);
        this.process(code, 0, code.length() - 1, context);
    }

    private void process(String code, int startAt, int endAt, TokenContext context) {
        while (startAt >= 0 && startAt <= endAt) {
            startAt = this.processNext(code, startAt, endAt, context);
        }
    }

    private int processNext(String code, int startAt, int endAt, TokenContext context) {
        if (startAt >= code.length() || startAt > endAt) {
            return -1;
        }
        char start = code.charAt(startAt);
        if (start == '[') {
            int blockEnd = TokenProcessor.findMatching('[', ']', code, ++startAt);
            this.processBlock(code, startAt, blockEnd - 1, context);
            return this.skipWhitespace(code, blockEnd + 1, context);
        }
        if (start == '{') {
            int tokenEnd = TokenProcessor.findMatching('{', '}', code, ++startAt);
            this.processToken(code, startAt, tokenEnd - 1, context, TokenAction.GENERATE);
            return this.skipWhitespace(code, tokenEnd + 1, context);
        }
        if (start == '\t') {
            context.append("  ");
            return ++startAt;
        }
        if (start == '\\') {
            if (this.isEscaped(code, startAt)) {
                context.append(Character.valueOf(start));
            }
            return ++startAt;
        }
        if (!this.isEscaped(code, startAt)) {
            if (start == '>') {
                context.incrementIndent();
                return ++startAt;
            }
            if (start == '<') {
                context.decrementIndent();
                return ++startAt;
            }
        }
        context.append(Character.valueOf(start));
        return ++startAt;
    }

    private boolean isEscaped(String code, int startAt) {
        return startAt > 0 && code.charAt(startAt - 1) == '\\';
    }

    private static int findMatching(char open, char close, String code, int startAt) {
        int nest = 0;
        for (int lookAt = startAt; lookAt < code.length(); ++lookAt) {
            char looking = code.charAt(lookAt);
            if (looking == open) {
                ++nest;
                continue;
            }
            if (looking != close || nest-- != 0) continue;
            return lookAt;
        }
        throw new TokenProcessorException(open, close, code, startAt);
    }

    private void processBlock(String code, int startAt, int endAt, TokenContext context) {
        String block = code.substring(startAt, endAt + 1);
        if (context.getBlock() != null) {
            context = context.newChildContext(null);
        }
        context.setBlock(block);
        boolean loop = block.endsWith("...");
        String seperator = "";
        if (loop) {
            boolean hasWhitespace = false;
            boolean quoted = false;
            if (code.charAt(endAt -= 3) == '\'') {
                quoted = true;
                --endAt;
            }
            while (endAt > startAt) {
                char sepTest = code.charAt(endAt);
                if (quoted) {
                    if (sepTest == '\'') {
                        if (code.charAt(--endAt) != ' ') break;
                        --endAt;
                        break;
                    }
                } else {
                    if (sepTest == ' ') {
                        --endAt;
                        break;
                    }
                    if (sepTest == '}' || sepTest == ']') break;
                }
                if (Character.isWhitespace(sepTest)) {
                    hasWhitespace = true;
                }
                seperator = sepTest + seperator;
                --endAt;
            }
            if (seperator.length() == 0) {
                seperator = ", ";
            } else if (!hasWhitespace) {
                seperator = " " + seperator + " ";
            }
        }
        boolean invert = false;
        char start = code.charAt(startAt);
        if (start == '!') {
            invert = true;
            start = code.charAt(++startAt);
        }
        if (start == '{') {
            int tokenEnd = TokenProcessor.findMatching('{', '}', code, ++startAt);
            Object[] tokenResult = this.processToken(code, startAt, tokenEnd - 1, context, loop ? TokenAction.FOREACH : TokenAction.IF);
            if (loop) {
                if (tokenResult != null) {
                    if (!(tokenResult instanceof Object[])) {
                        if (tokenResult instanceof Collection) {
                            tokenResult = ((Collection)tokenResult).toArray();
                        } else {
                            throw new TokenProcessorException("can't loop without an array property at index ", code, startAt);
                        }
                    }
                    int startAgainAt = this.skipWhitespace(code, tokenEnd + 1, context);
                    int length = context.length();
                    for (Object obj : tokenResult) {
                        if (obj == null) continue;
                        context.setLoopObject(obj);
                        if (context.length() > length) {
                            context.append(seperator);
                            length = context.length();
                        }
                        this.process(code, startAgainAt, endAt, context);
                    }
                }
                context.removeIfEndsWith(seperator);
                context.setLoopObject(null);
            } else {
                Boolean result = this.evaluateIf(tokenResult);
                if (result != null) {
                    int startAgainAt = this.skipWhitespace(code, tokenEnd + 1, context);
                    String blockCode = code.substring(startAgainAt, endAt + 1);
                    int elseStart = -1;
                    int innerBlock = 0;
                    int preC = 32;
                    for (int i = 0; i < blockCode.length(); ++i) {
                        char c = blockCode.charAt(i);
                        if (c == '[') {
                            ++innerBlock;
                        } else if (c == ']') {
                            ++innerBlock;
                        } else if (c == ':' && preC != 92 && innerBlock == 0) {
                            elseStart = i;
                            break;
                        }
                        preC = c;
                    }
                    if (result != null && result != invert) {
                        if (elseStart >= 0) {
                            endAt = this.ignoreWhitespace(code, startAgainAt + elseStart - 1, context);
                        }
                        this.process(code, startAgainAt, endAt, context);
                    } else if (elseStart >= 0) {
                        startAgainAt = this.skipWhitespace(code, startAgainAt + elseStart + 1, context);
                        this.process(code, startAgainAt, endAt, context);
                    }
                }
            }
        }
        context.setBlock(null);
    }

    private Object processToken(String code, int startAt, int endAt, TokenContext context, TokenAction action) {
        String tokenName = code.substring(startAt, endAt + 1);
        return this.processToken(tokenName, context, action);
    }

    private Object processToken(String tokenName, TokenContext context, TokenAction action) {
        char firstChar;
        Operator op = Operator.findOperator(tokenName);
        if (op != null) {
            return this.processOperator(op, tokenName, context, action);
        }
        boolean quote = false;
        if (tokenName.charAt(0) == '\"') {
            if (tokenName.charAt(tokenName.length() - 1) != '\"') {
                throw new TokenProcessorException("tokens starting with \" should end with \" to indiate quoting is required.");
            }
            if (tokenName.charAt(1) != '$') {
                throw new TokenProcessorException("token quoting is only available on property lookups (i.e. \"$propName\"");
            }
            quote = true;
            tokenName = tokenName.substring(1, tokenName.length() - 1);
        }
        if (tokenName.startsWith("each")) {
            Object loopObj = context.getLoopObject();
            if (loopObj == null) {
                throw new TokenProcessorException("\"each\" cannot be used outside of a loop");
            }
            if (tokenName.equals("each")) {
                context.append(loopObj);
                return null;
            }
            if (tokenName.startsWith("each.")) {
                String eachToken = tokenName.substring(5).trim();
                TokenContext tc = context.newChildContext(loopObj);
                return this.processToken(eachToken, tc, action);
            }
        } else {
            if (tokenName.startsWith("old.")) {
                String oldToken = tokenName.substring(4);
                if (!context.isUpdate()) {
                    throw new TokenProcessorException("\"old\" can only be used in update DDL");
                }
                if (tokenName.length() < 1) {
                    throw new TokenProcessorException("\"old.\" must be followed by a valid token");
                }
                Difference rs = context.getDifference();
                Object oldObj = rs.getOriginalObject();
                if (oldObj == null) {
                    throw new TokenProcessorException("no old object to process for token: " + tokenName);
                }
                return this.processToken(oldToken, context.newChildContext(oldObj), action);
            }
            if (tokenName.startsWith("this")) {
                if (tokenName.equals("this")) {
                    context.append(context.getObject());
                    return null;
                }
                if (tokenName.startsWith("this.")) {
                    tokenName = tokenName.substring(5);
                }
            }
        }
        if ((firstChar = tokenName.charAt(0)) == '$') {
            String propName = tokenName.substring(1);
            if (propName.trim().equals("*")) {
                return this.evaluateAllProperties(false, action, context);
            }
            return this.processProperty(propName, context, quote, action);
        }
        if (firstChar == '^') {
            if (!context.isUpdate()) {
                throw new TokenProcessorException("\"^\" can only be used in update DDL");
            }
            if (action == TokenAction.IF || action == TokenAction.FOREACH) {
                Object changed;
                block34: {
                    String propName = tokenName.substring(1);
                    if (propName.trim().equals("*")) {
                        return this.evaluateAllProperties(true, action, context);
                    }
                    if (propName.startsWith("^")) {
                        propName = propName.substring(1);
                        Difference rs = context.getDifference();
                        if (!rs.isSame()) {
                            DefaultResultSetFilter filter = new DefaultResultSetFilter();
                            filter.addFilteredProps(propName);
                            Difference filtered = rs.getFilteredDifference(filter);
                            return filtered.isSame();
                        }
                        return false;
                    }
                    changed = null;
                    try {
                        changed = this.getChangedProperty(propName, context);
                    }
                    catch (MissingPropertyException mpe) {
                        DBLog.getLogger(this).log(Level.FINE, mpe.getMessage());
                        if (action != TokenAction.IF) break block34;
                        return false;
                    }
                }
                return changed;
            }
            throw new TokenProcessorException("\"^\" can only be used in an if - e.g. [{^propThatChanged} NEW PROP TEXT]");
        }
        if (firstChar == '+' || firstChar == '-') {
            if (action != TokenAction.FOREACH && action != TokenAction.IF) {
                throw new TokenProcessorException("\"+\" and \"-\" can only be used in a loop or if - e.g. [{+newChildren} {each} ...]");
            }
            if (!context.isUpdate()) {
                throw new TokenProcessorException("\"+\" and \"-\" can only be used in update DDL");
            }
            String propName = tokenName.substring(1);
            try {
                Difference propRS = this.findChangedProperty(propName, context);
                if (propRS != null && !propRS.isSame()) {
                    return this.getObjects(propRS, firstChar == '+');
                }
            }
            catch (MissingPropertyException mpe) {
                DBLog.getLogger(this).log(Level.FINE, mpe.getMessage());
            }
            return null;
        }
        TokenGenerator gen = this.m_tokenGenerators.get(tokenName);
        if (gen == null) {
            throw new GeneratorMissingException(tokenName);
        }
        if (action == TokenAction.GENERATE) {
            gen.generateToken(context);
            return null;
        }
        return gen.evaluateToken(context);
    }

    private boolean evaluateAllProperties(boolean alter, TokenAction action, TokenContext context) {
        String block = context.getBlock();
        if (action == TokenAction.IF || block == null) {
            Object contextObj = context.getObject();
            Collection<String> props = this.getPropertyPaths(block, alter, context);
            for (String prop : props) {
                Boolean bval;
                Object value = false;
                if (alter) {
                    try {
                        value = this.getChangedProperty(prop, context);
                    }
                    catch (MissingPropertyException mpe) {}
                } else {
                    value = context.getPropertyValue(prop);
                }
                if ((bval = this.evaluateIf(value)) == null || !bval.booleanValue()) continue;
                return true;
            }
            return false;
        }
        char c = alter ? (char)'^' : '$';
        throw new TokenProcessorException("\"" + c + "*\" can only be used in an if - " + "e.g. [{" + c + "*} NEW [{" + c + "prop} PROP {$prop}]");
    }

    private String operatorArgToString(Object value) {
        if (value instanceof Difference) {
            return this.operatorArgToString(((Difference)value).getUpdatedObject());
        }
        if (ToStringManager.converterAvailable((Object)value)) {
            return ToStringManager.toString((Object)value);
        }
        return "" + value;
    }

    private boolean processOperator(Operator oper, String fullText, TokenContext context, TokenAction action) {
        String opText = Operator.toString(oper);
        int opStart = fullText.indexOf(opText);
        String param1 = this.stripCurlies(fullText.substring(0, opStart).trim());
        String param2 = this.stripCurlies(fullText.substring(opStart + opText.length()).trim());
        Object value1 = this.processToken(param1, context, action);
        String valueString1 = this.operatorArgToString(value1);
        Object value2 = null;
        String valueString2 = null;
        try {
            if (this.m_tokenGenerators.get(param2) instanceof DefaultTokenGenerator) {
                throw new GeneratorMissingException(param2);
            }
            value2 = this.processToken(param2, context, action);
            valueString2 = this.operatorArgToString(value2);
        }
        catch (GeneratorMissingException gme) {
            valueString2 = param2;
        }
        if (valueString2.contains(",")) {
            String[] banana = valueString2.split(",");
            HashSet<String> vars = new HashSet<String>(banana.length);
            for (String v : banana) {
                vars.add(v.trim());
            }
            boolean result = vars.contains(valueString1);
            return oper == Operator.EQ == result;
        }
        boolean param2IsNull = valueString2.equals("null");
        if (oper == Operator.EQ) {
            if (value1 == null) {
                return param2IsNull;
            }
            return valueString1.equals(valueString2);
        }
        if (oper == Operator.NE) {
            if (value1 == null) {
                return !param2IsNull;
            }
            return !valueString1.equals(valueString2);
        }
        if (oper == Operator.AND || oper == Operator.OR) {
            boolean b1 = false;
            if (valueString1 != null && value1 != null) {
                boolean bl = b1 = !valueString1.equalsIgnoreCase("false");
            }
            if (b1 && oper == Operator.OR) {
                return true;
            }
            if (!b1 && oper == Operator.AND) {
                return false;
            }
            boolean b2 = false;
            if (valueString2 != null && !param2IsNull) {
                b2 = !valueString2.equalsIgnoreCase("false");
            }
            return b2;
        }
        if (value1 instanceof Number) {
            int valueInt = ((Number)value1).intValue();
            Integer num = null;
            num = value2 instanceof Number ? Integer.valueOf(((Number)value2).intValue()) : Integer.valueOf(valueString2);
            int comparison = new Integer(valueInt).compareTo(num);
            if (oper == Operator.LE) {
                return comparison <= 0;
            }
            if (oper == Operator.GE) {
                return comparison >= 0;
            }
            if (oper == Operator.LT) {
                return comparison < 0;
            }
            if (oper == Operator.GT) {
                return comparison > 0;
            }
        }
        return false;
    }

    private String stripCurlies(String s) {
        if ((s = s.trim()).startsWith("{") && s.endsWith("}")) {
            return s.substring(1, s.length() - 1);
        }
        return s;
    }

    private Object[] getObjects(Difference propRS, boolean create) {
        Collection<? extends Difference> children = propRS.getChildren();
        ArrayList<Object> result = new ArrayList<Object>();
        for (Difference difference : children) {
            if (difference.isSame()) continue;
            Object original = difference.getOriginalObject();
            Object updated = difference.getUpdatedObject();
            if (create) {
                if (original != null) continue;
                result.add(updated);
                continue;
            }
            if (updated != null) continue;
            result.add(original);
        }
        return result.toArray();
    }

    private Object getChangedProperty(String tokenName, TokenContext context) throws MissingPropertyException {
        Difference propRs = this.findChangedProperty(tokenName, context);
        if (propRs != null) {
            if (propRs.isList()) {
                ArrayList<Difference> result = new ArrayList<Difference>();
                Collection<? extends Difference> mol = propRs.getChildren();
                for (Difference difference : mol) {
                    if (!difference.isModified()) continue;
                    result.add(difference);
                }
                return result;
            }
            return propRs;
        }
        return null;
    }

    private Difference findChangedProperty(String tokenName, TokenContext context) throws MissingPropertyException {
        Difference rs = context.getDifference();
        if (rs == null) {
            throw new TokenProcessorException("Processing update code requires a Difference");
        }
        return this.m_propHelper.getChildDifference(rs, tokenName);
    }

    private Object processProperty(String tokenName, TokenContext context, boolean quote, TokenAction action) {
        String propName = tokenName.trim();
        Object value = context.getPropertyValue(propName);
        if (action == TokenAction.GENERATE) {
            if (quote) {
                context.appendName((String)value);
            } else {
                context.append(value);
            }
        } else {
            return value;
        }
        return null;
    }

    private int skipWhitespace(String code, int startAt, TokenContext context) {
        if (context.length() == 0 || context.endsWithWhitespace()) {
            while (startAt < code.length() && ' ' == code.charAt(startAt)) {
                ++startAt;
            }
        }
        return startAt;
    }

    private int ignoreWhitespace(String code, int endAt, TokenContext context) {
        if (context.endsWithWhitespace()) {
            while (endAt >= 0 && Character.isWhitespace(code.charAt(endAt))) {
                --endAt;
            }
        }
        return endAt;
    }

    private Boolean evaluateIf(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Difference) {
            return !((Difference)obj).isSame();
        }
        if (obj instanceof Collection) {
            return !((Collection)obj).isEmpty();
        }
        if (obj instanceof Object[]) {
            return ((Object[])obj).length > 0;
        }
        return true;
    }

    private Collection<String> getPropertyPaths(String code, boolean alter, TokenContext context) {
        String type = null;
        Object obj = context.getObject();
        if (obj instanceof DBObject) {
            type = ((DBObject)obj).getType();
        }
        return this.findProperties(code, alter, type, context.getProvider());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<String> getCreatePropertyPaths(String code, String type, DBObjectProvider provider) {
        try {
            this.initPropertySearch();
            Collection<String> collection = this.findProperties(code, false, type, provider);
            return collection;
        }
        finally {
            this.endPropertySearch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Collection<String> getAlterPropertyPaths(String code, String type, DBObjectProvider provider) {
        try {
            this.initPropertySearch();
            Collection<String> collection = this.findProperties(code, true, type, provider);
            return collection;
        }
        finally {
            this.endPropertySearch();
        }
    }

    private void initPropertySearch() {
        if (this.m_propSearch != null) {
            throw new IllegalArgumentException("Cannot perform two property searches at once!");
        }
        this.m_propSearch = new ArrayList<String>();
    }

    private void endPropertySearch() {
        this.m_propSearch = null;
    }

    Collection<String> findProperties(String code, boolean alter, String type, DBObjectProvider pro) {
        TreeSet<String> retval = new TreeSet<String>();
        this.findProperties(code, retval, alter, type, pro);
        return retval;
    }

    private void findProperties(String code, Collection<String> retval, boolean alter, String type, DBObjectProvider pro) {
        for (int i = 0; i < code.length(); ++i) {
            int blockEnd;
            String block;
            char next = code.charAt(i);
            if (next == '[' && (block = code.substring(i + 1, blockEnd = TokenProcessor.findMatching('[', ']', code, i + 1))).endsWith("...")) {
                ArrayList<String> blockToks = new ArrayList<String>();
                this.findProperties(block, blockToks, alter, type, pro);
                if (blockToks.size() > 0) {
                    String baseTok = (String)blockToks.get(0);
                    retval.add(baseTok);
                    for (int j = 1; j < blockToks.size(); ++j) {
                        retval.add(baseTok + "/" + (String)blockToks.get(j));
                    }
                    if (block.contains("{each}")) {
                        this.findSubProperties(retval, type, alter, pro, baseTok);
                    }
                }
                i = blockEnd;
                continue;
            }
            if (next != '{') continue;
            int tokenEnd = TokenProcessor.findMatching('{', '}', code, i + 1);
            String token = code.substring(i + 1, tokenEnd);
            this.findPropertiesInToken(token, retval, alter, type, pro);
            i = tokenEnd;
        }
    }

    private void findSubProperties(Collection<String> retval, String type, boolean alter, DBObjectProvider pro, String propPath) {
        PropertyInfo info;
        Class<? extends DBObject> objclz = Metadata.getInstance().getObjectClass(type);
        if (objclz != null && (info = this.findPropertyInfo(objclz, null, propPath)) != null) {
            String propType;
            TokenGenerator g;
            Class<?> propClass = info.getPropertyClass();
            if (propClass.isArray()) {
                propClass = propClass.getComponentType();
            }
            if (DBObject.class.isAssignableFrom(propClass) && (g = this.m_tokenGenerators.get(propType = Metadata.getType(propClass))) != null) {
                Collection<String> props = this.getGeneratorProperties(g, propType, alter, pro);
                for (String finallyThere : props) {
                    retval.add(propPath + "/" + finallyThere);
                }
            }
        }
    }

    private boolean isProperty(String token, boolean alter) {
        char[] cArray;
        if (alter) {
            char[] cArray2 = new char[3];
            cArray2[0] = 94;
            cArray2[1] = 43;
            cArray = cArray2;
            cArray2[2] = 45;
        } else {
            char[] cArray3 = new char[1];
            cArray = cArray3;
            cArray3[0] = 36;
        }
        char[] ident = cArray;
        boolean prop = false;
        char start = token.charAt(0);
        for (int i = 0; i < ident.length; ++i) {
            if (start != ident[i]) continue;
            prop = true;
        }
        return prop;
    }

    private void findPropertiesInToken(String token, Collection<String> retval, boolean alter, String type, DBObjectProvider pro) {
        Operator oper;
        int length = token.length();
        if (length > 1 && token.charAt(0) == '\"' && token.charAt(length - 1) == '\"') {
            token = token.substring(1, token.length() - 1);
        }
        if ((oper = Operator.findOperator(token)) != null) {
            String[] args;
            for (String s : args = token.split(Pattern.quote(Operator.toString(oper)))) {
                String tokParam = s.trim();
                if (!this.isProperty(tokParam, alter)) continue;
                this.findPropertiesInToken(tokParam, retval, alter, type, pro);
            }
        } else {
            if (token.startsWith("each.")) {
                token = token.substring(5);
            }
            if (this.isProperty(token, alter)) {
                String propName = token.substring(1);
                retval.add(propName);
                this.findSubProperties(retval, type, alter, pro, propName);
            } else {
                TokenGenerator g = this.m_tokenGenerators.get(token);
                if (g != null) {
                    retval.addAll(this.getGeneratorProperties(g, type, alter, pro));
                }
            }
        }
    }

    private Collection<String> getGeneratorProperties(TokenGenerator g, String type, boolean alter, DBObjectProvider pro) {
        ArrayList<String> oldPropSearch = null;
        if (this.m_propSearch != null) {
            oldPropSearch = new ArrayList<String>(this.m_propSearch);
            this.m_propSearch.add(type);
        }
        Collection<Object> props = oldPropSearch != null && this.isOverTheLimit(oldPropSearch, type) ? Collections.emptyList() : (alter ? g.getPropertiesAltered(type, pro) : g.getPropertiesProcessed(type, pro));
        if (oldPropSearch != null) {
            this.m_propSearch = oldPropSearch;
        }
        return props;
    }

    private boolean isOverTheLimit(Collection<String> stack, String type) {
        int count = 0;
        for (String s : stack) {
            if (!s.equals(type)) continue;
            ++count;
        }
        return count > 2;
    }

    private PropertyInfo findPropertyInfo(Class clz, Class<? extends DBObjectProvider> proClz, String prop) {
        return PropertyHelper.findPropertyInfo(clz, prop, proClz);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Operator {
        OR,
        AND,
        EQ,
        NE,
        LE,
        GE,
        LT,
        GT;

        private static String[] strings;

        public static Operator findOperator(String haystack) {
            int closeCurly;
            int curly = haystack.indexOf(123);
            while (curly >= 0 && (closeCurly = TokenProcessor.findMatching('{', '}', haystack, curly + 1)) >= 0) {
                haystack = haystack.substring(0, curly) + haystack.substring(closeCurly + 1);
                curly = haystack.indexOf(123);
            }
            for (int i = 0; i < strings.length; ++i) {
                if (!haystack.contains(strings[i])) continue;
                return Operator.values()[i];
            }
            return null;
        }

        public static String toString(Operator oper) {
            Operator[] opers = Operator.values();
            for (int i = 0; i < opers.length; ++i) {
                if (opers[i] != oper) continue;
                return strings[i];
            }
            return null;
        }

        static {
            strings = new String[]{"||", "&&", "==", "!=", "<=", ">=", "<", ">"};
        }
    }

    static class GeneratorMissingException
    extends TokenProcessorException {
        public GeneratorMissingException(String token) {
            super("No generator found for token " + token);
        }
    }

    static class TokenProcessorException
    extends IllegalStateException {
        public TokenProcessorException(String msg) {
            super(msg);
        }

        public TokenProcessorException(String error, String code, int startAt) {
            super(error + " at index " + startAt);
        }

        public TokenProcessorException(char open, char missing, String code, int startAt) {
            super("Missing " + missing + " to match opening " + open + " at index " + startAt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenAction {
        IF,
        FOREACH,
        GENERATE;

    }
}

