/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ddl.TokenContext;
import oracle.javatools.db.ddl.TokenProcessor;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TokenGenerator {
    private TokenProcessor m_processor;

    public abstract void generateToken(TokenContext var1);

    public abstract Object evaluateToken(TokenContext var1);

    public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
        return Collections.emptyList();
    }

    public Collection<String> getPropertiesAltered(String type, DBObjectProvider pro) {
        return Collections.emptyList();
    }

    protected final TokenProcessor getProcessor() {
        return this.m_processor;
    }

    void setProcessor(TokenProcessor processor) {
        this.m_processor = processor;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class NameGenerator
    extends TokenGenerator {
        public static final String TOKEN = "schema.name";

        @Override
        public void generateToken(TokenContext context) {
            Object value = context.getObject();
            if (value instanceof PlSql) {
                Schema plsSchema;
                PlSql pls = (PlSql)value;
                PlSqlInterrogator pi = pls.getSourceInterrogator();
                String plsName = pi.getName();
                if (!ModelUtil.hasLength((String)plsName)) {
                    plsName = this.getExternalName(context.getProvider(), pls.getName());
                }
                if ((ModelUtil.hasLength((String)pls.getSource()) || context.getProvider() instanceof Database) && (plsSchema = pls.getSchema()) != null) {
                    String schemaInSource = pi.getSchemaName();
                    String destSchemaName = plsSchema.getName();
                    if (schemaInSource != null) {
                        if (destSchemaName.equalsIgnoreCase(schemaInSource)) {
                            context.append(schemaInSource);
                            context.append(".");
                        } else {
                            context.appendSchemaName(this.getExternalName(context.getProvider(), destSchemaName));
                        }
                    } else {
                        context.appendSchemaName(this.getExternalName(context.getProvider(), destSchemaName));
                    }
                }
                context.append(plsName);
            } else if (value instanceof DBObject) {
                Schema valueSchema;
                if (value instanceof SchemaObject && (valueSchema = (Schema)context.getPropertyValue("schema")) != null) {
                    context.appendSchemaName(valueSchema.getName());
                }
                context.appendName((String)context.getPropertyValue("name"));
            } else {
                context.append(value);
            }
        }

        private String getExternalName(DBObjectProvider pro, String name) {
            return pro == null ? name : pro.getExternalName(name);
        }

        @Override
        public Object evaluateToken(TokenContext context) {
            return null;
        }

        @Override
        public Collection<String> getPropertiesProcessed(String type, DBObjectProvider pro) {
            return Arrays.asList("name", "schema");
        }
    }

    public static final class CascadeGenerator
    extends TokenGenerator {
        public static final String TOKEN = "cascade";

        public void generateToken(TokenContext context) {
        }

        public Object evaluateToken(TokenContext context) {
            return context.getOptions().isCascade();
        }
    }

    public static final class ReplaceGenerator
    extends TokenGenerator {
        public static final String TOKEN = "replace";

        public void generateToken(TokenContext context) {
            if (context.getOptions().isReplace()) {
                context.append("OR REPLACE");
            }
        }

        public Object evaluateToken(TokenContext context) {
            return context.getOptions().isReplace();
        }
    }
}

