/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.ddl.AbstractDDLGenerator;
import oracle.javatools.db.ddl.AlterDDLGenerator;
import oracle.javatools.db.ddl.CreateDDLGenerator;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.DropDDLGenerator;
import oracle.javatools.db.ddl.GeneratorCache;
import oracle.javatools.db.ddl.UndeleteDDLGenerator;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.property.MissingPropertyException;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DDLGeneratorImpl<T extends DDLType>
extends AbstractDDLGenerator {
    private final PropertyHelper m_propHelper = new PropertyHelper();
    private final GeneratorCache m_cache = new GeneratorCache();

    public DDLGeneratorImpl(DBObjectProvider pro) {
        super(pro);
    }

    protected PropertyHelper getPropertyHelper() {
        return this.m_propHelper;
    }

    private List<CreateDDLGenerator> getCreateGenerators(String type) {
        return this.m_cache.getGenerators(CreateDDLGenerator.class, type);
    }

    protected final void registerCreateGenerator(String type, CreateDDLGenerator creator) {
        this.m_cache.registerGenerator(CreateDDLGenerator.class, type, creator);
    }

    private List<DropDDLGenerator> getDropGenerators(String type) {
        return this.m_cache.getGenerators(DropDDLGenerator.class, type);
    }

    protected final void registerDropGenerator(String type, DropDDLGenerator dropper) {
        this.m_cache.registerGenerator(DropDDLGenerator.class, type, dropper);
    }

    private List<AlterDDLGenerator> getAlterGenerators(String type) {
        return this.m_cache.getGenerators(AlterDDLGenerator.class, type);
    }

    protected final void registerAlterGenerator(String type, AlterDDLGenerator deletor) {
        this.m_cache.registerGenerator(AlterDDLGenerator.class, type, deletor);
    }

    private List<UndeleteDDLGenerator> getUndeleteGenerators(String type) {
        return this.m_cache.getGenerators(UndeleteDDLGenerator.class, type);
    }

    protected final void registerUndeleteGenerator(String type, UndeleteDDLGenerator undeletor) {
        this.m_cache.registerGenerator(UndeleteDDLGenerator.class, type, undeletor);
    }

    protected final void copyGenerators(DDLGeneratorImpl other, String type, boolean incAlter) {
        for (CreateDDLGenerator createDDLGenerator : this.getCreateGenerators(type)) {
            other.registerCreateGenerator(type, createDDLGenerator);
        }
        for (DropDDLGenerator dropDDLGenerator : this.getDropGenerators(type)) {
            other.registerDropGenerator(type, dropDDLGenerator);
        }
        if (incAlter) {
            for (AlterDDLGenerator alterDDLGenerator : this.getAlterGenerators(type)) {
                other.registerAlterGenerator(type, alterDDLGenerator);
            }
        }
    }

    private DBObject[] getChildList(DBObject obj, String propPath) {
        DBObject[] val = this.getPropertyHelper().getPropertyValue(obj, propPath);
        if (val != null) {
            if (val instanceof DBObject) {
                val = new DBObject[]{(DBObject)val};
            } else if (val instanceof List) {
                try {
                    val = ((List)val).toArray(new DBObject[((List)val).size()]);
                }
                catch (Exception e) {
                    DBLog.getLogger(this).log(Level.FINE, "Couldn't fix list for ddlgen");
                }
            }
        }
        return val instanceof DBObject[] ? (DBObject[])val : null;
    }

    protected final void registerTopLevelChild(String type, final String propPath, final String childType) {
        if (type == null || propPath == null || childType == null) {
            throw new NullPointerException();
        }
        this.registerCreateGenerator(type, new CreateDDLGenerator(){

            public DDL getCreateDDL(DDLOptions options, DBObject obj) {
                if (options.isReplace()) {
                    options = (DDLOptions)((Object)options.copyTo((Object)new DDLOptions()));
                    options.setReplace(false);
                }
                DDL retval = null;
                DBObject[] children = DDLGeneratorImpl.this.getChildList(obj, propPath);
                if (children != null) {
                    retval = DDLGeneratorImpl.this.getCreateDDL(options, children);
                }
                return retval;
            }

            public boolean canReplace() {
                for (CreateDDLGenerator gen : DDLGeneratorImpl.this.getCreateGenerators(childType)) {
                    if (!gen.canReplace()) continue;
                    return true;
                }
                return false;
            }

            public boolean canCreate(String property) {
                if (propPath.equals(property)) {
                    return true;
                }
                String fullProp = propPath + "/" + property;
                for (CreateDDLGenerator gen : DDLGeneratorImpl.this.getCreateGenerators(childType)) {
                    if (!gen.canCreate(property)) continue;
                    return true;
                }
                return false;
            }
        });
        this.registerAlterGenerator(type, new AlterDDLGenerator(){

            public DDL getAlterDDL(DDLOptions options, Difference parDiff) {
                DDL retval = null;
                try {
                    Difference diff = DDLGeneratorImpl.this.getPropertyHelper().getChildDifference(parDiff, propPath);
                    if (diff != null && !diff.isSame() && DBObject[].class.isAssignableFrom(diff.getDifferenceClass())) {
                        for (Difference difference : diff.getChildren()) {
                            if (difference.isSame()) continue;
                            if (difference.isModified()) {
                                if (!options.isReplace()) {
                                    options = (DDLOptions)((Object)options.copyTo((Object)new DDLOptions()));
                                    options.setReplace(true);
                                }
                                retval = DDLGeneratorImpl.this.append(retval, DDLGeneratorImpl.this.getUpdateDDL(options, difference));
                                continue;
                            }
                            DBObject orig = (DBObject)difference.getOriginalObject();
                            if (orig == null) {
                                retval = DDLGeneratorImpl.this.append(retval, DDLGeneratorImpl.this.getCreateDDL(options, (DBObject)difference.getUpdatedObject()));
                                continue;
                            }
                            retval = DDLGeneratorImpl.this.append(retval, DDLGeneratorImpl.this.getDeleteDDL(options, orig));
                        }
                    }
                }
                catch (MissingPropertyException mpe) {
                    DDLGeneratorImpl.this.getLogger().log(Level.FINE, mpe.getMessage());
                }
                return retval;
            }

            public boolean canAlter(String property) {
                if (propPath.equals(property)) {
                    return true;
                }
                String fullProp = propPath + "/" + property;
                for (AlterDDLGenerator gen : DDLGeneratorImpl.this.getAlterGenerators(childType)) {
                    if (!gen.canAlter(property)) continue;
                    return true;
                }
                return false;
            }
        });
    }

    private DDL append(DDL ddl1, DDL ddl2) {
        if (ddl1 == null) {
            return ddl2;
        }
        if (ddl2 != null) {
            ddl1.append(ddl2);
        }
        return ddl1;
    }

    @Override
    protected DDL<T> getCreateDDLImpl(DDLOptions options, DBObject ... objects) {
        DDL ddl = null;
        for (DBObject obj : objects) {
            List<CreateDDLGenerator> gens;
            if (ddl == null) {
                ddl = new DDL();
            }
            if ((gens = this.getCreateGenerators(obj.getType())) == null || gens.size() == 0) {
                throw UnsupportedDDLException.createNotSupported(obj);
            }
            boolean deleteRequired = true;
            for (CreateDDLGenerator gen : gens) {
                if (gen.canReplace()) {
                    deleteRequired = false;
                }
                ddl.append(gen.getCreateDDL(options, obj));
            }
            if (!options.isReplace() || !deleteRequired) continue;
            DBObject existing = null;
            if (this.getProvider() != null) {
                try {
                    existing = DBUtil.getProviderDefinition(obj, this.getProvider());
                }
                catch (DBException dbe) {
                    this.getLogger().log(Level.WARNING, "Couldn't get existing object for DROP", dbe);
                }
            }
            ddl.append(this.getDeleteDDL(options, existing == null ? obj : existing));
        }
        return this.finish(options, ddl);
    }

    @Override
    protected DDL<T> getDeleteDDLImpl(DDLOptions options, DBObject ... objects) {
        DDL ddl = null;
        for (DBObject obj : objects) {
            List<DropDDLGenerator> gens;
            if (ddl == null) {
                ddl = new DDL();
            }
            if ((gens = this.getDropGenerators(obj.getType())) == null || gens.size() == 0) {
                throw UnsupportedDDLException.deleteNotSupported(obj);
            }
            for (DropDDLGenerator gen : gens) {
                ddl.append(gen.getDropDDL(options, obj));
            }
        }
        return this.finish(options, ddl);
    }

    @Override
    public DDL<T> getUndeleteDDL(DDLOptions options, DBObject ... objects) {
        DDL ddl = null;
        for (DBObject obj : objects) {
            List<UndeleteDDLGenerator> gens;
            if (ddl == null) {
                ddl = new DDL();
            }
            if ((gens = this.getUndeleteGenerators(obj.getType())) == null || gens.size() == 0) {
                throw UnsupportedDDLException.undeleteNotSupported(obj);
            }
            for (UndeleteDDLGenerator gen : gens) {
                ddl.append(gen.getUndeleteDDL(options, obj));
            }
        }
        return this.finish(options, ddl);
    }

    @Override
    protected DDL<T> getUpdateDDLImpl(DDLOptions options, Difference rs) {
        DDL ddl = null;
        PropertyAction action = this.canUpdateObject(rs);
        if (action != null && action.getType() == PropertyAction.Type.ALTER) {
            DBObject orig = (DBObject)rs.getOriginalObject();
            String type = orig.getType();
            List<AlterDDLGenerator> gens = this.getAlterGenerators(type);
            if (gens == null || gens.size() == 0) {
                throw UnsupportedDDLException.updateNotSupported(orig);
            }
            for (AlterDDLGenerator ddlgen : gens) {
                DDL next = ddlgen.getAlterDDL(options, rs);
                if (next == null || next.size() <= 0) continue;
                if (ddl == null) {
                    ddl = next;
                    continue;
                }
                ddl.append(next);
            }
        } else {
            DBObject old = (DBObject)rs.getOriginalObject();
            DBObject updated = (DBObject)rs.getUpdatedObject();
            if (options.isReplace()) {
                if (this.canReplace(old.getType()) && !this.hasNameChanged(rs)) {
                    ddl = this.getCreateDDLImpl(options, updated);
                } else {
                    ddl = this.getDeleteDDL(options, old);
                    DDLOptions options2 = (DDLOptions)((Object)options.copyTo(null));
                    options2.setReplace(false);
                    ddl.append(this.getCreateDDL(options2, updated));
                }
            } else {
                throw new UnsupportedDDLException(DBArb.getString(422), old);
            }
        }
        return this.finish(options, ddl);
    }

    private boolean hasNameChanged(Difference d) {
        boolean retval = false;
        if (DBObject.class.isAssignableFrom(d.getDifferenceClass())) {
            try {
                Difference nameDiff = this.getPropertyHelper().getChildDifference(d, "name");
                if (nameDiff != null) {
                    retval = nameDiff.isSame();
                }
            }
            catch (MissingPropertyException mpe) {
                DBLog.getLogger(this).log(Level.WARNING, "Expected name property to exist.");
            }
        }
        return true;
    }

    @Override
    protected boolean canCreate(String type, String prop) {
        List<CreateDDLGenerator> gens = this.getCreateGenerators(type);
        for (CreateDDLGenerator ddlgen : gens) {
            if (!ddlgen.canCreate(prop)) continue;
            return true;
        }
        return super.canCreate(type, prop);
    }

    protected DDL<T> finish(DDLOptions options, DDL<T> ddl) {
        if (options.isIncludePrompts()) {
            return ddl.copyWithPrompts();
        }
        return ddl;
    }

    @Override
    public boolean supportsAction(String type, PropertyAction.Type actionType) {
        boolean supported = false;
        switch (actionType) {
            case CREATE: 
            case REPLACE: {
                supported = this.m_cache.containsType(CreateDDLGenerator.class, type);
                break;
            }
            case ALTER: {
                supported = this.m_cache.containsType(AlterDDLGenerator.class, type);
                break;
            }
            case DELETE: {
                supported = this.m_cache.containsType(DropDDLGenerator.class, type);
                break;
            }
            case UNDELETE: {
                supported = this.m_cache.containsType(UndeleteDDLGenerator.class, type);
            }
        }
        if (!supported) {
            supported = super.supportsAction(type, actionType);
        }
        return supported;
    }

    @Override
    protected boolean canChangeWithAlter(DBObject orig, DBObject update, String prop) {
        String type = update.getType();
        List<AlterDDLGenerator> gens = this.getAlterGenerators(type);
        for (AlterDDLGenerator ddlgen : gens) {
            if (!ddlgen.canAlter(prop)) continue;
            return true;
        }
        return false;
    }

    private boolean canReplace(String type) {
        boolean canReplace = false;
        List<CreateDDLGenerator> gens = this.getCreateGenerators(type);
        for (CreateDDLGenerator gen : gens) {
            if (!gen.canReplace()) continue;
            canReplace = true;
            break;
        }
        return canReplace;
    }
}

