/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.NameInUseException;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemplateExpander;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLStatementWrapper;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.execute.StatementWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.db.property.PropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DDLDatabase
extends AbstractDatabase {
    protected DDLDatabase(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
        this.reconnected(conn);
    }

    @Override
    public DDLGenerator getDDLGenerator() {
        DatabaseDescriptor desc = this.getDescriptor();
        if (desc != null) {
            return desc.getDDLGenerator(this);
        }
        return null;
    }

    private DDLGenerator getDDLGeneratorOrFail() throws UnsupportedOperationException {
        DDLGenerator gen = this.getDDLGenerator();
        if (gen == null) {
            throw new UnsupportedOperationException("DDL generation not supported.");
        }
        return gen;
    }

    @Override
    protected final Collection<SystemObject> listObjectsImpl(String[] objectTypes, Schema schema, String ref) throws DBException {
        return super.listObjectsImpl(objectTypes, schema, ref);
    }

    @Override
    public DiffEngine getDiffEngine() {
        return GenericDiffEngine.getDiffEngine(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean executeDDL(DDL ddl, boolean ignoreErrors) throws DBException {
        boolean retval = false;
        if (ddl.size() >= 1) {
            boolean autoCommitSwitch = false;
            try {
                ConnectionWrapper wrapper = new ConnectionWrapper(this, "");
                autoCommitSwitch = wrapper.call(new ConnectionWrapper.SQLCallable<Boolean>(wrapper){

                    @Override
                    public Boolean call() throws SQLException {
                        boolean ddlCausesCommit = this.getConnection().getMetaData().dataDefinitionCausesTransactionCommit();
                        return !ddlCausesCommit && !this.getConnection().getAutoCommit();
                    }
                });
            }
            catch (DBException dbe) {
                DBLog.getLogger(this).log(Level.WARNING, dbe.getMessage());
            }
            DDLStatementWrapper wrap = new DDLStatementWrapper((Database)this, ddl);
            wrap.setIgnoreErrors(ignoreErrors);
            try {
                retval = ((StatementWrapper)wrap).execute();
                Object var7_7 = null;
                if (autoCommitSwitch) {
                    this.setAutoCommit(true);
                }
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (autoCommitSwitch) {
                    this.setAutoCommit(true);
                }
                throw throwable;
            }
        }
        return retval;
    }

    private void setAutoCommit(final boolean autoCommit) {
        ConnectionWrapper wrapper = new ConnectionWrapper(this, DBArb.getString(433));
        try {
            ConnectionWrapper connectionWrapper = wrapper;
            connectionWrapper.getClass();
            wrapper.call(new ConnectionWrapper.SQLCallable(connectionWrapper){

                public Object call() throws SQLException {
                    this.getConnection().setAutoCommit(autoCommit);
                    return null;
                }
            });
        }
        catch (DBException dbe) {
            DBLog.getLogger(this).log(Level.WARNING, dbe.getMessage());
        }
    }

    @Override
    public final boolean canCreate(SystemObject object, boolean replace) {
        boolean retval = false;
        DDLGenerator gen = this.getDDLGenerator();
        if (gen != null) {
            boolean exists = this.exists(object);
            if (replace || !exists) {
                PropertyAction.Type actionType;
                String type = object.getType();
                PropertyAction.Type type2 = actionType = exists ? PropertyAction.Type.REPLACE : PropertyAction.Type.CREATE;
                if (gen.supportsAction(type, actionType)) {
                    retval = this.skipPrivCheck(type) ? true : this.hasPriviledge(type, DBUtil.getSchema(object), "CREATE");
                }
            }
        }
        return retval;
    }

    @Override
    public final boolean canDelete(SystemObject obj, boolean cascade) {
        String type;
        boolean retval = false;
        DDLGenerator gen = this.getDDLGenerator();
        if (gen != null && this.exists(obj) && gen.supportsAction(type = obj.getType(), PropertyAction.Type.DELETE)) {
            retval = this.skipPrivCheck(type) ? true : this.hasPriviledge(type, DBUtil.getSchema(obj), "DELETE");
        }
        return retval;
    }

    private boolean skipPrivCheck(String type) {
        return DBObjectRegistry.isExtensionType(type, this.getDatabaseType(), this.getDatabaseVersion());
    }

    @Override
    public final void createSchema(Schema schema, boolean replace) throws DBException {
        Schema oldSchema;
        if (schema == null) {
            throw new IllegalArgumentException("null Schema in createSchema");
        }
        if (this.getSchema(schema.getName()) == null) {
            replace = false;
        } else if (!replace) {
            throw new NameInUseException(schema);
        }
        DDL ddl = null;
        DDLGenerator gen = this.getDDLGeneratorOrFail();
        try {
            ddl = gen.getCreateDDL(new DDLOptions(replace, true), schema);
        }
        catch (UnsupportedDDLException uoe) {
            uoe.throwDBException();
        }
        if (ddl == null || ddl.size() == 0) {
            UnsupportedDDLException.createNotSupported(schema);
        }
        if (replace && (oldSchema = this.getSchema(schema.getName())) != null) {
            if (oldSchema == schema) {
                throw new IllegalArgumentException("Cannot replace schema with itself");
            }
            if (!this.canDelete(oldSchema, true)) {
                throw new DBException((DBObject)schema, "Cannot drop existing schema " + oldSchema.getName());
            }
        }
        this.executeDDL(ddl, false);
        Schema newSchema = this.getSchema(schema.getName());
        if (newSchema == null) {
            throw new DBException((DBObject)schema, "Created schema wasn't found in the database.");
        }
        this.fireSchemaAdded(newSchema);
    }

    @Override
    public final void deleteSchema(Schema schema, boolean cascade) throws DBException {
        schema = this.getSchema(schema.getName());
        DDLGenerator gen = this.getDDLGeneratorOrFail();
        DDL ddl = null;
        try {
            ddl = gen.getDeleteDDL(new DDLOptions(false, cascade), schema);
        }
        catch (UnsupportedDDLException uoe) {
            uoe.throwDBException();
        }
        if (ddl == null || ddl.size() == 0) {
            UnsupportedDDLException.deleteNotSupported(schema).throwDBException();
        }
        this.executeDDL(ddl, false);
        this.uncacheObject(schema);
        this.fireSchemaRemoved(schema);
    }

    @Override
    public final void updateSchema(Schema oldSchema, Schema newSchema) throws DBException {
        UnsupportedDDLException.updateNotSupported(oldSchema).throwDBException();
    }

    @Override
    public final void createObjects(SystemObject[] objects, boolean replace) throws DBException {
        Object[] existing = new SystemObject[objects.length];
        DiffEngine de = this.getDiffEngine();
        ResultSet rs = de.diff(existing, objects).getResult();
        for (SchemaObjectExpander soe : this.getSchemaObjectExpanders()) {
            soe.expand(rs);
        }
        objects = (SystemObject[])rs.getUpdatedObject();
        existing = new SystemObject[objects.length];
        DDLGenerator ddlgen = this.getDDLGeneratorOrFail();
        DDL ddl = new DDL();
        NameInUseException dbe = null;
        for (int i = 0; i < objects.length; ++i) {
            DDLOptions options;
            DBException newdbe = null;
            existing[i] = DBUtil.getProviderDefinition(objects[i], (DBObjectProvider)this);
            if (existing[i] == null) {
                options = new DDLOptions(false, false);
                try {
                    ddl.append(ddlgen.getCreateDDL(options, objects[i]));
                }
                catch (UnsupportedDDLException uoe) {
                    newdbe = new DBException((DBObject)objects[i], uoe.getMessage());
                }
            } else if (replace) {
                if (this.canDelete((SystemObject)existing[i], false)) {
                    options = new DDLOptions(true, false);
                    try {
                        ddl.append(ddlgen.getCreateDDL(options, objects[i]));
                    }
                    catch (UnsupportedDDLException uoe) {
                        newdbe = new DBException((DBObject)existing[i], uoe.getMessage());
                    }
                } else {
                    newdbe = new DBException((DBObject)existing[i], DBArb.format(371, objects[i].getType(), objects[i].getName()));
                }
            } else {
                newdbe = new NameInUseException((DBObject)existing[i]);
            }
            if (newdbe == null) continue;
            if (dbe == null) {
                dbe = newdbe;
                continue;
            }
            dbe.setNextException(newdbe);
        }
        if (dbe != null) {
            throw dbe;
        }
        try {
            this.executeDDL(ddl, false);
        }
        catch (DBException dbex) {
            this.processCreateException(dbex, null);
        }
        this.finishCreate(objects, (SystemObject[])existing);
    }

    protected void processCreateException(DBException dbe, SystemObject object) throws DBException {
        if (object == null) {
            for (DBObject dbo = dbe.getObject(); dbo != null; dbo = dbo.getParent()) {
                if (!(dbo instanceof SystemObject)) continue;
                object = (SystemObject)dbo;
                break;
            }
        }
        if (this.isCauseNameInUse(dbe)) {
            throw new NameInUseException(object);
        }
        if (object != null && this.exists(object)) {
            try {
                this.deleteObject(object, true);
            }
            catch (DBException dbe2) {
                DBLog.getLogger().log(Level.FINE, DBArb.getString(372), dbe2);
            }
        }
        throw dbe;
    }

    protected boolean isCauseNameInUse(DBException dbe) {
        return false;
    }

    @Override
    public void deleteObjects(SystemObject[] objects, boolean cascade) throws DBException {
        if ((objects = DBUtil.stripNulls(DBUtil.getProviderDefinitions((SystemObject[])objects, (DBObjectProvider)this))).length > 0) {
            int i;
            ArrayList ddlList = new ArrayList();
            DDLGenerator ddlgen = this.getDDLGeneratorOrFail();
            DDLOptions options = new DDLOptions(false, cascade);
            for (i = 0; i < objects.length; ++i) {
                try {
                    ddlList.add(ddlgen.getDeleteDDL(options, objects[i]));
                    continue;
                }
                catch (UnsupportedDDLException uoe) {
                    uoe.throwDBException();
                }
            }
            if (ddlList.size() == 0) {
                UnsupportedDDLException.deleteNotSupported(objects[0]).throwDBException();
            } else if (ddlList.size() != objects.length) {
                throw new IllegalStateException("Object list and DDL list don't match.");
            }
            for (i = 0; i < objects.length; ++i) {
                DDL dropDDL = (DDL)ddlList.get(i);
                if (dropDDL == null) {
                    DBLog.getLogger().log(Level.WARNING, "Could not drop " + objects[i].getType() + objects[i].getName());
                    continue;
                }
                try {
                    this.executeDDL(dropDDL, false);
                    continue;
                }
                catch (DBException dbe) {
                    this.processDeleteException(dbe, objects[i]);
                }
            }
            this.finishDelete(objects);
        }
    }

    protected void processDeleteException(DBException dbe, SystemObject object) throws DBException {
        throw dbe;
    }

    @Override
    public final void undeleteObject(SchemaObject object) throws DBException {
        this.undeleteObjects(new SchemaObject[]{object});
    }

    @Override
    public final void undeleteObjects(SchemaObject[] objects) throws DBException {
        if ((objects = DBUtil.stripNulls(objects)) != null && objects.length > 0) {
            DDL ddl = null;
            DDLGenerator ddlgen = this.getDDLGeneratorOrFail();
            DDLOptions options = new DDLOptions(false, false);
            try {
                ddl = ddlgen.getUndeleteDDL(options, objects);
            }
            catch (UnsupportedDDLException uoe) {
                uoe.throwDBException();
            }
            if (ddl == null) {
                UnsupportedDDLException.undeleteNotSupported(objects[0]).throwDBException();
            }
            if (this.executeDDL(ddl, false)) {
                this.finishDelete(objects);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void updateObjects(Difference rs, boolean replace, boolean cascade) throws DBException {
        void newObjects22;
        SystemObject[] newObjects;
        SystemObject[] oldObjects;
        for (SchemaObjectExpander soe : this.getSchemaObjectExpanders()) {
            soe.expand(rs);
        }
        if (rs.isSame()) {
            return;
        }
        DDLOptions options = new DDLOptions(replace, cascade);
        boolean plsql = false;
        DDL ddl = null;
        if (rs.isList()) {
            Collection<? extends Difference> l = rs.getChildren();
            oldObjects = new SystemObject[l.size()];
            newObjects = new SystemObject[l.size()];
            int i = 0;
            for (Difference difference : l) {
                oldObjects[i] = (SystemObject)difference.getOriginalObject();
                newObjects[i] = (SystemObject)difference.getUpdatedObject();
                if (newObjects[i] instanceof PlSql) {
                    plsql = true;
                }
                ddl = this.appendUpdateDDL(oldObjects[i], newObjects[i], difference, options, ddl);
                ++i;
            }
        } else if (rs.isMap() && rs.getOriginalObject() instanceof SystemObject) {
            oldObjects = new SystemObject[]{(SystemObject)rs.getOriginalObject()};
            newObjects = new SystemObject[]{(SystemObject)rs.getUpdatedObject()};
            if (newObjects[0] instanceof PlSql) {
                plsql = true;
            }
            ddl = this.appendUpdateDDL(oldObjects[0], newObjects[0], rs, options, ddl);
        } else {
            oldObjects = null;
            Object newObjects22 = null;
            throw new IllegalStateException("updateObjects must be called with a LIST Difference.");
        }
        if (plsql) {
            this.setCompilerOptions();
        }
        if (ddl == null || ddl.size() == 0) {
            UnsupportedDDLException.updateNotSupported((DBObject)newObjects22[0]).throwDBException();
        }
        if (!replace) {
            for (int i = 0; i < oldObjects.length; ++i) {
                if (oldObjects[i] != null || newObjects22[i] == null || !this.exists((SystemObject)newObjects22[i])) continue;
                new NameInUseException((DBObject)newObjects22[i]);
            }
        }
        if (this.executeDDL(ddl, false)) {
            this.finishCreate((SystemObject[])newObjects22, oldObjects);
        }
    }

    @Override
    protected void registerExpanders() {
        this.registerSchemaObjectExpander(new TemplateExpander(this));
    }

    @Override
    public final Schema[] listSchemas() throws DBException {
        return super.listSchemas();
    }

    private DDL appendUpdateDDL(SystemObject original, SystemObject updated, Difference d, DDLOptions options, DDL appendTo) throws DBException {
        SystemObject existing = DBUtil.getProviderDefinition(original == null ? updated : original, (DBObjectProvider)this);
        try {
            DDL ddl;
            DDLGenerator gen = this.getDDLGeneratorOrFail();
            if (options.isReplace() && existing == null) {
                DDLOptions noReplaceOptions = (DDLOptions)((Object)options.copyTo(null));
                noReplaceOptions.setReplace(false);
                ddl = gen.getCreateDDL(options, updated);
            } else {
                ddl = gen.getUpdateDDL(options, d);
            }
            if (appendTo == null) {
                appendTo = ddl;
            } else {
                appendTo.append(ddl);
            }
        }
        catch (UnsupportedDDLException ude) {
            ude.throwDBException();
        }
        return appendTo;
    }

    public void setCompilerOptions() {
    }
}

