/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.datatypes.UserDataType;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSearchException;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.plsql.PlSqlTokenizer;
import oracle.javatools.util.ModelUtil;

public class DataTypeHelper {
    public static DataType getDataType(DataTypeUsage usage) throws DBException {
        if (usage != null) {
            BaseObjectID id;
            DBObjectID dataTypeID = usage.getDataTypeID();
            if (dataTypeID == null) {
                throw new DBException((DBObject)usage, "Column's DataTypeUsage has no DataTypeID to resolve.");
            }
            DataType dt = (DataType)dataTypeID.resolveID();
            if (dt == null && usage.getDataTypeID() instanceof BaseObjectID && "TYPE".equals((id = (BaseObjectID)usage.getDataTypeID()).getType()) && id.getSchemaName() != null && id.getName() != null) {
                Schema schema;
                try {
                    schema = id.getProvider() != null ? id.getProvider().getSchema(id.getSchemaName()) : null;
                }
                catch (DBException e) {
                    schema = null;
                }
                if (schema == null) {
                    schema = new Schema(id.getSchemaName());
                }
                dt = new ComplexType(id.getName(), schema);
            }
            return dt;
        }
        return null;
    }

    public static Long getLongAttributeValue(DataTypeUsage usage, String name) {
        return DataTypeHelper.toLong(usage.getAttributeValue(name));
    }

    public static String getStringAttributeValue(DataTypeUsage usage, String name) {
        return DataTypeHelper.toString(usage.getAttributeValue(name));
    }

    public static String getStringAttributeDefaultValue(DataTypeUsage usage, String attributeName) {
        String result = null;
        try {
            Object defaultValue;
            DataType dataType = DataTypeHelper.getDataType(usage);
            DataTypeAttribute attribute = dataType.getDataTypeAttribute(attributeName);
            if (attribute != null && null != (defaultValue = attribute.getDefaultValue())) {
                result = defaultValue.toString();
            }
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return result;
    }

    public static Long toLong(Object usageValue) {
        try {
            String convert = usageValue == null ? null : ModelUtil.nullifyIfEmpty((String)usageValue.toString());
            return convert == null ? null : Long.valueOf(convert);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public static Long toLongOrError(Object usageValue) throws NumberFormatException {
        String convert = usageValue == null ? null : ModelUtil.nullifyIfEmpty((String)usageValue.toString());
        return convert == null ? null : Long.valueOf(convert);
    }

    public static String toString(Object usageValue) {
        return usageValue == null ? null : usageValue.toString();
    }

    public static String getNameFromLabel(int resourceLabelID) {
        return DBArb.getString(resourceLabelID).replaceAll("&", "");
    }

    public static String getNameFromLabel(String resourceLabel) {
        return resourceLabel.replaceAll("&", "");
    }

    public static Object getAttributeValue(Object value, DataType dataType, String attributeName) {
        DataTypeAttribute attribute;
        if (value instanceof String && !ModelUtil.hasLength((String)((String)value))) {
            value = null;
        }
        if (value != null && (attribute = dataType.getDataTypeAttribute(attributeName)) != null) {
            if (attribute.getValueType() == 0) {
                return DataTypeHelper.toString(value);
            }
            return DataTypeHelper.toLong(value);
        }
        return value;
    }

    public static String getDDL(DataTypeUsage dtu) {
        String retval = null;
        if (dtu != null) {
            try {
                DataType dt = DataTypeHelper.getDataType(dtu);
                retval = dt != null ? dt.getDDL(dtu) : DataTypeHelper.getTypeStringFromID(dtu.getDataTypeID(), null);
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(Level.WARNING, "Couldn't resolve datatype ID for DDL: " + dbe.getMessage());
            }
        }
        return retval;
    }

    public static boolean canGetTypeStringFromID(DBObjectID id) {
        String idType;
        DBObject type = null;
        try {
            type = id.resolveID();
        }
        catch (DBException e) {
            type = null;
        }
        if (type instanceof DataType) {
            return true;
        }
        return id instanceof ReferenceID && ("DATATYPE".equals(idType = ((ReferenceID)id).getType()) || "REF".equals(idType) || "%TYPE".equals(idType) || "%ROWTYPE".equals(idType));
    }

    public static String getTypeStringFromID(DBObjectID typeID, Schema defaultSchema) {
        StringBuffer retval = new StringBuffer();
        DBObject type = null;
        try {
            type = typeID.resolveID();
        }
        catch (DBException e) {
            type = null;
        }
        if (type != null) {
            retval.append(type.getName());
            DBObject parent = type;
            while (parent.getParent() != null) {
                parent = parent.getParent();
                retval.insert(0, ".");
                retval.insert(0, parent.getName());
            }
            if (parent instanceof SchemaObject && (defaultSchema == null || !defaultSchema.equals(((SchemaObject)parent).getSchema()))) {
                retval.insert(0, ".");
                retval.insert(0, ((SchemaObject)parent).getSchema().getName());
            }
        } else if (typeID instanceof BaseObjectID) {
            DBObjectID nextID = typeID;
            boolean refDataType = false;
            if (typeID instanceof ReferenceID) {
                ReferenceID refID = (ReferenceID)typeID;
                if ("REF".equals(refID.getType())) {
                    refDataType = true;
                    nextID = nextID.getParent();
                } else if ("%TYPE".equals(refID.getType())) {
                    retval.append("%TYPE");
                    nextID = nextID.getParent();
                } else if ("%ROWTYPE".equals(refID.getType())) {
                    retval.append("%ROWTYPE");
                    nextID = nextID.getParent();
                }
            }
            boolean addDot = false;
            while (nextID instanceof BaseObjectID) {
                if (addDot) {
                    retval.insert(0, ".");
                }
                retval.insert(0, ((BaseObjectID)nextID).getName());
                addDot = true;
                if (nextID.getParent() == null) break;
                nextID = nextID.getParent();
            }
            if (nextID instanceof BaseObjectID && (defaultSchema == null || !defaultSchema.getName().equals(((BaseObjectID)nextID).getSchemaName()))) {
                retval.insert(0, ".");
                retval.insert(0, ((BaseObjectID)nextID).getSchemaName());
            }
            if (refDataType) {
                retval.insert(0, " ");
                retval.insert(0, "REF");
            }
        }
        return retval.toString();
    }

    public static DBObjectID findOrCreateIDForTypeString(DBObjectProvider provider, Schema defaultSchema, String typeString) {
        if (!ModelUtil.hasLength((String)typeString)) {
            return null;
        }
        DBObjectID retval = DataTypeHelper.findIDForTypeString(provider, defaultSchema, typeString);
        if (retval == null) {
            PlSqlToken startTk;
            PlSqlToken tk = startTk = PlSqlTokenizer.tokenize((String)typeString, (String[])new String[0]);
            PlSqlToken endTk = null;
            while (tk.getType() != PlSqlToken.Type.END_MARKER) {
                tk = tk.getNextToken();
            }
            endTk = tk.getPrevCodeToken();
            try {
                String tokenStr = provider.getInternalName(startTk.getSource(true));
                Schema schema = provider.getSchema(tokenStr);
                if (schema != null && startTk.getNextCodeToken().matches(".")) {
                    startTk = startTk.getNextCodeToken(2);
                } else {
                    if (schema == null) {
                        schema = defaultSchema;
                    }
                    if (schema == null) {
                        schema = provider.getDefaultSchema();
                    }
                }
                if (startTk.getNextCodeToken().getType() == PlSqlToken.Type.END_MARKER) {
                    tokenStr = provider.getInternalName(startTk.getSource(true));
                    SchemaObject obj = provider.getObject("TYPE", schema, tokenStr);
                    if (obj != null) {
                        return obj.getID();
                    }
                    retval = new ReferenceID("DATATYPE", schema.getName(), tokenStr);
                } else {
                    retval = new ReferenceID("DATATYPE", schema.getName(), startTk.getSource(true, endTk));
                }
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        return retval;
    }

    public static DBObjectID findIDForTypeString(DBObjectProvider provider, Schema defaultSchema, String typeString) {
        PlSqlToken startTk;
        UserDataType userDataType = null;
        if (!ModelUtil.hasLength((String)typeString)) {
            return null;
        }
        DBObjectID retval = null;
        PlSqlToken tk = startTk = PlSqlTokenizer.tokenize((String)typeString, (String[])new String[0]);
        PlSqlToken endTk = null;
        while (tk.getType() != PlSqlToken.Type.END_MARKER) {
            tk = tk.getNextToken();
        }
        endTk = tk.getPrevCodeToken();
        DataType dt = provider.getDataType(startTk.getSource(true, endTk));
        if (dt != null) {
            if (dt instanceof UserDataType) {
                userDataType = (UserDataType)dt;
            } else {
                return dt.getID();
            }
        }
        if (startTk.matches("REF")) {
            tk = startTk.getNextCodeToken();
            retval = DataTypeHelper.findOrCreateIDForTypeString(provider, defaultSchema, tk.getSource(true, endTk));
            retval = new ReferenceID("REF", retval, null, null, null);
            return retval;
        }
        tk = endTk.getPrevToken();
        if (tk.matches("%") && endTk.matches("TYPE")) {
            retval = DataTypeHelper.findIDForTypeString(provider, defaultSchema, startTk.getSource(true, tk = tk.getPrevToken()));
            if (retval != null) {
                retval = new ReferenceID("%TYPE", retval, null, null, null);
            }
            return retval;
        }
        if (tk.matches("%") && endTk.matches("ROWTYPE")) {
            retval = DataTypeHelper.findIDForTypeString(provider, defaultSchema, startTk.getSource(true, tk = tk.getPrevToken()));
            if (retval != null) {
                retval = new ReferenceID("%ROWTYPE", retval, null, null, null);
            }
            return retval;
        }
        if (userDataType != null) {
            return userDataType.getID();
        }
        Schema schema = defaultSchema;
        try {
            if (schema == null) {
                schema = provider.getDefaultSchema();
            }
            retval = DataTypeHelper.findObjectID(provider, schema, startTk);
        }
        catch (DBException e) {
            // empty catch block
        }
        if (retval == null) {
            try {
                schema = provider.getSchema(provider.getInternalName(startTk.getSource(true)));
                if (schema != null && startTk.getNextCodeToken().matches(".")) {
                    retval = DataTypeHelper.findObjectID(provider, schema, startTk.getNextCodeToken(2));
                }
            }
            catch (DBException e) {
                // empty catch block
            }
        }
        return retval;
    }

    public static DataTypeUsage getDataTypeUsageForString(DBObjectProvider provider, Schema defaultSchema, String usageString) {
        return DataTypeHelper.getDataTypeUsageForString(provider, defaultSchema, usageString, false);
    }

    public static DataTypeUsage getDataTypeUsageForString(DBObjectProvider provider, Schema defaultSchema, String usageString, boolean strict) {
        DBObjectID id;
        DataTypeUsage dtu = null;
        for (DataType dt : provider.listSupportedDataTypes()) {
            if (!ModelUtil.hasLength((String)usageString) || !dt.matches(usageString)) continue;
            dtu = dt.createUsage(usageString);
            break;
        }
        if (!(dtu != null || (id = strict ? DataTypeHelper.findIDForTypeString(provider, defaultSchema, usageString) : DataTypeHelper.findOrCreateIDForTypeString(provider, defaultSchema, usageString)) == null || id instanceof DataTypeID && !ModelUtil.hasLength((String)((DataTypeID)id).getSchemaName()) && strict)) {
            dtu = new ObjectTypeUsage();
            dtu.setDataTypeID(id);
        }
        return dtu;
    }

    private static DBObjectID findObjectID(DBObjectProvider provider, DBObject parent, PlSqlToken tk) {
        String tokVal = provider.getInternalName(tk.getSource(true));
        if (parent instanceof Schema) {
            for (String objType : DataTypeHelper.getOrderedTypes(provider, "TYPE", "TABLE")) {
                SchemaObject so = null;
                try {
                    so = provider.getObject(objType, (Schema)parent, tokVal);
                }
                catch (DBException e) {
                    so = null;
                }
                if (so == null) continue;
                if (tk.getNextCodeToken().getType() == PlSqlToken.Type.END_MARKER) {
                    return so.getID();
                }
                if (tk.getNextCodeToken().matches(".")) {
                    return DataTypeHelper.findObjectID(provider, so, tk.getNextCodeToken(2));
                }
                return null;
            }
        } else {
            for (DBObject kid : parent.getOwnedObjects()) {
                if (kid.getName() == null || !kid.getName().equals(tokVal)) continue;
                if (tk.getNextCodeToken().getType() == PlSqlToken.Type.END_MARKER) {
                    return kid.getID();
                }
                if (tk.getNextCodeToken().matches(".")) {
                    return DataTypeHelper.findObjectID(provider, kid, tk.getNextCodeToken(2));
                }
                return null;
            }
        }
        return null;
    }

    private static String[] getOrderedTypes(DBObjectProvider provider, String ... topTypes) {
        ArrayList<String> types = new ArrayList<String>();
        for (String type : provider.listObjectTypes()) {
            types.add(type);
        }
        for (int i = topTypes.length - 1; i >= 0; --i) {
            if (!types.contains(topTypes[i])) continue;
            types.remove(topTypes[i]);
            types.add(0, topTypes[i]);
        }
        return types.toArray(new String[types.size()]);
    }

    static PlSqlSearch buildSearch(String definition, DataTypeAttribute[] attributes) {
        PlSqlSearch retval = null;
        HashMap<String, DataTypeAttribute> attrMap = new HashMap<String, DataTypeAttribute>();
        for (DataTypeAttribute dta : attributes) {
            attrMap.put(dta.getName(), dta);
        }
        try {
            String pass1 = definition.replaceAll("\\>", " ?>");
            String pass2 = definition;
            PlSqlSearch s = new PlSqlSearch(pass1);
            for (String name : s.getNames()) {
                StringBuffer sb1 = new StringBuffer();
                sb1.append("<").append(name).append(">");
                StringBuffer sb2 = new StringBuffer();
                DataTypeAttribute dta = (DataTypeAttribute)attrMap.get(name);
                if (dta != null && dta.getValues() != null && dta.getValues().length > 0) {
                    sb2.append("<").append(name).append(" {");
                    for (int i = 0; i < dta.getValues().length; ++i) {
                        sb2.append(dta.getValues()[i]);
                        if (i >= dta.getValues().length - 1) continue;
                        sb2.append("|");
                    }
                    sb2.append("}>");
                } else {
                    sb2.append("<").append(name).append(" ?>");
                }
                pass2 = pass2.replace(sb1.toString(), sb2.toString());
            }
            retval = new PlSqlSearch(DataTypeHelper.addTail(pass2));
        }
        catch (PlSqlSearchException e) {
            DBLog.getLogger().log(Level.SEVERE, "Cannot create PlSqlSearch based on PredefinedDataType definition " + definition + " - " + e.getMessage());
        }
        return retval;
    }

    static DataTypeUsage getUsageFromString(DataType dt, PlSqlSearch search, String usageString) {
        DataTypeUsage retval = null;
        HashMap<String, Object> attributeValues = new HashMap<String, Object>();
        if (DataTypeHelper.matches(search, usageString)) {
            for (String name : search.getNames()) {
                DataTypeAttribute dta = dt.getDataTypeAttribute(name);
                if (dta == null) continue;
                try {
                    String valueStr = search.getNamedMatch(name);
                    Object value = valueStr;
                    if (valueStr == null) continue;
                    if (dta.getValueType() == 1) {
                        value = Long.valueOf(valueStr);
                    }
                    attributeValues.put(name, value);
                }
                catch (NumberFormatException nfe) {
                    // empty catch block
                }
            }
            retval = dt.createUsage(attributeValues);
        }
        return retval;
    }

    static boolean matches(PlSqlSearch search, String usageString) {
        return search != null && search.matches(DataTypeHelper.addTail(usageString));
    }

    private static String addTail(String str) {
        return new StringBuffer(str).append(" \\").toString();
    }

    public static boolean isXMLType(DataType type) {
        ComplexType ct;
        return type instanceof ComplexType && (ct = (ComplexType)type).getSchema() != null && "SYS".equals(ct.getSchema().getName()) && "XMLTYPE".equals(ct.getName().toUpperCase());
    }
}

