/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.GlobalSettings;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

public class BaseDateTimeDataType
extends PredefinedDataType {
    private static final int ORACLE_FIRST_YEAR = -4712;
    private static final int ORACLE_LAST_YEAR = 9999;
    private static final List validStringTypes = new ArrayList<Integer>(Arrays.asList(new Integer(5), new Integer(17), new Integer(23)));
    private static final List validDateTimeFunctions = new ArrayList<Integer>(Arrays.asList(new Integer(37), new Integer(38), new Integer(45), new Integer(46), new Integer(47), new Integer(48), new Integer(49), new Integer(50), new Integer(51), new Integer(52), new Integer(53), new Integer(54), new Integer(55), new Integer(56), new Integer(57), new Integer(58), new Integer(59), new Integer(60), new Integer(61), new Integer(62), new Integer(63), new Integer(64), new Integer(65), new Integer(66), new Integer(67), new Integer(68), new Integer(69), new Integer(70), new Integer(71), new Integer(72), new Integer(75), new Integer(76), new Integer(94), new Integer(95), new Integer(277), new Integer(278), new Integer(290), new Integer(374), new Integer(298), new Integer(169)));

    public BaseDateTimeDataType() {
    }

    public BaseDateTimeDataType(int domain, String name) {
        super(domain, name);
    }

    public BaseDateTimeDataType(int domain, String name, String definition, DataTypeAttribute[] attributes) {
        super(domain, name, definition, attributes);
    }

    @Deprecated
    public String validateDateTime(Column column, SimpleDateFormat format, String equivalentOracleFormat) {
        if (column != null) {
            return this.validateDateTime((String)column.getDefault(), format, equivalentOracleFormat, column);
        }
        return null;
    }

    public String validateDateTime(Object defaultValue, SimpleDateFormat format, String equivalentOracleFormat, DBObject context) {
        String strDefaultValue;
        GlobalSettings settings;
        String errorMessage = null;
        if (defaultValue instanceof String && (settings = GlobalSettings.getInstance()) != null && settings.isValidateDateTime() && ModelUtil.hasLength((String)(strDefaultValue = defaultValue.toString().trim())) && !strDefaultValue.equalsIgnoreCase("null")) {
            errorMessage = this.isQuoted(strDefaultValue) ? this.validateUsingFormat(strDefaultValue, format, equivalentOracleFormat, context) : this.validateDateExpr(strDefaultValue, context);
        }
        return errorMessage;
    }

    private String validateDateExpr(String defaultValue, DBObject context) {
        String error = null;
        String errorMessage = null;
        PlsqlNode node = null;
        try {
            PlsqlRoot parseTree = ParserUtils.parseQueryString(defaultValue, 2);
            if (parseTree.getUnits().length != 1) {
                throw new SQLQueryException(defaultValue);
            }
            node = parseTree.getUnits()[0];
            ParserUtils.checkErrors(parseTree, defaultValue);
        }
        catch (SQLQueryException x) {
            error = DBArb.format(212, x.getMessage());
        }
        if (!ParserUtils.isAllowedStringType(node, validStringTypes) && !ParserUtils.isAllowedExpression(node, validDateTimeFunctions)) {
            error = DBArb.format(212, defaultValue);
        }
        if (null != error) {
            errorMessage = DBArb.format(216, this.getErrorMessageContext(defaultValue, context), error);
        }
        return errorMessage;
    }

    private String validateUsingFormat(String defaultValue, SimpleDateFormat format, String equivalentOracleFormat, DBObject context) {
        String errorMessage = null;
        HashMap pos = new HashMap();
        String strippedDef = this.stripSpacesAndSeperators(defaultValue, pos);
        boolean ok = true;
        int offset = 0;
        String error = "";
        ParsePosition parsePosn = new ParsePosition(0);
        Date date = format.parse(strippedDef, parsePosn);
        if (null == date || parsePosn.getIndex() != strippedDef.length()) {
            ok = false;
            offset = parsePosn.getErrorIndex();
            if (-1 == offset) {
                offset = parsePosn.getIndex();
            }
        } else {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(date);
            int year = calendar.get(1);
            if (year < -4712 || year > 9999) {
                ok = false;
                error = DBArb.format(217, Integer.toString(year));
            }
        }
        if (!ok) {
            String errLocation = "";
            if (pos.containsKey(new Integer(offset))) {
                int oldOffset = (Integer)pos.get(new Integer(offset));
                errLocation = DBArb.format(218, defaultValue.substring(oldOffset));
            } else {
                errLocation = "ran out of input characters";
            }
            errorMessage = DBArb.format(215, new Object[]{this.getErrorMessageContext(defaultValue, context), errLocation, error, equivalentOracleFormat});
        }
        return errorMessage;
    }

    private String getErrorMessageContext(String defaultValue, DBObject context) {
        String dataTypeName;
        String dbObjectName = context != null ? context.getName() : "";
        String dbObjectType = context != null ? context.getType() : "";
        String string = dataTypeName = context instanceof DataType ? context.getName() : "";
        if (context instanceof Column) {
            try {
                dataTypeName = DataTypeHelper.getDataType(((Column)context).getDataTypeUsage()).getName();
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        String errorMessageContext = DBArb.format(214, new Object[]{dbObjectType, dbObjectName, dataTypeName, defaultValue});
        return errorMessageContext;
    }

    private boolean isQuoted(String defaultValue) {
        String trimmed = defaultValue.trim();
        return trimmed.length() > 1 && trimmed.startsWith("'") && trimmed.endsWith("'");
    }

    private String stripSpacesAndSeperators(String defaultValue, HashMap pos) {
        StringBuffer def = new StringBuffer();
        char[] chars = defaultValue.toCharArray();
        int i = 0;
        int j = 0;
        while (i < chars.length) {
            while (i < chars.length && Character.isWhitespace(chars[i])) {
                ++i;
            }
            if (chars.length == i) break;
            if (!Character.isLetterOrDigit(chars[i])) {
                ++i;
            }
            while (i < chars.length && Character.isWhitespace(chars[i])) {
                ++i;
            }
            if (chars.length == i) break;
            def.append(chars[i]);
            pos.put(new Integer(j++), new Integer(i++));
        }
        String strippedDef = def.toString();
        return strippedDef;
    }
}

