/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.Function;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.Procedure;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectExpander;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.Table;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.ora.MaterializedViewLog;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.db.property.PropertyHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateExpander
implements SchemaObjectExpander {
    private static final String TEMPLATE_OBJECTID = "TemplateObject";
    private static HashMap<Class, ArrayList<String>> m_propsToClear;
    private static Collection<Initialiser> m_initialisers;
    private DBObjectProvider m_pro;
    private DatabaseDescriptor m_descriptor;

    public TemplateExpander(DBObjectProvider pro) {
        this.m_pro = pro;
        this.m_descriptor = pro.getDescriptor();
    }

    @Override
    public void expand(Difference rs) {
        for (Difference difference : rs.getChildren()) {
            Object obj;
            if (difference.getUpdatedObject() == null || difference.getOriginalObject() != null || !((obj = difference.getUpdatedObject()) instanceof DBObject)) continue;
            this.checkAndRecurse((DBObject)obj);
        }
    }

    private void checkAndRecurse(DBObject object) {
        for (DBObject kid : object.getOwnedObjects()) {
            this.checkAndRecurse(kid);
        }
        if (TemplateExpander.isPendingObject(object)) {
            this.completePendingObject(object);
        }
    }

    private void completePendingObject(DBObject object) {
        DBObject template = TemplateExpander.getTemplate(object);
        object.getProperties().remove(TEMPLATE_OBJECTID);
        if (object instanceof Table) {
            Table tab = (Table)object;
            for (Column column : tab.getColumns()) {
                column.setName(TemplateExpander.replaceNameFragment(column.getName(), template.getName(), tab.getName()));
                try {
                    this.m_descriptor.makeNameValidAndUnique(column, this.m_pro);
                }
                catch (InvalidNameException e) {
                    // empty catch block
                }
            }
            for (AbstractDBObject abstractDBObject : tab.getIndexes()) {
                abstractDBObject.setName(TemplateExpander.replaceNameFragment(abstractDBObject.getName(), template.getName(), tab.getName()));
                try {
                    this.m_descriptor.makeNameValidAndUnique(abstractDBObject, this.m_pro);
                }
                catch (InvalidNameException e) {
                    // empty catch block
                }
            }
            for (AbstractDBObject abstractDBObject : tab.getConstraints()) {
                abstractDBObject.setName(TemplateExpander.replaceNameFragment(abstractDBObject.getName(), template.getName(), tab.getName()));
                try {
                    this.m_descriptor.makeNameValidAndUnique(abstractDBObject, this.m_pro);
                }
                catch (InvalidNameException e) {
                    // empty catch block
                }
            }
        } else if (object instanceof PlSql) {
            TemplateExpander.applySourceFromTemplate((PlSql)template, (PlSql)object);
        }
    }

    public static final <T extends DBObject> T initialiseObject(T template) {
        PropertyHelper propHelp = new PropertyHelper();
        DBObject object = (DBObject)template.copyTo(null);
        object.setName(null);
        object.setProperty(TEMPLATE_OBJECTID, template.getID());
        for (Class clearClass : m_propsToClear.keySet()) {
            if (!clearClass.isAssignableFrom(object.getClass())) continue;
            boolean recurse = clearClass == DBObject.class;
            ArrayList<String> propsToClear = m_propsToClear.get(clearClass);
            Iterator<String> propsIter = propsToClear.iterator();
            while (propsIter.hasNext()) {
                TemplateExpander.clearProp(propHelp, object, propsIter.next(), recurse);
            }
        }
        for (Initialiser ini : m_initialisers) {
            ini.initialiseObject(template, object);
        }
        return (T)object;
    }

    private static void clearProp(PropertyHelper propHelp, DBObject object, String propPath, boolean recurse) {
        propHelp.setPropertyValue(object, propPath, null);
        if (recurse) {
            for (DBObject kid : object.getOwnedObjects()) {
                TemplateExpander.clearProp(propHelp, kid, propPath, true);
            }
        }
    }

    public static final boolean isPendingObject(DBObject object) {
        DBObject template = TemplateExpander.getTemplate(object);
        if (template != null && template.getID() == null && template.getName() == null) {
            template = null;
        }
        return template != null;
    }

    public static void registerInitialiser(Initialiser ini) {
        m_initialisers.add(ini);
    }

    public static void registerPropertyToClear(Class clearFromClass, String clearProperty, boolean append) {
        ArrayList<String> propsToClear = new ArrayList<String>();
        propsToClear.add(clearProperty);
        TemplateExpander.registerPropertiesToClear(clearFromClass, propsToClear, append);
    }

    public static void registerPropertiesToClear(Class clearFromClass, ArrayList<String> clearPropsList, boolean append) {
        if (append && m_propsToClear.containsKey(clearFromClass)) {
            ArrayList<String> clearProps = m_propsToClear.get(clearFromClass);
            clearProps.addAll(clearPropsList);
            m_propsToClear.put(clearFromClass, clearProps);
        } else {
            m_propsToClear.put(clearFromClass, clearPropsList);
        }
    }

    public static String getTemplateObjectName(DBObject object) {
        DBObject template = TemplateExpander.getTemplate(object);
        if (template != null && template.getName() != null) {
            Schema s;
            StringBuffer name = new StringBuffer();
            if (template instanceof SchemaObject && (s = ((SchemaObject)template).getSchema()) != null) {
                name.append(s.getName()).append(".");
            }
            name.append(template.getName());
            return name.toString();
        }
        return null;
    }

    private static String replaceNameFragment(String fullname, String origFrag, String newFrag) {
        String retval = "_" + fullname + "_";
        String _s1_ = "_" + origFrag + "_";
        String _s2_ = "_" + newFrag + "_";
        int i = 0;
        String tempFrag = "_" + i + "_";
        String s = _s1_ + _s2_;
        while (s.contains(tempFrag)) {
            tempFrag = "_" + ++i + "_";
        }
        while (retval.indexOf(_s1_) >= 0) {
            retval = retval.replace(_s1_, tempFrag);
        }
        while (retval.indexOf(tempFrag) >= 0) {
            retval = retval.replace(tempFrag, _s2_);
        }
        return retval.substring(1, retval.length() - 1);
    }

    private static PlSqlFragment findFragment(PlSqlFragment root, PlSqlFragment.Type type, boolean deep) {
        if (root != null) {
            return root.findChild(type, deep);
        }
        return null;
    }

    public static void applySourceFromTemplate(PlSql object) {
        if (TemplateExpander.isPendingObject(object)) {
            PlSql template = (PlSql)TemplateExpander.getTemplate(object);
            TemplateExpander.applySourceFromTemplate(template, object);
        }
    }

    public static void applySourceFromTemplate(PlSql template, PlSql object) {
        if (template.getSourceInterrogator().getRoot() != null) {
            if (object instanceof SpecPlSql) {
                PlSqlInterrogator piTemplate = template.getSourceInterrogator();
                object.setSource(piTemplate.getRenamedSource(object.getName()));
                PlSqlInterrogator piTemplateBody = ((SpecPlSql)template).getBodySourceInterrogator();
                if (piTemplateBody != null) {
                    ((SpecPlSql)object).setBodySource(piTemplateBody.getRenamedSource(object.getName()));
                }
            } else if (object instanceof Trigger) {
                PlSqlInterrogator piObject = object.getSourceInterrogator();
                PlSqlFragment objectTriggerFrag = TemplateExpander.findFragment(piObject.getRoot(), PlSqlFragment.Type.TRIGGER, true);
                PlSqlFragment objectPLSQLFrag = TemplateExpander.findFragment(objectTriggerFrag, PlSqlFragment.Type.PLSQL_BLOCK, false);
                PlSqlInterrogator piTemplate = template.getSourceInterrogator();
                PlSqlFragment templateTriggerFrag = TemplateExpander.findFragment(piTemplate.getRoot(), PlSqlFragment.Type.TRIGGER, true);
                PlSqlFragment templatePLSQLFrag = TemplateExpander.findFragment(templateTriggerFrag, PlSqlFragment.Type.PLSQL_BLOCK, false);
                int objectTriggerStart = objectTriggerFrag.getFirstToken().getNextCodeToken().getStart();
                int objectPlSqlStart = objectPLSQLFrag.getFirstToken().getStart();
                int templateTriggerStart = templateTriggerFrag.getFirstToken().getNextCodeToken().getStart();
                int templatePlSqlStart = templatePLSQLFrag.getFirstToken().getStart();
                StringBuilder sb = new StringBuilder();
                String objectSource = object.getSource();
                String templateSource = template.getSource();
                sb.append(templateSource.substring(0, templateTriggerStart));
                sb.append(objectSource.substring(objectTriggerStart, objectPlSqlStart));
                sb.append(templateSource.substring(templatePlSqlStart));
                object.setSource(sb.toString());
            } else if (object instanceof Procedure || object instanceof Function) {
                PlSqlFragment.Type type = PlSqlFragment.Type.PROCEDURE;
                if (object instanceof Function) {
                    type = PlSqlFragment.Type.FUNCTION;
                }
                PlSqlInterrogator piObject = object.getSourceInterrogator();
                PlSqlFragment objectProcFrag = TemplateExpander.findFragment(piObject.getRoot(), type, true);
                PlSqlFragment objectParamsFrag = TemplateExpander.findFragment(objectProcFrag, PlSqlFragment.Type.PARAMETER_LIST, false);
                PlSqlInterrogator piTemplate = template.getSourceInterrogator();
                PlSqlFragment templateProcFrag = TemplateExpander.findFragment(piTemplate.getRoot(), type, true);
                PlSqlFragment templateParamsFrag = TemplateExpander.findFragment(templateProcFrag, PlSqlFragment.Type.PARAMETER_LIST, false);
                int templateParamsStart = -1;
                int templateParamsEnd = -1;
                if (templateParamsFrag == null) {
                    PlSqlToken name = templateProcFrag.getFirstToken().getNextCodeToken();
                    templateParamsStart = name.getNextCodeToken().getStart();
                    templateParamsEnd = name.getNextToken().getStart();
                } else {
                    templateParamsStart = templateParamsFrag.getFirstToken().getStart();
                    templateParamsEnd = templateParamsFrag.getLastToken().getEnd() + 1;
                }
                StringBuilder sb = new StringBuilder();
                String templateSource = template.getSource();
                sb.append(templateSource.substring(0, templateParamsStart));
                if (objectParamsFrag != null) {
                    sb.append(objectParamsFrag.getSource());
                }
                boolean done = false;
                if (object instanceof Function) {
                    PlSqlToken tok = templateProcFrag.getFirstToken();
                    int startOfReturnType = -1;
                    int endOfReturnType = -1;
                    while (!tok.matches("return") && tok.getType() != PlSqlToken.Type.END_MARKER) {
                        tok = tok.getNextToken();
                    }
                    if (tok.matches("return")) {
                        tok = tok.getNextCodeToken();
                        startOfReturnType = tok.getStart();
                        while (tok.isCode()) {
                            tok = tok.getNextToken();
                        }
                        endOfReturnType = tok.getStart();
                        sb.append(templateSource.substring(templateParamsEnd, startOfReturnType));
                        sb.append(DataTypeHelper.getTypeStringFromID(((Function)object).getReturnTypeID(), object.getSchema()));
                        sb.append(templateSource.substring(endOfReturnType));
                        done = true;
                    }
                }
                if (!done) {
                    sb.append(templateSource.substring(templateParamsEnd));
                }
                object.setSource(sb.toString());
                piObject = object.getSourceInterrogator();
                object.setSource(piObject.getRenamedSource(object.getName()));
            }
        }
    }

    private static DBObject getTemplate(DBObject object) {
        DBObjectID templateID = (DBObjectID)object.getProperty(TEMPLATE_OBJECTID);
        DBObject template = null;
        if (templateID != null) {
            try {
                template = templateID.resolveID();
            }
            catch (DBException dBException) {
                // empty catch block
            }
        }
        return template;
    }

    static {
        m_initialisers = new ArrayList<Initialiser>();
        m_propsToClear = new HashMap();
        ArrayList<String> mvlClearProps = new ArrayList<String>();
        mvlClearProps.add("masterTableID");
        mvlClearProps.add("logTable");
        mvlClearProps.add("columnIDs");
        m_propsToClear.put(MaterializedViewLog.class, mvlClearProps);
        ArrayList<String> plsClearProps = new ArrayList<String>();
        plsClearProps.add("source");
        m_propsToClear.put(PlSql.class, plsClearProps);
        ArrayList<String> specClearProps = new ArrayList<String>();
        specClearProps.add("bodySource");
        m_propsToClear.put(SpecPlSql.class, specClearProps);
        ArrayList<String> trigClearProps = new ArrayList<String>();
        trigClearProps.add("code");
        trigClearProps.add("tableOwner");
        trigClearProps.add("tableID");
        trigClearProps.add("columnIDs");
        m_propsToClear.put(Trigger.class, trigClearProps);
        ArrayList<String> schemaObjClearProps = new ArrayList<String>();
        schemaObjClearProps.add("schema");
        m_propsToClear.put(SchemaObject.class, schemaObjClearProps);
    }

    public static interface Initialiser {
        public void initialiseObject(DBObject var1, DBObject var2);
    }
}

