/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SchemaObjectIterator
implements Iterator<SchemaObject> {
    private boolean m_started;
    private Iterator<? extends DBObjectProvider> m_proI;
    private DBObjectProvider m_currPro;
    private Iterator<Schema> m_schemaI;
    private Schema m_currSchema;
    private Iterator<SchemaObject> m_objI;
    private SchemaObject m_currObj;
    private String[] m_types;

    public SchemaObjectIterator(List<? extends DBObjectProvider> pros) {
        this.m_proI = pros.iterator();
        if (this.hasNext(this.m_proI)) {
            this.m_currPro = this.m_proI.next();
        }
        if (this.m_currPro == null) {
            throw new IllegalStateException("Must have at least one provider");
        }
    }

    public SchemaObjectIterator(DBObjectProvider ... pros) {
        this(Arrays.asList(pros));
    }

    public SchemaObjectIterator(DBObjectProvider pro) {
        this.m_currPro = pro;
    }

    public void setTypes(String ... types) {
        if (this.m_started) {
            throw new IllegalStateException("Cannot modify iterator parameters after it has been started");
        }
        this.m_types = types;
    }

    private void start() {
        if (!this.m_started) {
            this.m_started = true;
            this.providerChanged();
        }
    }

    private boolean hasNext(Iterator i) {
        return i != null && i.hasNext();
    }

    private void nextProvider() {
        this.m_currPro = this.hasNext(this.m_proI) ? this.m_proI.next() : null;
        if (this.m_currPro == null) {
            this.m_currSchema = null;
            this.m_schemaI = null;
            this.m_currObj = null;
            this.m_objI = null;
        } else {
            this.providerChanged();
        }
    }

    private void providerChanged() {
        try {
            this.m_schemaI = Arrays.asList(this.m_currPro.listSchemas(false)).iterator();
        }
        catch (DBException dbe) {
            this.m_schemaI = null;
        }
        this.nextSchema();
    }

    private void nextSchema() {
        this.m_currSchema = this.hasNext(this.m_schemaI) ? this.m_schemaI.next() : null;
        if (this.m_currSchema == null) {
            this.m_currObj = null;
            this.m_objI = null;
            this.nextProvider();
        } else {
            try {
                String[] types = this.m_types == null ? this.m_currPro.listObjectTypes() : this.m_types;
                this.m_objI = Arrays.asList(this.m_currPro.listObjects(types, this.m_currSchema)).iterator();
            }
            catch (DBException dbe) {
                this.m_objI = null;
            }
            this.nextObject();
        }
    }

    private void nextObject() {
        this.m_currObj = this.hasNext(this.m_objI) ? this.m_objI.next() : null;
        if (this.m_currObj == null) {
            this.nextSchema();
        }
    }

    @Override
    public boolean hasNext() {
        this.start();
        return this.m_currObj != null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SchemaObject next() {
        this.start();
        SchemaObject retval = this.m_currObj;
        this.nextObject();
        return retval;
    }
}

