/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.Collection;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.ValidationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameInUseException
extends ValidationException {
    private String m_name;
    private String m_userName;
    private String m_userType;

    public NameInUseException(DBObject obj) {
        super(obj, DBArb.format(65, obj == null ? "" : obj.getName()));
    }

    public NameInUseException(Collection<? extends DBObject> objs) {
        super(NameInUseException.firstObj(objs), NameInUseException.getMessage(objs));
    }

    public NameInUseException(String name) {
        super(null, DBArb.format(65, name));
    }

    public NameInUseException(String name, String userName, String userType) {
        super(null, NameInUseException.getMessage(name, userName, userType));
        this.m_userType = userType;
        this.m_userName = userName;
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public String getUserName() {
        return this.m_userName;
    }

    public String getUserType() {
        return this.m_userType;
    }

    private static String getMessage(String name, String userName, String userType) {
        if (userName != null) {
            return DBArb.format(66, name, userType == null ? "" : userType.toLowerCase(), userName);
        }
        return DBArb.format(65, name);
    }

    private static DBObject firstObj(Collection<? extends DBObject> objs) {
        return objs == null || objs.size() == 0 ? null : objs.iterator().next();
    }

    private static String getMessage(Collection<? extends DBObject> objs) {
        StringBuilder buff = new StringBuilder();
        if (objs != null) {
            for (DBObject dBObject : objs) {
                if (dBObject == null) continue;
                if (buff.length() > 0) {
                    buff.append(", ");
                }
                buff.append(dBObject.getName());
            }
        }
        return buff.length() > 0 ? DBArb.format(67, buff.toString()) : DBArb.format(65, "");
    }
}

