/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractSchemaObject;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.Table;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.IndexObject;
import oracle.javatools.db.sql.SimpleSQLFragment;
import oracle.javatools.util.ModelUtil;

public class Index
extends AbstractSchemaObject
implements ChildDBObject {
    public static final String TYPE = "INDEX";
    private transient Table m_table;

    public Index() {
    }

    public Index(String name, Table table) {
        super(name, table == null ? null : table.getSchema());
        this.m_table = table;
        if (this.m_table != null) {
            this.m_table.addIndex(this);
        }
    }

    public Index(String name, Schema schema) {
        super(name, schema);
    }

    public Index(String name, Schema schema, Table table) {
        super(name, schema);
        this.m_table = table;
        if (this.m_table != null) {
            this.m_table.addIndex(this);
        }
        this.setSchema(schema);
    }

    public IndexType getIndexType() {
        return (IndexType)((Object)this.getProperty("indexType"));
    }

    public DBObjectID getDomainIndextype() {
        return (DBObjectID)this.getProperty("domainIndextype");
    }

    public String getDomainIndextypeParameters() {
        return (String)this.getProperty("domainIndextypeParameters");
    }

    public String getDomainIndextypeOpStatus() {
        return (String)this.getProperty("domainIndextypeOpStatus");
    }

    public int getParallelDegree() {
        return (Integer)this.getProperty("parallelDegree", 1);
    }

    public void setIndexType(IndexType indexType) {
        this.setProperty("indexType", (Object)indexType);
    }

    public void setDomainIndextype(DBObjectID id) {
        this.setProperty("domainIndextype", id);
    }

    public void setDomainIndextypeParameters(String parameters) {
        this.setProperty("domainIndextypeParameters", parameters);
    }

    public void setDomainIndextypeOpStatus(String status) {
        this.setProperty("domainIndextypeOpStatus", status);
    }

    public void setParallelDegree(int value) {
        this.setProperty("parallelDegree", value);
    }

    public void setKeyCompression(Integer keyCompression) {
        this.setProperty("keyCompression", keyCompression);
    }

    public Integer getKeyCompression() {
        return (Integer)this.getProperty("keyCompression");
    }

    public void setTable(Table table) {
        Table oldTable = this.m_table;
        if (this.m_table != table) {
            this.m_table = table;
            Schema s = this.getSchema();
            if (s != null && this.m_table != null) {
                Schema tabSchema = this.m_table.getSchema();
                if (tabSchema != null && ModelUtil.areEqual((Object)s.getName(), (Object)tabSchema.getName())) {
                    this.setSchema(null);
                }
            } else if (s == null && table == null && oldTable != null) {
                super.setSchema(oldTable.getSchema());
            }
        }
    }

    @Transient
    public Table getTable() {
        this.checkInit();
        return this.m_table;
    }

    @Transient
    public DBObject getParent() {
        return this.m_table;
    }

    @Transient
    public void setParent(DBObject par) {
        if (par instanceof Table) {
            this.setTable((Table)par);
        }
    }

    public Object getProperty(String key) {
        if ("parent".equals(key) || "table".equals(key)) {
            return this.getTable();
        }
        return super.getProperty(key);
    }

    public void setProperty(String key, Object value) {
        if ("parent".equals(key) || "table".equals(key)) {
            this.setTable((Table)value);
        } else {
            super.setProperty(key, value);
        }
    }

    public String getType() {
        return TYPE;
    }

    public void setColumnExpressions(IndexObject[] colExprs) {
        this.getChildSupport("columnExpressions").setChildArray(colExprs);
    }

    public IndexObject[] getColumnExpressions() {
        return this.getChildSupport("columnExpressions").getChildArray(IndexObject.class);
    }

    public void addColumnExpression(IndexObject colExpr) {
        this.getChildSupport("columnExpressions").addChild(colExpr);
    }

    public void addColumnExpression(int posn, IndexObject colExpr) {
        this.getChildSupport("columnExpressions").addChild(posn, (Object)colExpr);
    }

    public void removeColumnExpression(IndexObject colExpr) {
        this.getChildSupport("columnExpressions").removeChild(colExpr);
    }

    public DBObject findOwnedObject(DBObjectID id) {
        return this.findOwnedObject(id, true);
    }

    public Schema getSchema() {
        Schema s = super.getSchema();
        if (s == null && this.m_table != null) {
            s = this.m_table.getSchema();
        }
        return s;
    }

    public void setSchema(Schema s) {
        if (this.m_table == null || ModelUtil.areDifferent((Object)s, (Object)this.m_table.getSchema())) {
            super.setSchema(s);
        } else {
            super.setSchema(null);
        }
    }

    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(copy, copyParent, idPolicy);
        ((Index)copy).m_table = (Table)copyParent;
        if (copyParent == null && this.m_table != null) {
            ((Index)copy).m_table = this.m_table;
        }
    }

    @Deprecated
    @Transient
    public void setColumns(Column[] cols) {
        for (Column col : cols) {
            String name = col.getName();
            if (!ModelUtil.hasLength((String)name)) continue;
            IndexObject io = new IndexObject(new SimpleSQLFragment(name));
            this.addColumnExpression(io);
        }
    }

    @Deprecated
    @Transient
    public Column[] getColumns() {
        return null;
    }

    @Deprecated
    public void addColumn(Column col) {
    }

    @Deprecated
    public void removeColumn(Column col) {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IndexType {
        NORMAL,
        UNIQUE,
        BITMAP,
        DOMAIN;


        public static IndexType migrate(String old) {
            try {
                int i = Integer.valueOf(old.toString());
                switch (i) {
                    case 2: {
                        return UNIQUE;
                    }
                    case 3: {
                        return BITMAP;
                    }
                    case 4: {
                        return DOMAIN;
                    }
                }
                return NORMAL;
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

