/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.plsql.PlSqlCompilerOptions;

public class GlobalSettings
extends HashStructureAdapter {
    public static final String PREFS_KEY = "oracle.javatools.db.GlobalSettings";
    private static final String DATETIME = "validateDateTime";
    private static final String COMPILEROPTS = "plsqlCompilerOptions";
    private static final String PLSQLCASE = "plsqlLowerCase";

    public static final GlobalSettings getInstance() {
        return DBCore.getInstance().get(GlobalSettings.class);
    }

    public static final void initialiseInstance(PropertyStorage props) {
        GlobalSettings existing = GlobalSettings.getInstance();
        if (existing != null) {
            new IllegalStateException("Database GlobalSettings already exist, shouldn't initialise twice.").printStackTrace();
        }
        DBCore.getInstance().put((Object)GlobalSettings.createGlobalSettings(props));
    }

    public static final GlobalSettings createGlobalSettings(PropertyStorage props) {
        return new GlobalSettings(GlobalSettings.findOrCreate((PropertyStorage)props, (String)PREFS_KEY));
    }

    private GlobalSettings(HashStructure hash) {
        super(hash);
    }

    public boolean isValidateDateTime() {
        return this._hash.getBoolean(DATETIME, true);
    }

    public void setValidateDateTime(boolean boo) {
        this._hash.putBoolean(DATETIME, boo);
    }

    public boolean isNewPlSqlLowerCase() {
        return this._hash.getBoolean(PLSQLCASE, false);
    }

    public void setNewPlSqlLowerCase(boolean newPlSqlLowerCase) {
        this._hash.putBoolean(PLSQLCASE, newPlSqlLowerCase);
    }

    public PlSqlCompilerOptions getPlSqlCompilerOptions() {
        return new PlSqlCompilerOptions(this._hash.getOrCreateHashStructure(COMPILEROPTS));
    }
}

