/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBObjectValidator;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.property.PropertyInitializer;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DatabaseDescriptor<T extends Database> {
    public static final String FEATURE_TABLE_PARTITIONING = "TABLE PARTITIONING";
    public static final String FEATURE_GLOBAL_HASH_INDEX_PARTITIONING = "GLOBAL HASH INDEX PARTITIONING";
    public static final String FEATURE_COLUMN_SEQUENCES = "COLUMN SEQUENCES";
    public static final String FEATURE_STORAGE_OPTIONS = "STORAGE OPTIONS";
    public static final String FEATURE_BITMAP_INDEXING = "BITMAP INDEXING";
    public static final String FEATURE_LOB_PARAMETERS = "LOB PARAMETERS";
    public static final String FEATURE_RETENTION = "RETENTION";
    public static final String FEATURE_FREEPOOLS = "FREEPOOLS";
    public static final String FEATURE_MAXTRANS = "MAXTRANS";
    public static final String FEATURE_XMLTYPE_COL_PROPS = "XMLTYPE COLUMN STORAGE PROPERTIES";
    private DatabaseDescriptor m_base;
    private Charset m_ideCharset;
    private final Class<? extends T> m_databaseClass;

    protected DatabaseDescriptor(Class<? extends T> clz) {
        if (clz == null) {
            throw new IllegalArgumentException("Descriptor class cannot be null");
        }
        this.m_databaseClass = clz;
    }

    protected DatabaseDescriptor(DatabaseDescriptor base) {
        this(base.getDatabaseClass());
        this.m_base = base;
    }

    protected final Class<? extends T> getDatabaseClass() {
        if (this.m_databaseClass == null) {
            return this.m_base.getDatabaseClass();
        }
        return this.m_databaseClass;
    }

    public abstract String getDatabaseType();

    public abstract int getDatabaseVersion();

    protected DatabaseDescriptor getBaseDescriptor() {
        return this.m_base;
    }

    public void setIdeCharset(Charset charSet) {
        this.m_ideCharset = charSet;
    }

    public Charset getIdeCharset() {
        return this.m_ideCharset;
    }

    public abstract boolean isCompatibleUpgrade(Class<? extends Database> var1, Class<? extends Database> var2);

    public final boolean isValidName(String type, String name) {
        try {
            this.validateName(type, name);
        }
        catch (InvalidNameException ine) {
            return false;
        }
        return true;
    }

    public abstract void validateName(String var1, String var2) throws InvalidNameException;

    public abstract int getCasePolicy();

    public int getQuotedNameCasePolicy() {
        if (this.m_base != null) {
            return this.m_base.getQuotedNameCasePolicy();
        }
        return 3;
    }

    public abstract String getIdentifierQuoteString();

    public abstract int getMaxNameLength(String var1);

    public boolean supportsFeature(String feature) {
        if (this.m_base != null) {
            return this.m_base.supportsFeature(feature);
        }
        return false;
    }

    public void validateEncoding(String string, Object property) throws ValidationException {
    }

    protected boolean needsQuoting(String internalName) {
        if (this.m_base != null) {
            return this.m_base.needsQuoting(internalName);
        }
        if (ModelUtil.hasLength((String)internalName) && internalName.length() == internalName.trim().length() && this.isValidName(null, internalName)) {
            switch (this.getCasePolicy()) {
                case 2: {
                    return ModelUtil.areDifferent((Object)internalName, (Object)internalName.toUpperCase());
                }
                case 1: {
                    return ModelUtil.areDifferent((Object)internalName, (Object)internalName.toLowerCase());
                }
            }
            return false;
        }
        return true;
    }

    public String quoteIdentifier(String internalName, boolean force) throws DBException {
        if (this.m_base != null) {
            return this.m_base.quoteIdentifier(internalName, force);
        }
        String quote = this.getIdentifierQuoteString();
        String string = quote = quote != null ? quote.trim() : "";
        if (!ModelUtil.hasLength((String)internalName)) {
            internalName = null;
        } else if (quote.length() == 0) {
            if (!this.isValidName(null, internalName)) {
                internalName = null;
            }
        } else if ((force || this.needsQuoting(internalName)) && !this.isValidName(null, internalName = DBUtil.quoteName(internalName, quote))) {
            internalName = null;
        }
        if (internalName == null) {
            throw new DBException(null, "Invalid name");
        }
        return internalName;
    }

    public String getInternalName(String name, String objectType) {
        if (this.m_base != null) {
            return this.m_base.getInternalName(name, objectType);
        }
        String quote = this.getIdentifierQuoteString();
        int casePolicy = this.getCasePolicy();
        String internalName = name;
        if (ModelUtil.hasLength((String)name)) {
            name = name.trim();
            if (ModelUtil.hasLength((String)quote)) {
                int qLen = quote.length();
                int nLen = name.length();
                int idx1 = name.indexOf(quote);
                int idx2 = name.lastIndexOf(quote);
                if (nLen > qLen && idx1 == 0 && idx2 == nLen - qLen) {
                    internalName = name.substring(idx1 + qLen, idx2);
                    idx1 = internalName.indexOf(quote);
                    while (idx1 > -1 && idx1 < internalName.length()) {
                        idx2 = internalName.indexOf(quote, idx1 + qLen);
                        if (idx2 == idx1 + qLen) {
                            internalName = internalName.substring(0, idx1 + 1) + internalName.substring(idx2 + qLen);
                        }
                        idx1 = internalName.indexOf(quote, idx1 + qLen);
                    }
                }
            }
            if (ModelUtil.areEqual((Object)internalName, (Object)name)) {
                switch (casePolicy) {
                    case 2: {
                        internalName = name.toUpperCase();
                        break;
                    }
                    case 1: {
                        internalName = name.toLowerCase();
                        break;
                    }
                }
            }
        }
        return internalName;
    }

    public String getExternalName(String name, String objectType) {
        try {
            name = this.quoteIdentifier(name, false);
        }
        catch (DBException dBException) {
            // empty catch block
        }
        return name;
    }

    public abstract Map<String, DBObjectValidator> getValidators(DBObjectProvider var1);

    public abstract List<PropertyInitializer> getPropertyInitializers(DBObjectProvider var1);

    public abstract List<PropertyInitializer> getExternalPropertyDefaulters(DBObjectProvider var1);

    public DDLGenerator getDDLGenerator(DBObjectProvider pro) {
        return null;
    }

    public SQLQueryBuilderFactory getSQLQueryBuilderFactory() {
        return null;
    }

    public Collection<DataType> listSupportedDataTypes() {
        ArrayList<DataType> types = new ArrayList<DataType>();
        Class<T> clz = this.getDatabaseClass();
        if (clz != null) {
            for (DataType type : DataTypeRegistry.getInstance().listDataTypes(clz)) {
                types.add(type);
            }
        }
        return types;
    }

    public final Collection<DataType> listPreferredDataTypes() {
        ArrayList<DataType> retval = new ArrayList<DataType>();
        for (String name : this.listPreferredDataTypeNames()) {
            DataType dt = this.getDataType(name);
            if (dt == null) continue;
            retval.add(dt);
        }
        return retval;
    }

    public Collection<String> listPreferredDataTypeNames() {
        return Collections.emptyList();
    }

    public DataTypeUsage createDefaultTypeUsage() {
        DataType dt;
        DataTypeUsage retval = null;
        Collection<DataType> types = this.listPreferredDataTypes();
        if (types.size() > 0) {
            retval = types.iterator().next().createDefaultUsage();
        }
        if (retval == null && (dt = this.findDataType("VARCHAR2", "VARCHAR", "CHAR", "CHARACTER")) != null) {
            retval = dt.createDefaultUsage();
        }
        return retval;
    }

    private DataType findDataType(String ... names) {
        DataType dt = null;
        Class<T> clz = this.getDatabaseClass();
        if (clz != null) {
            for (String name : names) {
                dt = DataTypeRegistry.getInstance().findDataType(name, clz);
                if (dt != null) break;
            }
        }
        return dt;
    }

    public DataType getDataType(String typeName) {
        DataType type = null;
        Class<T> clz = this.getDatabaseClass();
        if (clz != null) {
            DataTypeRegistry dtr = DataTypeRegistry.getInstance();
            type = dtr.findDataType(typeName, clz);
        }
        return type;
    }

    public final boolean isValidFKDataType(DataType fktype, DataType reftype) {
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        if (dtr.isSynonymType(fktype)) {
            fktype = dtr.getBaseType(fktype);
        }
        if (dtr.isSynonymType(reftype)) {
            reftype = dtr.getBaseType(reftype);
        }
        return this.isValidFKDataTypeImpl(fktype, reftype);
    }

    protected boolean isValidFKDataTypeImpl(DataType fktype, DataType reftype) {
        return ModelUtil.areEqual((Object)fktype, (Object)reftype);
    }

    public static void validateIdentifier(String identifier, char quoter, int maxLength, String allowedChars, String excludedChars, boolean alphaStart, Set reservedWords, int casePolicy) throws InvalidNameException {
        if (!ModelUtil.hasLength((String)identifier)) {
            throw new InvalidNameException(null, DBArb.getString(5));
        }
        if (identifier.charAt(0) == quoter) {
            int len = identifier.length();
            if (identifier.charAt(len - 1) != quoter) {
                throw new InvalidNameException(null, DBArb.format(7, identifier));
            }
            if (len <= 2) {
                throw new InvalidNameException(null, DBArb.format(5, identifier));
            }
            int embeddedQuoteCount = 0;
            for (int idx = 1; idx < len - 1; ++idx) {
                if (excludedChars != null && excludedChars.indexOf(identifier.charAt(idx)) >= 0) {
                    throw new InvalidNameException(null, DBArb.format(9, identifier));
                }
                if (identifier.charAt(idx) != quoter) continue;
                if (++idx == len - 1 || identifier.charAt(idx) != quoter) {
                    throw new InvalidNameException(null, DBArb.format(9, identifier));
                }
                ++embeddedQuoteCount;
            }
            if (len - embeddedQuoteCount > maxLength + 2) {
                throw new InvalidNameException(null, DBArb.format(6, identifier));
            }
        } else {
            if (identifier.length() > maxLength) {
                throw new InvalidNameException(null, DBArb.format(6, identifier));
            }
            if (casePolicy == 2) {
                identifier = identifier.toUpperCase();
            } else if (casePolicy == 1) {
                identifier = identifier.toLowerCase();
            }
            if (reservedWords != null && reservedWords.contains(identifier)) {
                throw new InvalidNameException(null, DBArb.format(10, identifier));
            }
            char[] chars = identifier.toCharArray();
            if (alphaStart && !Character.isLetter(chars[0])) {
                throw new InvalidNameException(null, DBArb.format(8, identifier));
            }
            if (allowedChars != null) {
                for (int i = 1; i < chars.length; ++i) {
                    char c = chars[i];
                    if (Character.isLetterOrDigit(c) || allowedChars.indexOf(c) >= 0) continue;
                    throw new InvalidNameException(null, DBArb.format(9, identifier));
                }
            }
        }
    }

    public static void validateIdentifier(String identifier, char quoter, int maxLength, String allowedChars, boolean alphaStart, Set reservedWords, int casePolicy) throws InvalidNameException {
        DatabaseDescriptor.validateIdentifier(identifier, quoter, maxLength, allowedChars, null, alphaStart, reservedWords, casePolicy);
    }

    public abstract void makeNameValidAndUnique(DBObject var1, DBObjectProvider var2) throws InvalidNameException;
}

