/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.CascadeManager;
import oracle.javatools.db.Constraint;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.FKConstraint;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.PlSql;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.UniqueConstraint;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.diff.GenericIDComparator;
import oracle.javatools.db.plsql.PlSqlDeclaratorFactory;
import oracle.javatools.db.sql.AbstractSQLQuery;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryBuilderFactory;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBUtil
implements Comparator<DBObject> {
    private static Comparator<DBObject> s_typeComparator;
    private static Comparator<DBObject> s_nameComparator;
    private boolean m_compareByType;

    protected DBUtil() {
    }

    private static Logger getLogger() {
        return DBLog.getLogger(DBUtil.class);
    }

    @Override
    public int compare(DBObject o1, DBObject o2) {
        if (o1 == null) {
            if (o2 == null) {
                return 0;
            }
            return -10;
        }
        if (o2 == null) {
            return 10;
        }
        return this.compareImpl(o1, o2);
    }

    private int compareImpl(DBObject o1, DBObject o2) {
        int nameCompare;
        int typeCompare;
        if (this.m_compareByType && (typeCompare = this.compareType(o1, o2)) != 0) {
            return typeCompare;
        }
        String n1 = o1.getName();
        String n2 = o2.getName();
        int n = n1 == null && n2 == null ? 0 : (n1 == null ? -10 : (nameCompare = n2 == null ? 10 : n1.compareTo(n2)));
        if (nameCompare == 0 && !this.m_compareByType) {
            return this.compareType(o1, o2);
        }
        return nameCompare;
    }

    private int compareType(DBObject o1, DBObject o2) {
        String t2;
        String t1 = o1.getType();
        int result = t1.compareTo(t2 = o2.getType());
        if (result == 0 && o1 instanceof Constraint) {
            t1 = ((Constraint)o1).getConstraintType();
            t2 = ((Constraint)o2).getConstraintType();
            return t1.compareTo(t2);
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof DBUtil && ((DBUtil)obj).m_compareByType == this.m_compareByType;
    }

    public int hashCode() {
        return this.m_compareByType ? 0 : 1;
    }

    public static Comparator<DBObject> getTypeComparator() {
        if (s_typeComparator == null) {
            s_typeComparator = new DBUtil();
            ((DBUtil)DBUtil.s_typeComparator).m_compareByType = true;
        }
        return s_typeComparator;
    }

    public static Comparator<DBObject> getNameComparator() {
        if (s_nameComparator == null) {
            s_nameComparator = new DBUtil();
            ((DBUtil)DBUtil.s_nameComparator).m_compareByType = false;
        }
        return s_nameComparator;
    }

    public static Map<DBObjectID, DBObjectID> getTemporaryIDMap(DBObject[] objs) {
        HashMap<DBObjectID, DBObjectID> idMap = new HashMap<DBObjectID, DBObjectID>();
        for (DBObject obj : objs) {
            DBUtil.poplateTempIDMap(obj, idMap);
        }
        return idMap;
    }

    private static void poplateTempIDMap(DBObject obj, Map<DBObjectID, DBObjectID> idMap) {
        DBObjectID newID = obj.getID();
        if (newID instanceof TemporaryObjectID) {
            try {
                DBObject orig = ((TemporaryObjectID)newID).resolveOriginalID();
                if (orig != null && orig.getID() != null) {
                    idMap.put(orig.getID(), newID);
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        for (DBObject kid : obj.getOwnedObjects()) {
            DBUtil.poplateTempIDMap(kid, idMap);
        }
    }

    public static <D extends DBObject> D makeTemporaryCopy(D object) {
        return (D)object.copyTo(null, true);
    }

    public static Map<String, Object> getFrozenProperties(DBObject obj) {
        Map<String, Object> props = obj instanceof AbstractBuildableObject ? ((AbstractBuildableObject)obj).getPropertySupport() : obj.getProperties();
        return Collections.unmodifiableMap(props);
    }

    public static boolean needsBuilding(SystemObject obj) {
        if (obj instanceof AbstractBuildableObject) {
            return ((AbstractBuildableObject)obj).needsInitialization();
        }
        return false;
    }

    public static boolean needsBuilding(AbstractBuildableObject obj, String property) {
        if (obj instanceof AbstractBuildableObject) {
            return !obj.isBuilt(property);
        }
        return false;
    }

    public static void ensureObjectBuilt(SystemObject object) throws DBException {
        AbstractBuildableObject obj;
        if (object instanceof AbstractBuildableObject && (obj = (AbstractBuildableObject)object).needsInitialization()) {
            obj.getPropertySupport().checkInitEx(null);
        }
    }

    public static boolean needsDerivedPropertiesBuilding(SystemObject obj) {
        SQLQuery query;
        if (obj instanceof SQLQueryOwner && (query = ((SQLQueryOwner)((Object)obj)).getSQLQuery()) != null) {
            return !query.isDeclarative();
        }
        return false;
    }

    public static void ensureDerivedPropertiesBuilt(SystemObject object, DBObjectProvider pro) throws DBException {
        DBUtil.ensureObjectBuilt(object);
        if (object instanceof SQLQueryOwner) {
            SQLQueryBuilder builder;
            SQLQuery query = ((SQLQueryOwner)((Object)object)).getSQLQuery();
            if (!query.isDeclarative() && (builder = SQLQueryBuilderFactory.createBuilder(pro)) != null) {
                block7: {
                    try {
                        builder.buildQuery(query);
                    }
                    catch (SQLQueryException sqe) {
                        if (!(sqe instanceof SQLParseException)) break block7;
                        throw sqe;
                    }
                }
                AbstractSQLQuery newQuery = builder.getSQLQuery();
                if (newQuery != null) {
                    ((SQLQueryOwner)((Object)object)).setSQLQuery(newQuery);
                }
            }
        } else if (object instanceof PlSql) {
            PlSqlDeclaratorFactory.loadDeclarativeInfo((PlSql)object, pro);
        }
    }

    public static Collection<DBObjectID> getReferenceIDs(DBObject obj, boolean recurse, IDQuery query, String ... types) {
        ArrayList<DBObjectID> refs = new ArrayList<DBObjectID>();
        DBUtil.getReferenceIDsImpl(obj, refs, recurse, query, new String[0]);
        return refs;
    }

    private static void getReferenceIDsImpl(DBObject obj, Collection<DBObjectID> refs, boolean recurse, IDQuery query, String ... types) {
        for (DBObjectID ref : obj.getReferenceIDs()) {
            if (types != null && types.length > 0 && Arrays.binarySearch(types, ref.getType()) < 0 || (query == IDQuery.INTERNAL ? !DBUtil.isInternalRef(ref, obj) : query == IDQuery.EXTERNAL && DBUtil.isInternalRef(ref, obj))) continue;
            refs.add(ref);
        }
        if (recurse) {
            for (DBObject owned : obj.getOwnedObjects()) {
                DBUtil.getReferenceIDsImpl(owned, refs, recurse, query, types);
            }
        }
    }

    public static boolean isInternalRef(DBObjectID ref, DBObject obj) {
        DBObject top = DBUtil.getUppermostParent(obj);
        DBObjectID topID = DBUtil.getUppermostParent(ref);
        return topID != null && ModelUtil.areEqual((Object)topID, (Object)top.getID());
    }

    public static boolean replaceReferenceIDs(DBObject obj, Map<DBObjectID, DBObjectID> idMap) {
        boolean retval = false;
        if (idMap != null && !idMap.isEmpty()) {
            retval = obj.replaceReferenceIDs(idMap);
            for (DBObject kid : obj.getOwnedObjects()) {
                retval = DBUtil.replaceReferenceIDs(kid, idMap) || retval;
            }
        }
        return retval;
    }

    public static void updateObjectAndIDs(DBObject oldVersion, DBObject newVersion) {
        ((AbstractDBObject)newVersion).copyTo(oldVersion, new IDPolicy(){

            protected DBObjectID getNewID(DBObject original, DBObject copy) {
                DBObjectID retval = original.getID();
                if (retval instanceof TemporaryObjectID) {
                    try {
                        DBObject origFromID = ((TemporaryObjectID)retval).resolveOriginalID();
                        if (origFromID == copy) {
                            retval = copy.getID();
                            if (retval == null) {
                                retval = TemporaryObjectID.createID(copy);
                            }
                        } else {
                            retval = origFromID == null ? TemporaryObjectID.createID(copy) : TemporaryObjectID.createID(copy);
                        }
                    }
                    catch (DBException dbe) {
                        // empty catch block
                    }
                }
                return retval;
            }
        });
    }

    private static void updateChildIDs(DBObject oldVersion, DBObject newVersion) {
        DBObject[] children = newVersion.getOwnedObjects();
        for (int i = 0; children != null && i < children.length; ++i) {
            DBObject oldChild = DBUtil.findMatchingChild(oldVersion, children[i]);
            if (oldChild == null) continue;
            oldChild.setID(children[i].getID());
            DBUtil.updateChildIDs(oldChild, children[i]);
        }
    }

    private static DBObject findMatchingChild(DBObject copyOfParent, DBObject child) {
        String nameToSearchFor = child.getName();
        if (nameToSearchFor == null) {
            DBObject[] kidsOfType = copyOfParent.getOwnedObjects(child.getType());
            if (kidsOfType != null && kidsOfType.length == 1) {
                return kidsOfType[0];
            }
        } else {
            return copyOfParent.findOwnedObject(child.getType(), child.getName());
        }
        return null;
    }

    public static <T extends DBObject> Collection<T> findChildren(DBObject obj, Class<T> ... clz) {
        ArrayList retval = new ArrayList();
        if (clz != null) {
            DBUtil.findChildrenImpl(retval, obj, clz);
        }
        return retval;
    }

    private static <T extends DBObject> void findChildrenImpl(Collection<T> found, DBObject obj, Class<T> ... clzs) {
        for (Class<T> clz : clzs) {
            if (!clz.isAssignableFrom(obj.getClass())) continue;
            found.add(clz.cast(obj));
        }
        for (DBObject kid : obj.getOwnedObjects()) {
            DBUtil.findChildrenImpl(found, kid, clzs);
        }
    }

    public static DBObject findChildInCopy(DBObject orig, DBObject copy, DBObject origChild) {
        if (orig == null || copy == null || origChild == null) {
            throw new IllegalArgumentException("Arguments cannot be null.");
        }
        if (orig == origChild) {
            return copy;
        }
        DBObject[] copyChildren = copy.getOwnedObjects();
        for (int i = 0; copyChildren != null && i < copyChildren.length; ++i) {
            DBObject child;
            DBObjectID id = copyChildren[i].getID();
            if (!(id instanceof TemporaryObjectID)) continue;
            DBObject origFromID = null;
            try {
                origFromID = ((TemporaryObjectID)id).resolveOriginalID();
            }
            catch (DBException dbe) {
                // empty catch block
            }
            if (origFromID == origChild) {
                return copyChildren[i];
            }
            if (origFromID == null || (child = DBUtil.findChildInCopy(origFromID, copyChildren[i], origChild)) == null) continue;
            return child;
        }
        return null;
    }

    public static String getUniqueName(Collection existing, String base) {
        return DBUtil.getUniqueName(existing, base, true);
    }

    public static String getUniqueName(Collection existing, String base, boolean increment) {
        String retval = null;
        if (existing == null || !existing.contains(base)) {
            retval = base;
        } else {
            int start = 1;
            int n = base.length() - 1;
            if (increment) {
                while (Character.isDigit(base.charAt(n))) {
                    if (n > 0) {
                        --n;
                        continue;
                    }
                    n = base.length() - 1;
                    break;
                }
                try {
                    start = Integer.parseInt(base.substring(n + 1));
                    base = base.substring(0, n + 1);
                }
                catch (NumberFormatException e) {}
            } else if (Character.isDigit(base.charAt(n))) {
                base = base + "_";
            }
            int i = start;
            while (retval == null) {
                String tryThis = base + i;
                if (!existing.contains(tryThis)) {
                    retval = tryThis;
                }
                ++i;
            }
        }
        return retval;
    }

    public static String getFullyQualifiedName(DBObject obj) {
        return DBUtil.getFullyQualifiedName(obj, false);
    }

    public static String getFullyQualifiedName(DBObject obj, boolean incSchema) {
        Schema schema;
        DBObject par = obj.getParent();
        String name = null;
        name = par == null ? (obj instanceof SchemaObject && incSchema ? ((schema = ((SchemaObject)obj).getSchema()) == null ? "" : schema.getName() + ".") : "") : DBUtil.getFullyQualifiedName(par, incSchema) + ".";
        String objName = obj.getName();
        if (objName != null) {
            name = name + objName;
        }
        return name;
    }

    public static Schema getSchema(DBObject obj) {
        Schema retval = null;
        if (obj instanceof SchemaObject) {
            retval = ((SchemaObject)obj).getSchema();
        } else if (obj != null) {
            DBObject parent = obj.getParent();
            if (parent instanceof Schema) {
                retval = (Schema)parent;
            } else if (parent != null) {
                retval = DBUtil.getSchema(parent);
            }
        }
        return retval;
    }

    public static SchemaObject getSchemaObject(DBObject obj) {
        return DBUtil.getTopParent(obj, SchemaObject.class);
    }

    public static SystemObject getSystemObject(DBObject obj) {
        return DBUtil.getTopParent(obj, SystemObject.class);
    }

    private static <T extends DBObject> T getTopParent(DBObject obj, Class<T> parClz) {
        if (obj == null) {
            return null;
        }
        DBObject parent = obj.getParent();
        if (parent != null) {
            return DBUtil.getTopParent(parent, parClz);
        }
        if (parClz.isAssignableFrom(obj.getClass())) {
            return (T)((DBObject)parClz.cast(obj));
        }
        return null;
    }

    public static DBObject getUppermostParent(DBObject obj) {
        DBObject parent = obj.getParent();
        if (parent != null) {
            return DBUtil.getUppermostParent(parent);
        }
        return obj;
    }

    public static DBObjectID getUppermostParent(DBObjectID id) {
        DBObjectID parent;
        if (id instanceof TemporaryObjectID) {
            try {
                DBObject parent2;
                DBObjectID topID;
                DBObject obj = id.resolveID();
                if (obj != null && (topID = (parent2 = DBUtil.getUppermostParent(obj)).getID()) != null) {
                    return topID;
                }
            }
            catch (DBException dbe) {
                // empty catch block
            }
        }
        if ((parent = id.getParent()) != null) {
            return DBUtil.getUppermostParent(parent);
        }
        return id;
    }

    public static Map<Schema, Collection<SystemObject>> sortIntoSchemas(SystemObject ... objs) {
        TreeMap<DBObject, ArrayList<SystemObject>> mapped = new TreeMap<DBObject, ArrayList<SystemObject>>(DBUtil.getNameComparator());
        for (SystemObject obj : objs) {
            Schema s = DBUtil.getSchema(obj);
            ArrayList<SystemObject> col = (ArrayList<SystemObject>)mapped.get(s);
            if (col == null) {
                col = new ArrayList<SystemObject>();
                mapped.put(s, col);
            }
            col.add(obj);
        }
        return mapped;
    }

    public static <T extends DBObject> T getProviderDefinition(T obj, DBObjectProvider pro) throws DBException {
        DBObject retval = null;
        if (obj instanceof SystemObject) {
            DBObjectCriteria<SystemObject> criteria = new DBObjectCriteria<SystemObject>((SystemObject)obj);
            retval = pro.getObject(criteria);
        } else {
            DBObject proDefParent;
            DBObject parent = obj.getParent();
            if (parent != null && (proDefParent = DBUtil.getProviderDefinition(parent, pro)) != null) {
                retval = proDefParent.findOwnedObject(obj.getType(), obj.getName());
            }
        }
        return (T)retval;
    }

    public static DBObject getProviderDefinition(DBObject obj, DBObjectProvider pro, String schemaName) throws DBException {
        DBObject proDefParent;
        if (obj instanceof SchemaObject) {
            return DBUtil.getProviderDefinition((SchemaObject)obj, pro, schemaName);
        }
        DBObject parent = obj.getParent();
        if (parent != null && (proDefParent = DBUtil.getProviderDefinition(parent, pro, schemaName)) != null) {
            return proDefParent.findOwnedObject(obj.getType(), obj.getName());
        }
        return null;
    }

    public static <T extends SchemaObject> T getProviderDefinition(T obj, DBObjectProvider pro, String schemaName) throws DBException {
        DBObjectCriteria<T> crit = new DBObjectCriteria<T>(obj);
        crit.setSchemaName(schemaName);
        return pro.getObject(crit);
    }

    public static <T extends SystemObject> T[] getProviderDefinitions(T[] objs, DBObjectProvider pro) throws DBException {
        SystemObject[] retval = (SystemObject[])Array.newInstance(objs.getClass().getComponentType(), objs.length);
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            retval[i] = (SystemObject)DBUtil.getProviderDefinition(objs[i], pro);
        }
        return retval;
    }

    public static DBObject getProviderDefinition(ReferenceID refID, DBObjectProvider pro) throws DBException {
        DBObject retval = null;
        String type = refID.getType();
        if (ModelUtil.hasLength((String)type)) {
            String name = refID.getName();
            DBObjectID par = refID.getParent();
            if (par != null) {
                if (par instanceof ReferenceID) {
                    DBObject parObj = DBUtil.getProviderDefinition((ReferenceID)par, pro);
                    retval = parObj == null ? null : parObj.findOwnedObject(type, name);
                }
            } else {
                String schemaName = refID.getSchemaName();
                if (ModelUtil.hasLength((String)schemaName) && ModelUtil.hasLength((String)name)) {
                    DBObjectCriteria<SystemObject> crit = DBObjectCriteria.createCriteria(type, refID.getSchemaName(), name);
                    retval = pro.getObject(crit);
                }
            }
        }
        return retval;
    }

    public static <T> T[] stripNulls(T[] objs) {
        ArrayList<T> retval = new ArrayList<T>();
        for (int i = 0; i < objs.length; ++i) {
            if (objs[i] == null) continue;
            retval.add(objs[i]);
        }
        return retval.toArray((Object[])Array.newInstance(objs.getClass().getComponentType(), retval.size()));
    }

    public static String quoteName(String name, String quote) {
        if (ModelUtil.hasLength((String)name) && ModelUtil.hasLength((String)quote)) {
            int idx = name.indexOf(quote);
            while (idx > -1 && idx < name.length()) {
                name = name.substring(0, idx) + quote + name.substring(idx);
                idx = name.indexOf(quote, idx + quote.length() + 1);
            }
            name = quote + name + quote;
        }
        return name;
    }

    public static boolean isCompoundName(String name, String quote) {
        boolean result = false;
        if (ModelUtil.hasLength((String)name) && ModelUtil.hasLength((String)quote)) {
            int idx = name.indexOf(quote);
            if (idx == 0) {
                String substr = name.substring(1);
                idx = substr.indexOf(quote);
                while (idx > -1 && idx < substr.length() - 1) {
                    if (substr.startsWith(quote, idx + 1)) {
                        substr = substr.substring(idx + 2);
                        idx = substr.indexOf(quote);
                        continue;
                    }
                    substr = substr.substring(idx + 1);
                    break;
                }
                result = substr.startsWith(".");
            } else {
                idx = name.indexOf(".");
                result = idx > -1;
            }
        }
        return result;
    }

    public static boolean isDangling(DBObjectID refID) {
        boolean isDangling = false;
        if (refID instanceof ReferenceID) {
            try {
                DBObject dbo = refID.resolveID();
                isDangling = null == dbo;
            }
            catch (DBException dbe) {
                isDangling = true;
            }
        }
        return isDangling;
    }

    public static DBObjectID getOriginalID(DBObject dbo) {
        DBObjectID retval = null;
        DBObjectID id = dbo.getID();
        if (id instanceof TemporaryObjectID) {
            retval = TemporaryObjectID.findOriginalID((TemporaryObjectID)id);
        }
        return retval;
    }

    public static Collection<DBObject> findUsagesIn(DBObject used, DBObject searchRoot) {
        DBObjectID id;
        ArrayList<DBObject> retval = new ArrayList<DBObject>();
        if (used != null && (id = used.getID()) != null) {
            DBUtil.findUsagesImpl(id, searchRoot, retval);
        }
        return retval;
    }

    private static void findUsagesImpl(DBObjectID id, DBObject searchRoot, Collection<DBObject> retval) {
        GenericIDComparator comparator = new GenericIDComparator(true);
        if (searchRoot != null) {
            for (DBObjectID refid : searchRoot.getReferenceIDs()) {
                if (comparator.compare(refid, id) != 0) continue;
                retval.add(searchRoot);
            }
            for (DBObject kid : searchRoot.getOwnedObjects()) {
                DBUtil.findUsagesImpl(id, kid, retval);
            }
        }
    }

    public static FKConstraint[] getReferences(Constraint ucon, DBObjectProvider prov) {
        ArrayList<FKConstraint> result = new ArrayList<FKConstraint>();
        if (ucon instanceof UniqueConstraint) {
            CascadeManager man = prov.getCascadeManager();
            for (DBObjectID ref : man.listReferers(ucon)) {
                try {
                    DBObject obj = ref.resolveID();
                    if (!(obj instanceof FKConstraint)) continue;
                    result.add((FKConstraint)obj);
                }
                catch (DBException dbe) {
                    DBUtil.getLogger().log(Level.WARNING, "Couldn't resolve reference to constraint: " + dbe.getMessage());
                }
            }
        }
        return result.toArray(new FKConstraint[result.size()]);
    }

    public static String getDBObjectName(DBObjectID id) {
        String name = "";
        if (id != null) {
            if (id instanceof BaseObjectID) {
                name = ((BaseObjectID)id).getName();
            } else if (id instanceof DataTypeID) {
                name = ((DataTypeID)id).getTypeName();
            }
            if (!ModelUtil.hasLength((String)name)) {
                try {
                    DBObject dbObject = id.resolveID();
                    if (dbObject != null) {
                        name = dbObject.getName();
                    }
                }
                catch (DBException dBException) {
                    // empty catch block
                }
            }
        }
        return name;
    }

    public static String getSchemaName(DBObjectID dbObjectID) {
        if (dbObjectID != null) {
            try {
                Schema s;
                DBObject dbObject = dbObjectID.resolveID();
                if (dbObject instanceof SchemaObject && (s = ((SchemaObject)dbObject).getSchema()) != null) {
                    return s.getName();
                }
            }
            catch (DBException dBException) {
                // empty catch block
            }
            if (dbObjectID instanceof ReferenceID) {
                return ((ReferenceID)dbObjectID).getSchemaName();
            }
        }
        return "";
    }

    public static DBObject resolveInOtherProvider(BaseObjectID id, DBObjectProvider pro) throws DBException {
        BaseObjectID copy;
        DBObject res;
        DBObjectProvider idPro = id.getProvider();
        if (idPro == pro) {
            return id.resolveID();
        }
        if (pro instanceof AbstractDBObjectProvider && (res = (copy = BaseObjectID.copyWithNewProvider(id, (AbstractDBObjectProvider)pro)).resolveID()) != null) {
            return res;
        }
        if (id instanceof NameBasedID) {
            return pro.getObject(DBObjectCriteria.createCriteria(id.getType(), id.getSchemaName(), id.getName()));
        }
        return null;
    }

    public static boolean areEqualIgnoreNullValues(Map map1, Map map2) {
        boolean mapsAreEqual = true;
        if (map1 != map2) {
            HashSet allKeys = new HashSet();
            if (map1 != null) {
                allKeys.addAll(map1.keySet());
            }
            if (map2 != null) {
                allKeys.addAll(map2.keySet());
            }
            for (Object key : allKeys) {
                Object val2;
                Object val1 = DBUtil.getValue(map1, key);
                if (!ModelUtil.areDifferent((Object)val1, (Object)(val2 = DBUtil.getValue(map2, key)))) continue;
                mapsAreEqual = false;
                break;
            }
        }
        return mapsAreEqual;
    }

    private static Object getValue(Map map, Object key) {
        Object retval = null;
        if (map != null && (retval = map.get(key)) instanceof Collection && ((Collection)retval).isEmpty()) {
            retval = null;
        }
        return retval;
    }

    public static void suspendTimestampChecking(DBObjectProvider pro, String timestampKey) {
        if (pro instanceof AbstractDBObjectProvider) {
            ((AbstractDBObjectProvider)pro).suspendTimestampQueries(timestampKey);
        }
    }

    public static void resumeTimestampChecking(DBObjectProvider pro, String timestampKey) {
        if (pro instanceof AbstractDBObjectProvider) {
            ((AbstractDBObjectProvider)pro).resumeTimestampQueries(timestampKey);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IDQuery {
        INTERNAL,
        EXTERNAL,
        BOTH;

    }
}

