/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import oracle.javatools.db.DBObjectFilter;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBObjectCriteria<T extends SystemObject>
implements DBObjectFilter<T> {
    public static final char LIKE_WILDCARD_CHAR = '%';
    public static final String LIKE_WILDCARD = String.valueOf('%');
    private Collection<DBObjectFilter<T>> m_filters;
    private final Class<? extends T> m_clz;
    private String m_nameLike;
    private String m_schemaName;
    private final Collection<String> m_types = new HashSet<String>();
    private boolean m_userOnly;
    private boolean m_skipTimestamps;

    private DBObjectCriteria() {
        this.m_clz = null;
    }

    public DBObjectCriteria(T obj) {
        this(obj.getClass(), obj.getType());
        this.setNameLike(obj.getName());
        if (obj instanceof SchemaObject) {
            this.setSchema(((SchemaObject)obj).getSchema());
        }
    }

    public DBObjectCriteria(Class<? extends T> clz, String ... types) {
        if (clz == null) {
            throw new IllegalArgumentException("Criteria class cannot be null");
        }
        this.m_clz = clz;
        if (ModelUtil.hasNonNullElement((Object[])types)) {
            Collection<String> allowedTypes = Metadata.getInstance().getAllTypes(this.m_clz);
            for (String type : types) {
                if (!allowedTypes.contains(type)) {
                    throw new IllegalArgumentException(type + " is not a valid type for class " + this.m_clz.getSimpleName());
                }
                this.m_types.add(type);
            }
        } else {
            String type = Metadata.getType(this.m_clz);
            if (type == null) {
                this.m_types.addAll(Metadata.getInstance().getAllTypes(this.m_clz));
            } else {
                this.m_types.add(type);
            }
        }
    }

    final Class<? extends T> getObjectClass() {
        return this.m_clz;
    }

    public final String getNameLike() {
        return ModelUtil.hasLength((String)this.m_nameLike) ? this.m_nameLike : LIKE_WILDCARD;
    }

    public final void setNameLike(String nameLike) {
        this.m_nameLike = nameLike;
    }

    public final boolean isNameWild() {
        return this.m_nameLike == null || this.m_nameLike.contains(LIKE_WILDCARD);
    }

    public final boolean isAllowedName(String name) {
        boolean match = false;
        if (ModelUtil.hasLength((String)this.m_nameLike)) {
            if (ModelUtil.hasLength((String)name)) {
                StringBuilder buff = new StringBuilder();
                int lastChar = 32;
                for (int i = 0; i < this.m_nameLike.length(); ++i) {
                    char c = this.m_nameLike.charAt(i);
                    if (c == '%' && lastChar != 92) {
                        buff.append(".*");
                    } else {
                        buff.append(Pattern.quote(String.valueOf(c)));
                    }
                    lastChar = c;
                }
                try {
                    match = name.matches(buff.toString());
                }
                catch (PatternSyntaxException pse) {
                    match = false;
                }
            }
        } else {
            match = true;
        }
        return match;
    }

    public final Collection<String> getTypes() {
        return Collections.unmodifiableCollection(this.m_types);
    }

    public final String[] getTypeArray() {
        return this.m_types.toArray(new String[this.m_types.size()]);
    }

    public final boolean isAllowedType(String type) {
        return this.getTypes().isEmpty() || this.getTypes().contains(type);
    }

    public final void setTypes(Collection<String> types) {
        this.m_types.clear();
        for (String type : types) {
            if (this.m_clz == null || Metadata.getInstance().getAllTypes(this.m_clz).contains(type)) {
                this.m_types.add(type);
                continue;
            }
            throw new IllegalArgumentException(type + " is not compatible with a criteria of class " + this.m_clz.getSimpleName());
        }
    }

    public final void setTypes(String ... types) {
        if (types != null) {
            this.setTypes(Arrays.asList(types));
        }
    }

    public final String getSchemaName() {
        return this.m_schemaName;
    }

    public final void setSchemaName(String name) {
        this.m_schemaName = name;
    }

    public final void setSchema(Schema schema) {
        if (schema != null) {
            this.m_schemaName = schema.getName();
        }
    }

    public final boolean isAllowedSchema(Schema schema) {
        return this.isAllowedSchemaName(schema == null ? null : schema.getName());
    }

    public final boolean isAllowedSchemaName(String schemaName) {
        return ModelUtil.areEqual((Object)schemaName, (Object)this.m_schemaName);
    }

    public final boolean isUserOnly() {
        return this.m_userOnly;
    }

    public final void setUserOnly(boolean userOnly) {
        this.m_userOnly = userOnly;
    }

    @Override
    public boolean accept(T obj) {
        boolean retval = false;
        if (obj != null) {
            boolean bl = retval = this.isAllowedName(obj.getName()) && this.isAllowedType(obj.getType());
            if (retval && obj instanceof SchemaObject) {
                retval = this.isAllowedSchema(((SchemaObject)obj).getSchema());
            }
        }
        if (retval && this.m_filters != null) {
            for (DBObjectFilter<T> filter : this.m_filters) {
                retval = retval && filter.accept(obj);
            }
        }
        return retval;
    }

    public final void addFilter(DBObjectFilter<T> filter) {
        if (filter != null) {
            if (this.m_filters == null) {
                this.m_filters = new ArrayList<DBObjectFilter<T>>();
            }
            this.m_filters.add(filter);
        }
    }

    public final boolean hasExtraCriteria() {
        return this.m_filters != null;
    }

    void setSkipTimestampCheck(boolean skip) {
        this.m_skipTimestamps = skip;
    }

    boolean getSkipTimestampCheck() {
        return this.m_skipTimestamps;
    }

    public static DBObjectCriteria<SystemObject> createCriteria() {
        return new DBObjectCriteria<SystemObject>();
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String type, Schema schema, String nameLike) {
        return DBObjectCriteria.createCriteria(type, schema == null ? null : schema.getName(), nameLike);
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String type, String schemaName, String nameLike) {
        DBObjectCriteria<SystemObject> c = DBObjectCriteria.createCriteria();
        if (type != null) {
            c.setTypes(type);
        }
        c.setNameLike(nameLike);
        c.setSchemaName(schemaName);
        return c;
    }

    public static DBObjectCriteria<SystemObject> createCriteria(String[] types, Schema schema, String nameLike) {
        DBObjectCriteria<SystemObject> c = DBObjectCriteria.createCriteria();
        if (types != null) {
            c.setTypes(types);
        }
        c.setNameLike(nameLike);
        c.setSchema(schema);
        return c;
    }
}

