/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Relation;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.Transient;

public class Column
extends AbstractChildDBObject {
    public static final String TYPE = "COLUMN";
    @PropertyKey(value=DBObjectID.class, childOf={Column.class})
    public static final String AUTO_GENERATED_SEQUENCE = "AUTO_GENERATED_SEQUENCE";
    @PropertyKey(value=DBObjectID.class, childOf={Column.class})
    public static final String AUTO_GENERATED_SEQUENCE_TRIGGER = "AUTO_GENERATED_SEQUENCE_TRIGGER";

    public Column() {
        this((String)null, (DataTypeUsage)null);
    }

    public Column(String name) {
        this(name, (DataTypeUsage)null);
    }

    public Column(String name, DataTypeUsage usage) {
        super(name);
        this.setDataTypeUsage(usage);
        this.setNotNull(false);
    }

    public void setDefault(Object defaultValue) {
        this.setProperty("default", defaultValue);
    }

    public Object getDefault() {
        return this.getProperty("default");
    }

    public boolean isNotNull() {
        return (Boolean)this.getProperty("notNull", false);
    }

    public void setNotNull(boolean notNull) {
        this.setProperty("notNull", notNull);
    }

    public void setDataTypeUsage(DataTypeUsage dataTypeUsage) {
        this.setProperty("dataTypeUsage", dataTypeUsage);
    }

    public DataTypeUsage getDataTypeUsage() {
        return (DataTypeUsage)this.getProperty("dataTypeUsage");
    }

    public String getType() {
        return TYPE;
    }

    @Transient
    public Relation getRelation() {
        return (Relation)this.getParent();
    }

    @Transient
    public void setRelation(Relation relation) {
        this.setParent(relation);
    }

    @Transient
    @Deprecated
    public Long getPrecision() {
        DataTypeUsage dtu = this.getDataTypeUsage();
        if (dtu == null) {
            return null;
        }
        Long precision = DataTypeHelper.getLongAttributeValue(dtu, "precision");
        Long size = DataTypeHelper.getLongAttributeValue(dtu, "size");
        return precision == null ? size : precision;
    }

    @Transient
    @Deprecated
    public void setPrecision(Long precision) {
        DataTypeUsage dtu = this.getDataTypeUsage();
        if (dtu != null) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(dtu);
            }
            catch (DBException ex) {
                // empty catch block
            }
            if (dataType != null) {
                if (dataType.hasDataTypeAttribute("precision")) {
                    dtu.putAttributeValue("precision", precision);
                }
                if (dataType.hasDataTypeAttribute("size")) {
                    dtu.putAttributeValue("size", precision);
                }
            }
        }
    }

    @Transient
    @Deprecated
    public Long getScale() {
        DataTypeUsage dtu = this.getDataTypeUsage();
        if (dtu == null) {
            return null;
        }
        return DataTypeHelper.getLongAttributeValue(dtu, "scale");
    }

    @Deprecated
    public void setScale(Long scale) {
        DataTypeUsage dtu = this.getDataTypeUsage();
        if (dtu != null) {
            DataType dataType = null;
            try {
                dataType = DataTypeHelper.getDataType(dtu);
            }
            catch (DBException ex) {
                // empty catch block
            }
            if (dataType != null && dataType.hasDataTypeAttribute("scale")) {
                dtu.putAttributeValue("scale", scale);
            }
        }
    }
}

