/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectListener;

public abstract class AbstractSystemObject
extends AbstractBuildableObject {
    protected transient List<DBObjectListener> m_listeners;

    public AbstractSystemObject(String string, DBObjectID dbObjectID) {
        super(string, dbObjectID);
    }

    public AbstractSystemObject() {
    }

    public DBObject getParent() {
        return null;
    }

    public final void fireObjectUpdated(DBObjectChange change) {
        change.log();
        if (this.m_listeners != null) {
            for (DBObjectListener list : new ArrayList<DBObjectListener>(this.m_listeners)) {
                if (list == null) continue;
                try {
                    list.objectUpdated(change);
                }
                catch (Exception e) {
                    DBLog.getLogger().log(Level.WARNING, MessageFormat.format("listener {0} threw exception:", list.getClass()), e);
                }
            }
        }
    }

    public final void removeObjectListener(DBObjectListener list) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(list);
        }
    }

    public final void addObjectListener(DBObjectListener list) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList<DBObjectListener>();
        }
        this.m_listeners.add(list);
    }
}

