/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.AbstractDBObjectProvider;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SchemaObjectManager;
import oracle.javatools.db.SystemObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDBObjectBuilder<T extends AbstractBuildableObject>
implements DBObjectBuilder<T> {
    static final Collection<String> s_specialProps = Arrays.asList("Timestamp", "name", "ID", "properties", "schema", "type");
    private Boolean m_supportsTimestamp;
    private String m_type;
    private AbstractDBObjectProvider m_pro;
    private Map<String, Method> m_propMap;

    protected AbstractDBObjectBuilder(AbstractDBObjectProvider pro, String type) {
        this.m_type = type;
        this.m_pro = pro;
    }

    protected final String getObjectType() {
        return this.m_type;
    }

    protected final AbstractDBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected final Schema getSchema(String name) throws DBException {
        return this.m_pro.findSchema(name);
    }

    @Override
    public abstract T createObject(String var1, Schema var2, DBObjectID var3);

    private String getTimestampKey(T obj) {
        return this.getClass().getSimpleName() + ":" + obj.getType() + ":" + ((AbstractDBObject)obj).getName();
    }

    private void checkTimestamp(T obj) {
        AbstractBuildableObject exists = null;
        try {
            DBObjectID id = ((AbstractDBObject)obj).getID();
            exists = id == null ? (AbstractBuildableObject)DBUtil.getProviderDefinition(obj, (DBObjectProvider)this.getProvider()) : (AbstractBuildableObject)id.resolveID();
        }
        catch (DBException dbe) {
            DBLog.getLogger(this).log(Level.WARNING, "Couldn't lookup existing object: " + dbe.getMessage());
        }
        if (exists == null) {
            DBLog.getLogger(this).log(Level.WARNING, "Building {0} {1} but it doesn't exist any more.", new String[]{obj.getType(), ((AbstractDBObject)obj).getName()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void buildObject(T object) throws DBException {
        try {
            this.m_pro.suspendTimestampQueries(this.getTimestampKey(object));
            this.checkTimestamp(object);
            ((AbstractBuildableObject)object).getPropertySupport().setBuildingAll();
            this.updateTimestamp((DBObject)object);
            this.fillInObject(object);
            ((AbstractBuildableObject)object).getPropertySupport().markAsBuilt();
            this.registerObject(object);
        }
        finally {
            this.m_pro.resumeTimestampQueries(this.getTimestampKey(object));
        }
    }

    protected void fillInObject(T object) throws DBException {
        if (this.canBuildComponents()) {
            for (String key : this.getPropertyMethodMap().keySet()) {
                this.ensureComponent(object, key);
            }
        }
    }

    protected void registerObject(T object) throws DBException {
        this.updateTimestamp((DBObject)object);
        if (object instanceof SchemaObject) {
            SchemaObjectManager m;
            SchemaObjectManager schemaObjectManager = m = this.m_pro == null ? null : this.m_pro.getCascadeManager();
            if (m != null) {
                m.registerObject((SystemObject)((SchemaObject)object), true);
            }
        }
    }

    protected final void updateTimestamp(DBObject object) throws DBException {
        this.updateTimestamp(object, false);
    }

    protected final void updateTimestamp(DBObject object, boolean force) throws DBException {
        if (this.m_supportsTimestamp == null) {
            this.m_supportsTimestamp = this.getProvider().supportsTimestamps(this.getObjectType());
        }
        if (this.m_supportsTimestamp.booleanValue() && object instanceof SystemObject && (force || object.getProperty("Timestamp") == null)) {
            object.setProperty("Timestamp", this.getProvider().getExternalTimestamp((SystemObject)object));
        }
    }

    protected final boolean needsBuilding(T obj, String key) {
        return this.needsBuilding(obj, key, false);
    }

    public final boolean needsBuilding(T obj, String key, boolean checkBuilder) {
        if (checkBuilder && !((AbstractBuildableObject)obj).needsInitialization()) {
            return false;
        }
        return !((AbstractBuildableObject)obj).isBuilt(key);
    }

    protected final void markAsBuilt(T obj) {
        ((AbstractBuildableObject)obj).getPropertySupport().markAsBuilt();
    }

    protected final void ensureComponent(T obj, String key) throws DBException {
        if (this.needsBuilding(obj, key)) {
            this.buildObjectComponent(obj, key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void buildObjectComponent(T object, String key) throws DBException {
        if (this.isBuildableProperty(key)) {
            if (this.canBuildComponents()) {
                try {
                    this.m_pro.suspendTimestampQueries(this.getTimestampKey(object));
                    this.fillInObjectComponent(object, key);
                    this.registerObject(object);
                }
                finally {
                    this.m_pro.resumeTimestampQueries(this.getTimestampKey(object));
                }
            } else {
                this.buildObject(object);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fillInObjectComponent(T object, String key) throws DBException {
        if (this.isBuildableProperty(key)) {
            this.checkTimestamp(object);
            String[] props = this.getBuiltProperties(key);
            try {
                ((AbstractBuildableObject)object).getPropertySupport().startBuilding(props);
                String[] depKeys = this.getPropertyDependencies(key);
                if (depKeys != null) {
                    for (String depKey : depKeys) {
                        this.ensureComponent(object, depKey);
                    }
                }
                this.fillInObjectComponentImpl(object, key);
                ((AbstractBuildableObject)object).getPropertySupport().setBuilt(props);
            }
            finally {
                ((AbstractBuildableObject)object).getPropertySupport().finishBuilding(props);
            }
        }
    }

    void fillInObjectComponentImpl(T object, String key) throws DBException {
        Method m = this.getPropertyMethodMap().get(key);
        this.invokeBuilderMethod(m, object, key);
    }

    private void invokeBuilderMethod(Method m, T object, String key) throws DBException {
        try {
            m.invoke((Object)this, object);
        }
        catch (Exception ex) {
            if (ex instanceof DBException) {
                throw (DBException)ex;
            }
            if (ex.getCause() instanceof DBException) {
                throw (DBException)ex.getCause();
            }
            throw new DBException((DBObject)object, "Build of property " + key + " failed: " + ex.getMessage(), ex);
        }
    }

    protected boolean canBuildComponents() {
        return false;
    }

    protected boolean isBuildableProperty(String key) {
        boolean retval;
        boolean bl = retval = !s_specialProps.contains(key);
        if (retval && this.canBuildComponents()) {
            retval = this.getPropertyMethodMap().containsKey(key);
        }
        return retval;
    }

    private synchronized Map<String, Method> getPropertyMethodMap() {
        if (this.m_propMap == null) {
            this.m_propMap = new TreeMap<String, Method>();
            Class<?> c = this.getClass();
            for (Method m : c.getMethods()) {
                PropertyBuilder v = m.getAnnotation(PropertyBuilder.class);
                if (v == null) continue;
                for (String p : v.value()) {
                    this.m_propMap.put(p, m);
                }
            }
        }
        return this.m_propMap;
    }

    String[] getBuiltProperties(String property) {
        String[] stringArray;
        PropertyBuilder pb = this.getAnnotation(property);
        if (pb == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = property;
        } else {
            stringArray = pb.value();
        }
        return stringArray;
    }

    String[] getPropertyDependencies(String property) {
        PropertyBuilder pb = this.getAnnotation(property);
        return pb == null ? null : pb.depends();
    }

    private PropertyBuilder getAnnotation(String key) {
        PropertyBuilder pb = null;
        Method m = this.getPropertyMethodMap().get(key);
        if (m != null) {
            pb = m.getAnnotation(PropertyBuilder.class);
        }
        return pb;
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface PropertyBuilder {
        public String[] value();

        public String[] depends() default {};

        public boolean derived() default false;
    }
}

