/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db;

import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.property.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractChildDBObject
extends AbstractDBObject
implements ChildDBObject {
    private transient DBObject m_parent;

    protected AbstractChildDBObject() {
    }

    protected AbstractChildDBObject(String name) {
        super(name);
    }

    protected AbstractChildDBObject(String name, DBObject parent) {
        super(name);
        this.m_parent = parent;
    }

    @Override
    @Transient
    public void setParent(DBObject parent) {
        this.m_parent = parent;
    }

    @Override
    @Transient
    public final DBObject getParent() {
        return this.m_parent;
    }

    public final <T extends DBObject> T findParent(Class<T> parentClass) {
        for (DBObject parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parentClass.isAssignableFrom(parent.getClass())) continue;
            return (T)parent;
        }
        return null;
    }

    @Override
    protected void copyToImpl(AbstractDBObject copy, DBObject copyParent, IDPolicy idPolicy) {
        ((AbstractChildDBObject)copy).setParent(copyParent);
        super.copyToImpl(copy, copyParent, idPolicy);
    }

    @Override
    public Object getProperty(String key) {
        if ("parent".equals(key)) {
            return this.getParent();
        }
        return super.getProperty(key);
    }

    @Override
    public void setProperty(String key, Object value) {
        if ("parent".equals(key)) {
            this.setParent((DBObject)value);
        } else {
            super.setProperty(key, value);
        }
    }
}

