/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMIException
extends Exception {
    public static final int WARNING = 0;
    public static final int ERROR = 1;
    public static final int FATAL_ERROR = 2;
    private final int m_type;

    public XMIException(String message, Throwable throwable, int type) {
        super(message == null && throwable != null ? throwable.toString() : message, throwable);
        if (type < 0 || type > 2) {
            throw new IllegalArgumentException("Invalid exception type");
        }
        this.m_type = type;
    }

    public boolean isWarning() {
        return this.m_type == 0;
    }

    public boolean isError() {
        return this.m_type == 1;
    }

    public boolean isFatalError() {
        return this.m_type == 2;
    }

    public void report(Locator locator, ErrorHandler errorHandler) throws SAXException {
        this.report(new SAXParseException(this.getMessage(), locator, this), errorHandler);
    }

    public void report(String publicId, String systemId, int lineNumber, int columnNumber, ErrorHandler errorHandler) throws SAXException {
        this.report(new SAXParseException(this.getMessage(), publicId, systemId, lineNumber, columnNumber, this), errorHandler);
    }

    private void report(SAXParseException e, ErrorHandler errorHandler) throws SAXException {
        switch (this.m_type) {
            case 0: {
                errorHandler.warning(e);
                break;
            }
            case 1: {
                errorHandler.error(e);
                break;
            }
            case 2: {
                errorHandler.fatalError(e);
            }
        }
    }
}

