/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.XMIDocument;

public class XMIDocumentSet {
    private final ArrayList<XMIDocument> m_documentList = new ArrayList();
    private final HashMap<String, XMIDocument> m_documents = new HashMap();

    public void resolveReferences() {
        for (int i = 0; i < this.getDocumentCount(); ++i) {
            this.getDocument(i).resolveReferences();
        }
    }

    public int getDocumentCount() {
        return this.m_documentList.size();
    }

    public XMIDocument getDocument(int index) {
        return this.m_documentList.get(index);
    }

    public void addDocument(XMIDocument document) {
        ContractUtils.checkNull(document, "Document must not be null");
        this.m_documentList.add(document);
        document.setDocumentSet(this);
    }

    void addMapping(String uri, XMIDocument document) {
        ContractUtils.checkNull(uri, "URI must not be null");
        ContractUtils.checkNull(document, "Document must not be null");
        XMIDocument oldMapping = this.m_documents.put(uri, document);
        if (oldMapping != null && oldMapping != document) {
            throw new IllegalStateException(uri + " already mapped");
        }
    }

    public XMIDocument getDocument(String uri) {
        return this.m_documents.get(uri);
    }

    public Object getInstance(String uri) {
        return XMIDocument.getRealInstance(this.getInstanceInternal(uri));
    }

    Object getInstanceInternal(String uri) {
        XMIDocument document;
        int index = uri.indexOf(35);
        if (index == -1) {
            for (int i = this.m_documentList.size() - 1; i >= 0; --i) {
                Object o = this.m_documentList.get(i).getInstanceByUUIDInternal(uri);
                if (o == XMIDocument.NOT_FOUND) continue;
                return o;
            }
        } else if (index < uri.length() && (document = this.getDocument(uri.substring(0, index))) != null) {
            return document.getInstanceByIdInternal(uri.substring(index + 1));
        }
        return XMIDocument.NOT_FOUND;
    }
}

