/*
 * Decompiled with CFR 0.152.
 */
package oracle.mof.xmi;

import java.util.ArrayList;
import java.util.HashMap;
import oracle.mof.xmi.ContractUtils;
import oracle.mof.xmi.ResourcesSingleton;
import oracle.mof.xmi.XMIDocumentSet;
import oracle.mof.xmi.XMIException;
import oracle.mof.xmi.XMIProperty;
import oracle.mof.xmi.XMIReader;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMIDocument {
    private static final Object IGNORED = new Object();
    static final Object NOT_FOUND = new Object();
    private ErrorHandler m_errorHandler;
    private boolean m_logUnsupported;
    private String m_publicId;
    private String m_uri;
    private ArrayList<String> m_uris = new ArrayList();
    private XMIDocumentSet m_set;
    private String m_xmiVersion;
    private HashMap<String, Object> m_instancesById = new HashMap();
    private HashMap<String, Object> m_instancesByUUID = new HashMap();
    private ArrayList<XMIReference> m_references = new ArrayList();
    private ArrayList m_rootInstances = new ArrayList();
    private String m_name;
    private String m_version;

    XMIDocument(XMIReader reader, InputSource inputSource) {
        ContractUtils.checkNull(reader, "Reader must not be null");
        ContractUtils.checkNull(inputSource, "Input source must not be null");
        this.m_errorHandler = reader.getErrorHandler();
        this.m_logUnsupported = reader.logUnsupported();
        this.m_publicId = inputSource.getPublicId();
        this.m_uri = inputSource.getSystemId();
        if (this.m_uri != null) {
            this.m_uris.add(this.m_uri);
        }
    }

    void setXMIVersion(String xmiVersion) {
        ContractUtils.checkNull(xmiVersion, "XMI version must not be null");
        this.m_xmiVersion = xmiVersion;
    }

    public String getXMIVersion() {
        return this.m_xmiVersion;
    }

    void setDocumentSet(XMIDocumentSet set) {
        ContractUtils.checkNull(set, "Set must not be null");
        if (this.m_set != null) {
            throw new IllegalStateException("Already member of a set");
        }
        for (int i = this.m_uris.size() - 1; i >= 0; --i) {
            set.addMapping(this.m_uris.get(i), this);
        }
        this.m_set = set;
    }

    public void addURI(String uri) {
        ContractUtils.checkNull(uri, "URI must not be null");
        if (this.m_set != null) {
            this.m_set.addMapping(uri, this);
        } else {
            this.m_uris.add(uri);
        }
    }

    void setName(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    void setVersion(String version) {
        this.m_version = version;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void resolveReferences() {
        int size = this.m_references.size();
        for (int i = 0; i < size; ++i) {
            XMIReference ref = this.m_references.get(i);
            ref.resolve();
        }
    }

    void addIdref(Locator locator, Object instance, XMIProperty property, String idref) {
        this.m_references.add(new XMIIdref(locator, instance, property, idref));
    }

    void addHref(Locator locator, Object instance, XMIProperty property, String href) {
        this.m_references.add(new XMIHref(locator, instance, property, href));
    }

    void addIdrefProxy(Locator locator, String xmiId, String idref) throws XMIException {
        this.addInstanceById(xmiId, new XMIIdref(locator, null, null, idref));
    }

    void addHrefProxy(Locator locator, String xmiId, String href) throws XMIException {
        this.addInstanceById(xmiId, new XMIHref(locator, null, null, href));
    }

    void addIgnoredInstanceById(Locator locator, String id) {
        this.m_instancesById.put(id, IGNORED);
    }

    void addIgnoredInstanceByUUID(Locator locator, String uuid) {
        this.m_instancesByUUID.put(uuid, IGNORED);
    }

    void addInstanceById(String id, Object instance) throws XMIException {
        this.addInstanceInternal(id, instance, this.m_instancesById);
    }

    void addInstanceByUUID(String uuid, Object instance) throws XMIException {
        this.addInstanceInternal(uuid, instance, this.m_instancesByUUID);
    }

    private void addInstanceInternal(String identifier, Object instance, HashMap<String, Object> instances) throws XMIException {
        if (instances.put(identifier, instance) != null) {
            throw new XMIException(ResourcesSingleton.getPicker().getString("DuplicateId.text", (Object)identifier), null, 1);
        }
    }

    public Object getInstanceById(String id) {
        return XMIDocument.getRealInstance(this.getInstanceByIdInternal(id));
    }

    Object getInstanceByIdInternal(String id) {
        ContractUtils.checkNull(id, "Missing id");
        Object instance = this.m_instancesById.get(id);
        if (instance instanceof XMIIdref) {
            instance = ((XMIIdref)instance).resolve();
            this.m_instancesById.put(id, instance);
        }
        return instance == null ? NOT_FOUND : instance;
    }

    public Object getInstanceByUUID(String uuid) {
        return XMIDocument.getRealInstance(this.getInstanceByUUIDInternal(uuid));
    }

    Object getInstanceByUUIDInternal(String uuid) {
        ContractUtils.checkNull(uuid, "Missing uuid");
        Object instance = this.m_instancesByUUID.get(uuid);
        return instance == null ? NOT_FOUND : instance;
    }

    public Object[] getRootInstances() {
        return this.m_rootInstances.toArray();
    }

    void addInstance(Locator locator, Object owner, XMIProperty property, Object composite) {
        if (owner == null) {
            this.m_rootInstances.add(composite);
        } else {
            this.m_references.add(new XMICompositeReference(locator, owner, property, composite));
        }
    }

    static Object getRealInstance(Object instance) {
        return instance == NOT_FOUND || instance == IGNORED ? null : instance;
    }

    private class XMIHref
    extends XMIIdref {
        public XMIHref(Locator locator, Object instance, XMIProperty property, String ref) {
            super(locator, instance, property, ref);
        }

        @Override
        protected Object resolveImpl() {
            if (XMIDocument.this.m_set != null) {
                if ('#' == this.m_ref.charAt(0)) {
                    return XMIDocument.this.getInstanceByIdInternal(this.m_ref.substring(1));
                }
                Object instance = XMIDocument.this.m_set.getInstanceInternal(this.m_ref);
                return instance == null ? NOT_FOUND : instance;
            }
            int index = this.m_ref.indexOf(35);
            if (index == -1) {
                return XMIDocument.this.getInstanceByUUIDInternal(this.m_ref);
            }
            if (index == 0 || XMIDocument.this.m_uris.contains(this.m_ref.substring(0, index))) {
                return XMIDocument.this.getInstanceByIdInternal(this.m_ref.substring(index + 1));
            }
            return NOT_FOUND;
        }
    }

    private class XMIIdref
    extends XMIReference {
        protected String m_ref;
        private boolean m_resolving;

        public XMIIdref(Locator locator, Object instance, XMIProperty property, String ref) {
            super(locator, instance, property);
            this.m_ref = ref;
        }

        @Override
        public final Object resolve() {
            if (this.m_resolving) {
                this.report("ReferenceCycle.text", 1);
                return NOT_FOUND;
            }
            this.m_resolving = true;
            Object refInstance = this.resolveImpl();
            this.m_resolving = false;
            if (this.m_property != null) {
                if (NOT_FOUND == refInstance) {
                    this.report("DeferenceMissingElement.text", 1);
                } else if (IGNORED == refInstance) {
                    if (XMIDocument.this.m_logUnsupported) {
                        this.report("DeferenceIgnoredElement.text", 0);
                    }
                } else {
                    this.addValue(refInstance);
                }
            }
            return refInstance;
        }

        protected Object resolveImpl() {
            return XMIDocument.this.getInstanceByIdInternal(this.m_ref);
        }

        protected void report(String key, int type) {
            this.report(new XMIException(ResourcesSingleton.getPicker().getString(key, (Object)this.m_ref), null, type));
        }
    }

    private final class XMICompositeReference
    extends XMIReference {
        private Object m_composite;

        public XMICompositeReference(Locator locator, Object instance, XMIProperty property, Object composite) {
            super(locator, instance, property);
            this.m_composite = composite;
        }

        @Override
        public Object resolve() {
            this.addValue(this.m_composite);
            return this.m_composite;
        }
    }

    private abstract class XMIReference {
        protected int m_lineNumber;
        protected int m_columnNumber;
        protected Object m_instance;
        protected XMIProperty m_property;

        public XMIReference(Locator locator, Object instance, XMIProperty property) {
            this.m_lineNumber = locator.getLineNumber();
            this.m_columnNumber = locator.getColumnNumber();
            this.m_instance = instance;
            this.m_property = property;
        }

        public abstract Object resolve();

        protected void addValue(Object refInstance) {
            try {
                this.m_property.addValue(this.m_instance, refInstance);
            }
            catch (XMIException e) {
                this.report(e);
            }
            catch (Exception e) {
                this.report(new XMIException(e.getMessage(), e, 1));
            }
        }

        protected void report(XMIException e) {
            try {
                e.report(XMIDocument.this.m_publicId, XMIDocument.this.m_uri, this.m_lineNumber, this.m_columnNumber, XMIDocument.this.m_errorHandler);
            }
            catch (SAXException saxe) {
                this.logReportingFellOver(saxe);
            }
        }

        private void logReportingFellOver(SAXException e) {
            try {
                XMIDocument.this.m_errorHandler.fatalError(this.createException(ResourcesSingleton.getPicker().getString("ErrorReportingFailed.text"), e));
            }
            catch (SAXException e2) {
                e.printStackTrace();
                e2.printStackTrace();
            }
        }

        private SAXParseException createException(String message, Exception e) {
            return new SAXParseException(message, XMIDocument.this.m_publicId, XMIDocument.this.m_uri, this.m_lineNumber, this.m_columnNumber, e);
        }
    }
}

