/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.externaltools;

import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.Preferences;
import oracle.ide.externaltools.ExternalTool;
import oracle.ide.externaltools.ExternalToolManager;
import oracle.ide.externaltools.ExternalToolType;
import oracle.ide.externaltools.macro.MacroRegistry;
import oracle.ide.log.LogManager;
import oracle.ide.net.IdeURLFileSystemHelper;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ideimpl.externaltools.ExternalToolList;
import oracle.ideimpl.externaltools.MenuManager;
import oracle.ideimpl.externaltools.ToolPersistence;
import oracle.ideimpl.externaltools.macro.MacroRegistryImpl;
import oracle.ideimpl.externaltools.program.ExternalProgramType;
import oracle.ideimpl.externaltools.ui.ExternalToolsWizard;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.ExceptionDialog;

public class ExternalToolAddin
extends ExternalToolManager
implements Addin {
    private ArrayList m_toolTypes;
    private MacroRegistry m_macroRegistry;
    private MenuManager m_menuManager;
    private boolean _oldFileCouldNotBeMoved = false;

    private MacroRegistry createMacroRegistry() {
        return new MacroRegistryImpl();
    }

    private void registerDefaultTypes() {
        this.registerType(new ExternalProgramType());
    }

    private ExternalToolList getToolList() {
        ExternalToolList list = ExternalToolList.getInstance((PropertyStorage)Preferences.getPreferences());
        this.checkForOldTools(list);
        return list;
    }

    private void checkForOldTools(ExternalToolList list) {
        if (this._oldFileCouldNotBeMoved) {
            return;
        }
        ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
        URL url = er.getSystemDirectory(AddinManager.getAddinManager().getExtensionIDForAddin(this.getClass()));
        File f = new File(url.getPath() + "tools.xml");
        if (f.exists()) {
            File backup = new File(url.getPath() + "tools.xml" + ".bak");
            if (!f.renameTo(backup)) {
                this.notifyLoadFailure(f);
                this._oldFileCouldNotBeMoved = true;
                return;
            }
            f = backup;
            try {
                ArrayList tools = ToolPersistence.loadDefinitions1013(f);
                for (ExternalTool tool : tools) {
                    if (tool == null) continue;
                    list.add(tool);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                this.notifyLoadFailure(f);
            }
        }
    }

    private void notifyLoadFailure(File f) {
        LogManager.getLogManager().getMsgPage().log((Object)("External Tools: Failed to migrate old tools from " + f));
    }

    @Override
    public void addExternalTool(ExternalTool tool) {
        this.getToolList().add(tool);
        this.m_menuManager.addItem(tool);
    }

    void refreshMenus() {
        this.m_menuManager.uninstallItems();
        this.m_menuManager.installItems();
    }

    @Override
    public Collection<ExternalTool> tools() {
        return Collections.unmodifiableCollection(this.getToolList().tools());
    }

    @Override
    public Collection<ExternalTool> toolsOfType(ExternalToolType type) {
        ArrayList<ExternalTool> l = new ArrayList<ExternalTool>();
        for (ExternalTool tool : this.tools()) {
            if (tool.getType() != type.getClass()) continue;
            l.add(tool);
        }
        return Collections.unmodifiableCollection(l);
    }

    @Override
    public MacroRegistry getMacroRegistry() {
        if (this.m_macroRegistry == null) {
            this.m_macroRegistry = this.createMacroRegistry();
        }
        return this.m_macroRegistry;
    }

    @Override
    public int getRegisteredTypeCount() {
        if (this.m_toolTypes == null) {
            this.getRegisteredTypes();
        }
        return this.m_toolTypes.size();
    }

    public Iterator getRegisteredTypes() {
        if (this.m_toolTypes == null) {
            this.m_toolTypes = new ArrayList();
            this.registerDefaultTypes();
        }
        return this.m_toolTypes.iterator();
    }

    @Override
    public ExternalTool invokeCreateWizard(Component parent, ExternalToolType type) {
        ExternalTool t = new ExternalToolsWizard().runCreateWizard(this.getToolList().tools(), this, parent, type);
        if (t != null) {
            this.addExternalTool(t);
        }
        return t;
    }

    @Override
    public boolean invokeEditDialog(Component parent, ExternalTool tool) {
        return false;
    }

    @Override
    public void removeExternalTool(ExternalTool tool) {
        this.m_menuManager.removeItem(tool);
        this.getToolList().remove(tool);
    }

    @Override
    public void unregisterType(ExternalToolType type) {
        if (this.m_toolTypes == null) {
            this.getRegisteredTypes();
        }
        this.m_toolTypes.remove(type);
    }

    @Override
    public void registerType(ExternalToolType type) {
        if (this.m_toolTypes == null) {
            this.getRegisteredTypes();
        }
        this.m_toolTypes.add(type);
    }

    private void postInit() {
        this.m_menuManager.addToolsMenuItem();
        this.m_menuManager.installItems();
    }

    MenuManager getMenuManager() {
        return this.m_menuManager;
    }

    public void initialize() {
        try {
            InitialContext ic = new InitialContext();
            try {
                ic.lookup("ide");
            }
            catch (NamingException ne) {
                ic.createSubcontext("ide");
            }
            ic.bind("ide/external-tool-manager", (Object)this);
            try {
                ic.lookup("jdeveloper");
            }
            catch (NamingException ne) {
                ic.createSubcontext("jdeveloper");
            }
            ic.bind("jdeveloper/external-tool-manager", (Object)this);
        }
        catch (NamingException ne) {
            ExceptionDialog.showExceptionDialog((Component)null, (Throwable)ne);
        }
        URLFileSystem.registerHelper((String)"ide.fileicon", (URLFileSystemHelper)new IdeURLFileSystemHelper());
        this.m_menuManager = new MenuManager(this);
        Ide.addIdeListener((IdeListener)new IdeListener(){

            public void addinsLoaded(IdeEvent e) {
            }

            public void mainWindowClosing(IdeEvent e) {
            }

            public void mainWindowOpened(IdeEvent e) {
                try {
                    ExternalToolAddin.this.postInit();
                    Ide.removeIdeListener((IdeListener)this);
                }
                catch (RuntimeException re) {
                    ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)re);
                }
            }
        });
    }
}

