/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector.editor;

import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import oracle.bali.inspector.PropertyEditorFactory2;
import oracle.bali.inspector.PropertyEditorFactory2ValueApplier;
import oracle.bali.inspector.editor.EditorFactoryUtils;
import oracle.bali.inspector.editor.PropertyModelValueApplier;
import oracle.bali.inspector.editor.PropertyValueApplier;
import oracle.bali.inspector.editor.PropertyValueApplierUtil;
import oracle.bali.inspector.editor.TextFieldEditor;

public class TextFieldEditorBehavior
extends KeyAdapter
implements FocusListener,
DocumentListener {
    private static final String KEY = TextFieldEditorBehavior.class.getName();
    private boolean keyAlreadyPressed;
    JTextComponent editor;
    PropertyEditorFactory2 propertyEditor;

    public TextFieldEditorBehavior(JTextComponent editor, PropertyEditorFactory2 propertyEditor) {
        this.editor = editor;
        this.propertyEditor = propertyEditor;
        this.setDirty(false);
    }

    public void focusLost(FocusEvent e) {
        if (e.isTemporary()) {
            return;
        }
        this.applyValueFromEditor();
    }

    public void keyPressed(KeyEvent e) {
        int keycode = e.getKeyCode();
        if (keycode == 27) {
            String oldText = this.propertyEditor.getAsText();
            this.editor.setText(oldText);
            this.setDirty(false);
            return;
        }
        if (keycode == 10) {
            this.applyValueFromEditor();
            return;
        }
        if (keycode == 0) {
            return;
        }
        this.keyAlreadyPressed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void applyValueFromEditor() {
        if (!this.isDirty()) {
            return;
        }
        PropertyValueApplier applier = PropertyValueApplierUtil.retrievePropertyValueApplier(this.editor);
        if (applier == null) {
            PropertyEditorFactory2ValueApplier.applyValueFromTextComponentEditor(this.propertyEditor, this.editor);
            return;
        }
        String newValue = TextFieldEditor.cleanNullText(this.editor.getText());
        String oldValue = this.propertyEditor.getAsText();
        if (TextFieldEditorBehavior.isEmpty(newValue) && TextFieldEditorBehavior.isEmpty(oldValue)) {
            return;
        }
        if (newValue.equals(oldValue)) {
            return;
        }
        try {
            this.validateInput();
            this.propertyEditor.setAsText(newValue);
            applier.apply(this.propertyEditor.getValue());
        }
        catch (Exception ex) {
            try {
                this.editor.setText(oldValue);
                this.propertyEditor.setAsText(oldValue);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            EditorFactoryUtils.showErrorMessage(this.editor.getParent(), ex, newValue);
        }
        finally {
            if (!(applier instanceof PropertyModelValueApplier)) {
                return;
            }
            Object value = ((PropertyModelValueApplier)applier).value();
            this.propertyEditor.setValue(value);
            String newText = TextFieldEditor.cleanNullText(this.propertyEditor.getAsText());
            String currentText = this.editor.getText();
            if (currentText == null) {
                currentText = "";
            }
            if (!currentText.equals(newText)) {
                this.editor.setText(newText);
            }
        }
    }

    protected void validateInput() {
    }

    protected final void markEditorAsDirty() {
        this.setDirty(true);
    }

    void setDirty(boolean val) {
        TextFieldEditorBehavior.setDirty(this.editor, val);
    }

    public static void setDirty(JTextComponent editor, boolean val) {
        if (editor instanceof TextFieldEditor) {
            ((TextFieldEditor)editor).setDirty(val);
        }
        editor.putClientProperty(KEY, val);
    }

    private boolean isDirty() {
        if (this.editor instanceof TextFieldEditor) {
            return ((TextFieldEditor)this.editor).isDirty();
        }
        return TextFieldEditorBehavior.isDirty(this.editor);
    }

    static boolean isDirty(JTextComponent editor) {
        Object val = editor.getClientProperty(KEY);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        return true;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public void focusGained(FocusEvent e) {
    }

    public void insertUpdate(DocumentEvent e) {
        this.dirtyEditor();
    }

    public void removeUpdate(DocumentEvent e) {
        this.dirtyEditor();
    }

    public void changedUpdate(DocumentEvent e) {
        this.dirtyEditor();
    }

    private void dirtyEditor() {
        if (!this.keyAlreadyPressed) {
            return;
        }
        this.markEditorAsDirty();
    }
}

