/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.inspector;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.Locale;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import oracle.bali.inspector.NullEditor;
import oracle.bali.inspector.PropertyEditorFactory;
import oracle.bali.inspector.PropertyEditorValueEditor;
import oracle.bali.inspector.PropertyInspector;
import oracle.bali.inspector.PropertyModel;
import oracle.bali.share.nls.LocaleUtils;

class SwitchingCellEditor
implements TableCellEditor {
    private boolean _clearCache;
    private int _lastColumn;
    private int _lastRow;
    private TableCellEditor _cachedEditor;
    private PropertyInspector _inspector;

    public SwitchingCellEditor(PropertyInspector inspector) {
        this.init();
        this._inspector = inspector;
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (this._lastColumn != column || this._lastRow != row || this._cachedEditor == null) {
            TableCellEditor newCache = this._getEditorAt(table, column, row);
            this._lastColumn = column;
            this._lastRow = row;
            this._cachedEditor = newCache;
        }
        return this._cachedEditor.getTableCellEditorComponent(table, value, isSelected, row, column);
    }

    public Object getCellEditorValue() {
        return this._getEditor().getCellEditorValue();
    }

    public boolean isCellEditable(EventObject anEvent) {
        if (anEvent instanceof MouseEvent) {
            MouseEvent e = (MouseEvent)anEvent;
            Point p = new Point(e.getX(), e.getY());
            JTable table = (JTable)e.getSource();
            if (!table.isEnabled()) {
                return false;
            }
            int column = table.columnAtPoint(p);
            int row = table.rowAtPoint(p);
            return this._isCellEditable(table, column, row);
        }
        if (anEvent == null) {
            JTable table = this._inspector.getPropertyTable();
            if (!table.isEnabled()) {
                return false;
            }
            int row = PropertyInspector.__getAnchorSelectionIndex(table.getSelectionModel());
            int column = PropertyInspector.__getAnchorSelectionIndex(table.getColumnModel().getSelectionModel());
            if (table.hasFocus() && column != -1 && row != -1) {
                return this._isCellEditable(table, column, row);
            }
        }
        return false;
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return this._getEditor().shouldSelectCell(anEvent);
    }

    public boolean stopCellEditing() {
        boolean b = this._getEditor().stopCellEditing();
        if (this._clearCache) {
            this.init();
        }
        return b;
    }

    public void cancelCellEditing() {
        this._getEditor().cancelCellEditing();
        if (this._clearCache) {
            this.init();
        }
    }

    public void addCellEditorListener(CellEditorListener l) {
        this._getEditor().addCellEditorListener(l);
    }

    public void removeCellEditorListener(CellEditorListener l) {
        this._getEditor().removeCellEditorListener(l);
    }

    public void init() {
        this._lastColumn = -1;
        this._lastRow = -1;
        if (this._cachedEditor instanceof NullEditor) {
            ((NullEditor)this._cachedEditor).dispose();
        } else if (this._cachedEditor instanceof PropertyEditorValueEditor) {
            ((PropertyEditorValueEditor)this._cachedEditor).dispose();
        }
        this._cachedEditor = null;
    }

    private boolean _isCellEditable(JTable table, int column, int row) {
        PropertyModel model = (PropertyModel)table.getModel();
        return model.isPropertyWritable(row);
    }

    private TableCellEditor _getEditorAt(JTable table, int column, int row) {
        PropertyEditorFactory editorFactory;
        TableCellEditor editor = NullEditor.getTableCellEditor();
        this._clearCache = false;
        PropertyModel model = (PropertyModel)table.getModel();
        if (model.isPropertyWritable(row) && (editorFactory = model.getPropertyEditorFactory(row)) != null) {
            Object data = model.getData(PropertyModel.COLUMN_VALUE, row);
            try {
                editorFactory.setEditorValue(data);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (editorFactory.hasInPlaceEditor()) {
                Locale l = LocaleUtils.getDefaultableLocale((Component)table);
                editor = editorFactory.getInPlaceEditor(l);
            } else if (editorFactory.hasAdvancedEditor() || editorFactory.hasTearOffEditor()) {
                if (editorFactory.hasValueRenderer()) {
                    TableCellRenderer r = editorFactory.getValueRenderer();
                    Component c = r.getTableCellRendererComponent(table, data, false, false, row, column);
                    editor = new NullEditor(c);
                    this._clearCache = true;
                } else {
                    editor = NullEditor.getTableCellEditor();
                }
            }
        }
        return editor;
    }

    private TableCellEditor _getEditor() {
        return this._cachedEditor == null ? NullEditor.getTableCellEditor() : this._cachedEditor;
    }
}

