/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace.parser;

import java.io.PrintStream;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.raptor.sqltrace.parser.IElapsedEvent;
import oracle.dbtools.raptor.sqltrace.parser.IResourceEvent;

public class EventExecute
implements IElapsedEvent,
IResourceEvent {
    private static final Logger LOGGER = Logger.getLogger(EventExecute.class.getName());
    private int _num;
    private long _cpuTime;
    private long _elapsed;
    private long _phyReads;
    private long _consReads;
    private long _logicalReads;
    private int _miss;
    private long _rows;
    private long _dep;
    private long _og;
    private long _time;
    private static final Pattern PATTERN = Pattern.compile("#([0-9]++):c=([0-9]++),e=([0-9]++),p=([0-9]++),cr=([0-9]++),cu=([0-9]++),mis=([0-9]++),r=([0-9]++),dep=([0-9]++),og=([0-9]++),tim=([0-9]++)");

    public EventExecute(String string) {
        string = EventExecute.trimPLH(string);
        Matcher matcher = PATTERN.matcher(string);
        boolean bl = matcher.find();
        if (bl) {
            this._num = Integer.parseInt(matcher.group(1));
            this._cpuTime = Long.parseLong(matcher.group(2));
            this._elapsed = Long.parseLong(matcher.group(3));
            this._phyReads = Long.parseLong(matcher.group(4));
            this._consReads = Long.parseLong(matcher.group(5));
            this._logicalReads = Long.parseLong(matcher.group(6));
            this._miss = Integer.parseInt(matcher.group(7));
            this._rows = Long.parseLong(matcher.group(8));
            this._dep = Long.parseLong(matcher.group(9));
            this._og = Long.parseLong(matcher.group(10));
            this._time = Long.parseLong(matcher.group(11));
        } else {
            LOGGER.severe("no match for line:" + string);
        }
    }

    public static String trimPLH(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", true);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl) {
                bl = false;
                continue;
            }
            if (!string2.startsWith("plh=")) {
                stringBuilder.append(string2);
                continue;
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return String.format("EXEC #%d:c=%d,e=%d,p=%d,cr=%d,cu=%d,mis=%d,r=%d,dep=%d,og=%d,tim=%d", this._num, this._cpuTime, this._elapsed, this._phyReads, this._consReads, this._logicalReads, this._miss, this._rows, this._dep, this._og, this._time);
    }

    public static void main(String[] stringArray) {
        String string = "EXEC #4:c=0,e=795,p=0,cr=0,cu=0,mis=0,r=0,dep=0,og=4,tim=308638731695";
        EventExecute eventExecute = new EventExecute(string);
        PrintStream printStream = System.out;
        printStream.println("TEST:" + string);
        printStream.println("REST:" + eventExecute.toString());
    }

    @Override
    public long getConsistantIO() {
        return this._consReads;
    }

    public long getCpuTime() {
        return this._cpuTime;
    }

    public long getDep() {
        return this._dep;
    }

    @Override
    public long getElapsed() {
        return this._elapsed;
    }

    @Override
    public long getLogicalIO() {
        return this._logicalReads;
    }

    @Override
    public long getCacheMisses() {
        return this._miss;
    }

    public int getNum() {
        return this._num;
    }

    public long getOptimizerGoal() {
        return this._og;
    }

    @Override
    public long getPhysicalIO() {
        return this._phyReads;
    }

    @Override
    public long getRows() {
        return this._rows;
    }

    @Override
    public long getTime() {
        return this._time;
    }
}

