/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.sqltrace;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.dbtools.raptor.Messages_Tuning;
import oracle.dbtools.raptor.sqltrace.parser.SqlCursor;
import oracle.dbtools.raptor.sqltrace.ui.StatisticsSummaryTable;
import oracle.dbtools.raptor.sqltrace.ui.WaitSummaryTable;

public class SqlCursorPanel
extends JPanel {
    private JScrollPane sqlScrollArea = new JScrollPane();
    private GridBagLayout borderLayout1 = new GridBagLayout();
    private JTextArea sqlTextArea = new JTextArea();
    private Insets inset = new Insets(0, 0, 0, 0);
    private SqlCursor _cursor;
    private boolean _withSql;
    private boolean _withWaits;
    private long _factor = 0L;
    private StatisticsSummaryTable _summaryTable;
    private WaitSummaryTable _waitTable;

    public SqlCursorPanel(SqlCursor sqlCursor) {
        this(sqlCursor, true, true);
    }

    public SqlCursorPanel(SqlCursor sqlCursor, boolean bl, boolean bl2) {
        this._cursor = sqlCursor;
        this._withSql = bl;
        this._withWaits = bl2;
        this.init();
    }

    public void init() {
        this.setLayout(this.borderLayout1);
        if (this._withSql) {
            this.sqlScrollArea.setHorizontalScrollBarPolicy(30);
            this.sqlScrollArea.setVerticalScrollBarPolicy(20);
            this.sqlScrollArea.getViewport().add((Component)this.sqlTextArea, null);
            this.sqlScrollArea.setBorder(null);
            this.sqlTextArea.setLineWrap(true);
            this.sqlTextArea.setWrapStyleWord(true);
            this.sqlTextArea.setText(this._cursor.getSQL());
            this.add((Component)this.sqlScrollArea, new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 18, 1, this.inset, 0, 0));
        }
        this.initSummaryTable();
        if (this._withWaits) {
            this.initWaitSummary();
        }
    }

    public void setCursor(SqlCursor sqlCursor) {
        this._cursor = sqlCursor;
        if (this._waitTable != null) {
            this._waitTable.setWaits(sqlCursor.getWaitSummary());
        }
        this._summaryTable.setCursor(sqlCursor);
    }

    private void initWaitSummary() {
        if (this._cursor.getWaitSummary().size() > 0) {
            this._waitTable = new WaitSummaryTable(this._cursor);
            this._waitTable.setTimeFactor(this._factor);
            JScrollPane jScrollPane = new JScrollPane(this._waitTable);
            jScrollPane.setVerticalScrollBarPolicy(21);
            jScrollPane.setBackground(Color.LIGHT_GRAY);
            this.add((Component)jScrollPane, new GridBagConstraints(2, 0, 1, 1, 0.5, 0.5, 18, 1, this.inset, 0, 0));
        } else {
            this.add((Component)new JLabel(Messages_Tuning.getString("SqlCursorPanel.0")), new GridBagConstraints(2, 0, 1, 1, 0.5, 0.5, 18, 1, this.inset, 0, 0));
        }
    }

    public void initSummaryTable() {
        this._summaryTable = new StatisticsSummaryTable(this._cursor);
        this._summaryTable.setTimeFactor(this._factor);
        this._summaryTable.setMinimumSize(new Dimension(425, 95));
        JScrollPane jScrollPane = new JScrollPane(this._summaryTable);
        jScrollPane.setMinimumSize(this._summaryTable.getMinimumSize());
        jScrollPane.setVerticalScrollBarPolicy(21);
        jScrollPane.setBackground(Color.LIGHT_GRAY);
        this.add((Component)jScrollPane, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.5, 18, 1, this.inset, 0, 0));
    }

    public void setTimeFactor(long l) {
        this._factor = l;
        this._summaryTable.setTimeFactor(l);
        this._summaryTable.repaint();
        if (this._waitTable != null) {
            this._waitTable.setTimeFactor(l);
        }
    }
}

