/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.profiler;

import java.awt.Component;
import java.net.URL;
import java.sql.Connection;
import java.sql.SQLException;
import oracle.dbtools.raptor.navigator.impl.RunnableSourceNode;
import oracle.dbtools.raptor.navigator.net.DBURLFormatHelper;
import oracle.dbtools.raptor.navigator.plsql.PlSqlNode;
import oracle.dbtools.raptor.profiler.PLSQLController;
import oracle.dbtools.raptor.utils.Connections;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.IdeAction;
import oracle.ide.controls.ToggleAction;
import oracle.ide.model.Node;
import oracle.javatools.db.DBException;
import oracle.jdeveloper.JDeveloperMenuConstants;

public class PLSQLContextMenu
implements ContextMenuListener {
    public void menuWillShow(ContextMenu contextMenu) {
        Node node = contextMenu.getContext().getNode();
        if (node instanceof RunnableSourceNode) {
            String string;
            if (node instanceof PlSqlNode && "BLOCK".equals(((PlSqlNode)node).getObjectType())) {
                return;
            }
            URL uRL = node.getURL();
            if (!uRL.toString().toLowerCase().startsWith("sqldev.migration") && (string = DBURLFormatHelper.getConnectionName((URL)uRL)) != null) {
                try {
                    Connections connections = Connections.getInstance();
                    Connection connection = connections.getConnection(string, true);
                    if (connection != null) {
                        IdeAction ideAction;
                        int n = connection.getMetaData().getDatabaseMajorVersion();
                        if (connection != null && connections.isOracle(connection) && n > 10 && (ideAction = PLSQLController.getProfileAction()) != null) {
                            contextMenu.add((Component)contextMenu.createMenuItem((ToggleAction)ideAction, JDeveloperMenuConstants.WEIGHT_RUN_RUN_FILE), JDeveloperMenuConstants.SECTION_RUN_CTXT_MENU);
                        }
                    }
                }
                catch (DBException dBException) {
                    System.out.println(dBException.getMessage());
                }
                catch (SQLException sQLException) {
                    System.out.println(sQLException.getMessage());
                }
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }
}

