/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser.print;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.FontCache;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.Pilot;
import ice.storm.StormBase;
import ice.storm.StormPrinter;
import ice.storm.Viewport;
import ice.storm.print.StormPageFormat;
import ice.util.unit.PointUnit;
import ice.util.unit.Unit;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.net.URL;
import oracle.help.htmlBrowser.print.ICEPrintImpl;
import oracle.help.htmlBrowser.print.PrintStatusDialog;

public class ICEPrintImplJava2
implements ICEPrintImpl {
    private StormBase _stormBase = null;
    private String _viewportName = null;
    private Frame _parentFrame = null;
    private PrintStatusDialog _printStatusDialog = null;
    private static double PAGE_MARGIN = 54.0;

    public ICEPrintImplJava2(StormBase stormBase, String string, Frame frame) {
        this._stormBase = stormBase;
        this._viewportName = string;
        this._parentFrame = frame;
    }

    public void printURL(URL uRL) {
        if (uRL != null) {
            URL[] uRLArray = new URL[]{uRL};
            this.printURLs(uRLArray);
        }
    }

    public void printURLs(URL[] uRLArray) {
        if (uRLArray != null && uRLArray.length > 0) {
            this._doJava2Printing(uRLArray);
        }
    }

    public Printable getPrintable(URL[] uRLArray) {
        if (uRLArray != null && uRLArray.length > 0) {
            return new PrintableImpl(uRLArray);
        }
        return null;
    }

    private void _doJava2Printing(URL[] uRLArray) {
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        Paper paper = pageFormat.getPaper();
        double d = paper.getWidth();
        double d2 = paper.getHeight();
        paper.setImageableArea(PAGE_MARGIN, PAGE_MARGIN, d - 2.0 * PAGE_MARGIN, d2 - 2.0 * PAGE_MARGIN);
        pageFormat.setPaper(paper);
        pageFormat = printerJob.validatePage(pageFormat);
        printerJob.setPrintable(new PrintableImpl(uRLArray), pageFormat);
        if (printerJob.printDialog()) {
            this._printStatusDialog = new PrintStatusDialog(this._parentFrame, new CancelListener(printerJob));
            this._printStatusDialog.setVisible(true);
            try {
                printerJob.print();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this._printStatusDialog.setVisible(false);
        }
    }

    private class CancelListener
    implements ActionListener {
        private PrinterJob _printJob;

        public CancelListener(PrinterJob printerJob) {
            this._printJob = printerJob;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this._printJob.cancel();
        }
    }

    private class PrintableImpl
    implements Printable {
        private URL[] _urls;
        private int _lastPageIndex = -1;
        private String _lastPageTitle = null;
        private int _lastURLIndex = -1;
        private float _printScale = 0.75f;
        private StormPrinter _stormPrinter = null;

        public PrintableImpl(URL[] uRLArray) {
            this._urls = uRLArray;
            this._lastPageIndex = -1;
            this._lastURLIndex = -1;
            this._lastPageTitle = null;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) {
            FontCache.setPrintGraphics((Graphics)graphics);
            StormPrinter stormPrinter = this._getStormPrinter(pageFormat, n);
            this._lastPageIndex = n;
            if (stormPrinter != null) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
                graphics2D.scale(this._printScale, this._printScale);
                stormPrinter.printPage(graphics);
                FontCache.setPrintGraphics(null);
                return 0;
            }
            FontCache.setPrintGraphics(null);
            return 1;
        }

        private StormPrinter _getStormPrinter(PageFormat pageFormat, int n) {
            String string = null;
            if (n == this._lastPageIndex) {
                return this._stormPrinter;
            }
            while (this._stormPrinter == null || !this._stormPrinter.layoutNextPage()) {
                ThePilot thePilot;
                this._stormPrinter = null;
                ++this._lastURLIndex;
                if (this._lastURLIndex >= this._urls.length) break;
                URL uRL = this._urls[this._lastURLIndex];
                if (uRL == null) continue;
                ContentLoader contentLoader = new ContentLoader(uRL, "text/html");
                ICEPrintImplJava2.this._stormBase.renderContentFully(contentLoader, ICEPrintImplJava2.this._viewportName);
                Viewport viewport = ICEPrintImplJava2.this._stormBase.findViewportByName(ICEPrintImplJava2.this._viewportName);
                Pilot pilot = viewport.getPilot();
                if (pilot == null) continue;
                this._stormPrinter = pilot.createPrinter();
                if (this._stormPrinter == null) continue;
                if (pilot instanceof ThePilot) {
                    thePilot = (ThePilot)pilot;
                    DDocument dDocument = (DDocument)thePilot.getDocument();
                    string = dDocument.getTitle();
                }
                if (string != null && ICEPrintImplJava2.this._printStatusDialog != null) {
                    ICEPrintImplJava2.this._printStatusDialog.setStatusLabel(string);
                }
                thePilot = new StormPageFormat();
                thePilot.setMargin((Unit)new PointUnit(0.0), 1);
                thePilot.setMargin((Unit)new PointUnit(0.0), 3);
                thePilot.setMargin((Unit)new PointUnit(0.0), 2);
                thePilot.setMargin((Unit)new PointUnit(0.0), 4);
                if (pageFormat.getOrientation() == 0) {
                    thePilot.setOrientation(0);
                } else {
                    thePilot.setOrientation(1);
                }
                thePilot.setPageSize((Unit)new PointUnit(pageFormat.getImageableWidth() / (double)this._printScale), (Unit)new PointUnit(pageFormat.getImageableHeight() / (double)this._printScale));
                System.setProperty("ice.pilots.html4.printScaleAdjustment", "100");
                this._stormPrinter.setStormPageFormat((StormPageFormat)thePilot);
            }
            return this._stormPrinter;
        }
    }
}

