/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.htmlBrowser;

import ice.pilots.html4.DDocument;
import ice.pilots.html4.DOMEvent;
import ice.pilots.html4.Search;
import ice.pilots.html4.ThePilot;
import ice.storm.ContentLoader;
import ice.storm.StormBase;
import ice.storm.StormLocaleUtils;
import ice.storm.Viewport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.print.Printable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.event.ListenerManager;
import oracle.help.common.util.java.StaticLocaleContext;
import oracle.help.htmlBrowser.FindSupport;
import oracle.help.htmlBrowser.HTMLBrowser;
import oracle.help.htmlBrowser.ICEToolTipManager;
import oracle.help.htmlBrowser.PopupEvent;
import oracle.help.htmlBrowser.PopupListener;
import oracle.help.htmlBrowser.ProtocolEvent;
import oracle.help.htmlBrowser.ProtocolListener;
import oracle.help.htmlBrowser.URLEvent;
import oracle.help.htmlBrowser.URLListener;
import oracle.help.htmlBrowser.find.FindDialog;
import oracle.help.htmlBrowser.print.ICEPrintImpl;
import oracle.help.htmlBrowser.print.ICEPrintImplJava2;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;

public class ICEBrowser
extends JPanel
implements HTMLBrowser,
PropertyChangeListener {
    private static String PROPERTY_LOCATION = "location";
    private static String PROPERTY_PILOT_LOADING = "pilotLoading";
    private static String PROPERTY_CONTENT_LOADING = "contentLoading";
    private static String PROPERTY_CONTENT_RENDERING = "contentRendering";
    private static String MAIN_VIEWPORT_NAME = "main_viewport";
    private static String PILOT_TOOLKIT_NAME = "swing";
    private static String LOADING_CONNECT = "connect";
    private static String LOADING_BEGIN = "begin";
    private static String LOADING_END = "end";
    private static String LOADING_ERROR = "error";
    private static String RENDERING_BEGIN = "begin";
    private static String RENDERING_END = "end";
    private static String PILOT_BEGIN = "begin";
    private static String PILOT_END = "end";
    private static String PILOT_ERROR = "error";
    private AnchorListener _ANCHOR_LISTENER = new AnchorListener();
    private ICEFindSupport _findSupport = new ICEFindSupport();
    private String _queuedBackgroundColor = null;
    private String _queuedTextColor = null;
    private String _queuedLinkColor = null;
    private String _pilotEncoding = null;
    private URL _currentLocation;
    private String _loadingStatus;
    private String _renderingStatus;
    private String _pilotStatus;
    private ListenerManager _urlListeners;
    private ListenerManager _popupListeners;
    private ListenerManager _protocolListeners;
    private StormBase _iceStorm = new DeferringStormBase();

    public ICEBrowser() {
        this._iceStorm.setComponentToolkitName(PILOT_TOOLKIT_NAME);
        this._iceStorm.setContainer((Container)this, MAIN_VIEWPORT_NAME);
        this._iceStorm.addPropertyChangeListener((PropertyChangeListener)this, MAIN_VIEWPORT_NAME);
        this._iceStorm.clearContent("text/html", MAIN_VIEWPORT_NAME);
        this._currentLocation = null;
        this._loadingStatus = null;
        this._renderingStatus = null;
    }

    public void setURL(URL uRL) {
        this._renderContent(uRL);
    }

    public void setURL(URL uRL, boolean bl) {
        if (bl) {
            this._renderContentAndWait(uRL);
        } else {
            this._renderContent(uRL);
        }
    }

    public void clear() {
        this._iceStorm.clearContent("text/html", MAIN_VIEWPORT_NAME);
    }

    public Printable getPrintable(URL[] uRLArray) {
        return this._getICEPrintImpl().getPrintable(uRLArray);
    }

    public URL getURL() {
        return this._currentLocation;
    }

    public void reloadURL() {
        this._iceStorm.clearContent(null, MAIN_VIEWPORT_NAME);
        this._renderContent(this._currentLocation);
    }

    public boolean isPrintingSupported() {
        return true;
    }

    public void printURL(URL uRL) {
        this._getICEPrintImpl().printURL(uRL);
    }

    public void printURLs(URL[] uRLArray) {
        this._getICEPrintImpl().printURLs(uRLArray);
    }

    public JPanel getHTMLContainer() {
        return this;
    }

    public Dimension getCurrentRenderedSize() {
        Dimension dimension = new Dimension();
        try {
            ThePilot thePilot = this._getThePilot();
            dimension = thePilot != null ? thePilot.getDocumentDimension(dimension) : null;
        }
        catch (Exception exception) {
            dimension = null;
        }
        return dimension;
    }

    public void addURLListener(URLListener uRLListener) {
        if (this._urlListeners == null) {
            this._urlListeners = new ListenerManager();
        }
        this._urlListeners.addListener((java.util.EventListener)uRLListener);
    }

    public void removeURLListener(URLListener uRLListener) {
        if (this._urlListeners != null) {
            this._urlListeners.removeListener((java.util.EventListener)uRLListener);
        }
    }

    public void addPopupListener(PopupListener popupListener) {
        if (this._popupListeners == null) {
            this._popupListeners = new ListenerManager();
        }
        this._popupListeners.addListener((java.util.EventListener)popupListener);
    }

    public void removePopupListener(PopupListener popupListener) {
        if (this._popupListeners != null) {
            this._popupListeners.removeListener((java.util.EventListener)popupListener);
        }
    }

    public FindSupport getFindSupport() {
        return this._findSupport;
    }

    public void runFindDialog() {
        ThePilot thePilot = this._getThePilot();
        if (thePilot != null) {
            new FindDialog(WindowUtils.parentFrame((Component)this), this.getFindSupport());
        } else {
            System.err.println("Search cannot be executed");
        }
    }

    public String getCharset() {
        String string = null;
        ThePilot thePilot = this._getThePilot();
        if (thePilot != null) {
            string = thePilot.getEncoding();
        }
        if (string == null) {
            string = this._pilotEncoding;
        }
        return string;
    }

    public void setCharset(String string) {
        if (string != null) {
            ThePilot thePilot = this._getThePilot();
            if (thePilot != null) {
                thePilot.setEncoding(string);
                this.reloadURL();
            }
            this._pilotEncoding = string;
        }
    }

    public Locale getLocale() {
        return StormLocaleUtils.getLocale();
    }

    public void setLocale(Locale locale) {
        StormLocaleUtils.setLocale((Locale)locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        URLEvent uRLEvent = null;
        boolean bl = false;
        ICEBrowser iCEBrowser = this;
        synchronized (iCEBrowser) {
            if (PROPERTY_LOCATION.equals(string)) {
                try {
                    this._currentLocation = new URL((String)propertyChangeEvent.getNewValue());
                    uRLEvent = new URLEvent(this, 2000, this._currentLocation);
                }
                catch (Exception exception) {
                    this._currentLocation = null;
                }
            } else if (PROPERTY_CONTENT_LOADING.equals(string)) {
                this._loadingStatus = (String)propertyChangeEvent.getNewValue();
                if (LOADING_ERROR.equals(this._loadingStatus) || LOADING_END.equals(this._loadingStatus)) {
                    if (LOADING_END.equals(this._loadingStatus)) {
                        if (this._queuedBackgroundColor != null) {
                            this._setBackgroundColorNow(this._queuedBackgroundColor);
                        }
                        if (this._queuedTextColor != null) {
                            this._setTextColorNow(this._queuedTextColor);
                        }
                        if (this._queuedLinkColor != null) {
                            this._setLinkColorNow(this._queuedLinkColor);
                        }
                    }
                    this._queuedBackgroundColor = null;
                    this._queuedTextColor = null;
                    this._queuedLinkColor = null;
                }
            } else if (PROPERTY_CONTENT_RENDERING.equals(string)) {
                this._renderingStatus = (String)propertyChangeEvent.getNewValue();
            } else if (PROPERTY_PILOT_LOADING.equals(string)) {
                this._pilotStatus = (String)propertyChangeEvent.getNewValue();
                if (PILOT_END.equals(this._pilotStatus)) {
                    bl = true;
                    if (this._pilotEncoding != null) {
                        this.setCharset(this._pilotEncoding);
                    }
                }
            }
        }
        if (uRLEvent != null) {
            this._findSupport.clearSearch();
            this._dispatchURLEvent(uRLEvent);
        }
        if (bl) {
            this._registerPilotListeners();
        }
    }

    public synchronized void setDefaultBackground(Color color) {
        if (color != null && !LOADING_ERROR.equals(this._loadingStatus)) {
            if (!LOADING_END.equals(this._loadingStatus)) {
                this._queuedBackgroundColor = this._colorToString(color);
            } else {
                this._setBackgroundColorNow(this._colorToString(color));
            }
        }
    }

    public synchronized void setDefaultTextForeground(Color color) {
        if (color != null && !LOADING_ERROR.equals(this._loadingStatus)) {
            if (!LOADING_END.equals(this._loadingStatus)) {
                this._queuedTextColor = this._colorToString(color);
            } else {
                this._setTextColorNow(this._colorToString(color));
            }
        }
    }

    public synchronized void setDefaultLinkForeground(Color color) {
        if (color != null && !LOADING_ERROR.equals(this._loadingStatus)) {
            if (!LOADING_END.equals(this._loadingStatus)) {
                this._queuedLinkColor = this._colorToString(color);
            } else {
                this._setLinkColorNow(this._colorToString(color));
            }
        }
    }

    public void addProtocolListener(ProtocolListener protocolListener) {
        if (this._protocolListeners == null) {
            this._protocolListeners = new ListenerManager();
        }
        this._protocolListeners.addListener((java.util.EventListener)protocolListener);
    }

    public void removeProtocolListener(ProtocolListener protocolListener) {
        if (this._protocolListeners != null) {
            this._protocolListeners.removeListener((java.util.EventListener)protocolListener);
        }
    }

    public boolean canGoBack() {
        return this._iceStorm.getHistoryManager().canGoBack(MAIN_VIEWPORT_NAME);
    }

    public void goBack() {
        this._iceStorm.getHistoryManager().goBack(MAIN_VIEWPORT_NAME);
    }

    public boolean canGoForward() {
        return this._iceStorm.getHistoryManager().canGoForward(MAIN_VIEWPORT_NAME);
    }

    public void goForward() {
        this._iceStorm.getHistoryManager().goForward(MAIN_VIEWPORT_NAME);
    }

    public String getSelectedText() {
        ThePilot thePilot = this._getThePilot();
        if (thePilot != null) {
            return thePilot.getSelectedText();
        }
        return null;
    }

    public void increaseFontSize() {
        this._changeZoom(16);
    }

    public void decreaseFontSize() {
        this._changeZoom(-16);
    }

    public void selectAll() {
        ThePilot thePilot = this._getThePilot();
        if (thePilot != null) {
            thePilot.getSearch().selectAll();
        }
    }

    public String getCurrentPageTitle() {
        String string = null;
        DDocument dDocument = this._getDDocument();
        if (dDocument != null) {
            string = dDocument.getTitle();
        }
        if (string == null) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle("oracle.help.resource.MiscBundle", StaticLocaleContext.getLocale());
                string = resourceBundle.getString("icebrowser.untitleddocument");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private void _changeZoom(int n) {
        Viewport viewport = this._iceStorm.findViewportByName(MAIN_VIEWPORT_NAME);
        viewport.setZoom(viewport.getZoom() + n);
    }

    private ICEPrintImpl _getICEPrintImpl() {
        Frame frame = WindowUtils.parentFrame((Component)this);
        if (frame == null) {
            frame = new Frame("Printing Frame");
        }
        return new ICEPrintImplJava2(this._iceStorm, MAIN_VIEWPORT_NAME, frame);
    }

    private void _dispatchURLEvent(URLEvent uRLEvent) {
        Enumeration enumeration;
        if (this._urlListeners != null && (enumeration = this._urlListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                URLListener uRLListener = (URLListener)enumeration.nextElement();
                if (uRLEvent.getID() == 2000) {
                    uRLListener.urlChanged(uRLEvent);
                    continue;
                }
                if (uRLEvent.getID() != 2001) continue;
                uRLListener.anchorChanged(uRLEvent);
            }
        }
    }

    private void _dispatchPopupEvent(PopupEvent popupEvent) {
        Enumeration enumeration;
        if (this._popupListeners != null && (enumeration = this._popupListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                PopupListener popupListener = (PopupListener)enumeration.nextElement();
                popupListener.showPopup(popupEvent);
            }
        }
    }

    private void _fireProtocolEvent(ProtocolEvent protocolEvent) {
        Enumeration enumeration;
        if (this._protocolListeners != null && (enumeration = this._protocolListeners.getListeners()) != null) {
            while (enumeration.hasMoreElements()) {
                ProtocolListener protocolListener = (ProtocolListener)enumeration.nextElement();
                protocolListener.protocolReceived(protocolEvent);
            }
        }
    }

    public void dispose() {
        this._iceStorm.dispose();
        this._popupListeners = null;
        this._protocolListeners = null;
        this._urlListeners = null;
        this._iceStorm = null;
    }

    private void _registerPilotListeners() {
        ThePilot thePilot = this._getThePilot();
        if (thePilot != null) {
            ICEToolTipManager iCEToolTipManager = new ICEToolTipManager(this);
            try {
                iCEToolTipManager.registerToolTipListeners(thePilot);
                thePilot.addPersistentDOMEventListener("goto", (EventListener)this._ANCHOR_LISTENER, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void _renderContent(URL uRL) {
        if (uRL != null) {
            ContentLoader contentLoader = new ContentLoader(uRL, null);
            this._iceStorm.renderContent(contentLoader, MAIN_VIEWPORT_NAME);
        }
    }

    private void _renderContentAndWait(URL uRL) {
        if (uRL != null) {
            ContentLoader contentLoader = new ContentLoader(uRL, null);
            this._iceStorm.renderContentFully(contentLoader, MAIN_VIEWPORT_NAME);
        }
    }

    private String _colorToString(Color color) {
        String string = null;
        if (color != null) {
            string = "rgb(" + color.getRed() + "," + color.getGreen() + "," + color.getBlue() + ")";
        }
        return string;
    }

    private void _setBackgroundColorNow(String string) {
        try {
            DDocument dDocument = this._getDDocument();
            if (dDocument != null) {
                dDocument.setBgColor(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _setTextColorNow(String string) {
        try {
            DDocument dDocument = this._getDDocument();
            if (dDocument != null) {
                dDocument.setFgColor(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void _setLinkColorNow(String string) {
        try {
            DDocument dDocument = this._getDDocument();
            if (dDocument != null) {
                dDocument.setLinkColor(string);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ThePilot _getThePilot() {
        Viewport viewport = this._iceStorm.findViewportByName(MAIN_VIEWPORT_NAME);
        if (viewport != null) {
            return (ThePilot)viewport.getPilot();
        }
        return null;
    }

    private DDocument _getDDocument() {
        ThePilot thePilot = this._getThePilot();
        if (thePilot != null) {
            return thePilot.getDDocument();
        }
        return null;
    }

    private class ICEFindSupport
    extends FindSupport {
        private Search _search;

        public boolean findNext() {
            Search search = this.getSearch(true);
            if (search != null) {
                return search.findNext();
            }
            return false;
        }

        public boolean findPrevious() {
            Search search = this.getSearch(true);
            if (search != null) {
                return search.findPrevious();
            }
            return false;
        }

        public void reset() {
            Search search = this.getSearch(true);
            if (search != null) {
                search.dispose();
            }
        }

        protected void onSearchStringChange(String string, String string2) {
            Search search = this.getSearch(false);
            if (search != null) {
                search.setSearchText(string2);
            }
        }

        protected void onCaseSensitiveChange(boolean bl) {
            Search search = this.getSearch(false);
            if (search != null) {
                search.setMatchCase(bl);
            }
        }

        protected synchronized void clearSearch() {
            this._search = null;
        }

        private synchronized Search getSearch(boolean bl) {
            ThePilot thePilot;
            if (this._search == null && bl && (thePilot = ICEBrowser.this._getThePilot()) != null) {
                this._search = thePilot.getSearch();
                this._search.setSearchText(this.getSearchString());
                this._search.setMatchCase(this.isCaseSensitive());
            }
            return this._search;
        }
    }

    private class AnchorListener
    implements EventListener {
        private AnchorListener() {
        }

        public void handleEvent(Event event) {
            Node node;
            DOMEvent dOMEvent;
            if (event instanceof DOMEvent && 30 == (dOMEvent = (DOMEvent)event).getTypeId() && (node = (Node)((Object)dOMEvent.getTarget())).getNodeType() == 1) {
                String string = ((Element)node).getAttribute("name");
                URLEvent uRLEvent = new URLEvent(this, 2001, ICEBrowser.this._currentLocation, string);
                ICEBrowser.this._dispatchURLEvent(uRLEvent);
            }
        }
    }

    private class DeferringStormBase
    extends StormBase {
        private DeferringStormBase() {
        }

        public void renderContent(ContentLoader contentLoader, String string) {
            boolean bl = this._captureOHJProtocol(contentLoader.getLocation());
            if (!bl) {
                super.renderContent(contentLoader, string);
            }
        }

        public void renderContent(String string, String string2, String string3) {
            boolean bl = this._captureOHJProtocol(string);
            if (!bl) {
                super.renderContent(string, string2, string3);
            }
        }

        public void renderContentFully(ContentLoader contentLoader, String string) {
            boolean bl = this._captureOHJProtocol(contentLoader.getLocation());
            if (!bl) {
                super.renderContentFully(contentLoader, string);
            }
        }

        private boolean _captureOHJProtocol(String string) {
            boolean bl = false;
            if (string != null) {
                if (string.toLowerCase().startsWith("alink:")) {
                    String string2 = string.substring(string.indexOf(58) + 1);
                    ICEBrowser.this._fireProtocolEvent(new ProtocolEvent((Object)this, 2000, string2, null));
                    bl = true;
                } else if (string.toLowerCase().startsWith("popup:")) {
                    String string3 = string.substring(string.indexOf(58) + 1);
                    ICEBrowser.this._fireProtocolEvent(new ProtocolEvent((Object)this, 2001, string3, null));
                    bl = true;
                } else if (string.toLowerCase().startsWith("topicid:")) {
                    String string4 = string.substring(string.indexOf(58) + 1);
                    ICEBrowser.this._fireProtocolEvent(new ProtocolEvent((Object)this, 2002, string4, null));
                    bl = true;
                } else if (string.toLowerCase().startsWith("custom:")) {
                    String string5 = string.substring(string.indexOf(58) + 1);
                    ICEBrowser.this._fireProtocolEvent(new ProtocolEvent((Object)this, 2003, string5, null));
                    bl = true;
                }
            }
            return bl;
        }
    }
}

