/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.sql.CharacterBuffer;
import oracle.sql.CharacterSetWithConverter;
import oracle.sql.CharacterWalker;
import oracle.sql.converter.JdbcCharacterConverters;

class CharacterSetGB18030
extends CharacterSetWithConverter {
    static final int MAX_7BIT = 127;
    static Class m_charConvSuperclass;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE;
    private static Logger LOGGER;

    CharacterSetGB18030(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        super(n2, jdbcCharacterConverters);
    }

    static CharacterSetGB18030 getInstance(int n2, JdbcCharacterConverters jdbcCharacterConverters) {
        if (jdbcCharacterConverters.getGroupId() == 9) {
            return new CharacterSetGB18030(n2, jdbcCharacterConverters);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    int decode(CharacterWalker characterWalker) throws SQLException {
        int n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
        if (n2 <= 127) return n2;
        if (characterWalker.bytes.length > characterWalker.next + 1) {
            if ((characterWalker.bytes[characterWalker.next] & 0xFF) >= 129 && (characterWalker.bytes[characterWalker.next] & 0xFF) <= 254 && (characterWalker.bytes[characterWalker.next + 1] & 0xFF) >= 48 && (characterWalker.bytes[characterWalker.next + 1] & 0xFF) <= 57) {
                if (characterWalker.bytes.length > characterWalker.next + 3) {
                    if ((characterWalker.bytes[characterWalker.next + 2] & 0xFF) >= 129 && (characterWalker.bytes[characterWalker.next + 2] & 0xFF) <= 254 && (characterWalker.bytes[characterWalker.next + 3] & 0xFF) >= 48 && (characterWalker.bytes[characterWalker.next + 3] & 0xFF) <= 57) {
                        n2 = (characterWalker.bytes[characterWalker.next] & 0xFF) << 24 | (characterWalker.bytes[characterWalker.next + 1] & 0xFF) << 16 | (characterWalker.bytes[characterWalker.next + 2] & 0xFF) << 8 | characterWalker.bytes[characterWalker.next + 3] & 0xFF;
                        characterWalker.next += 4;
                        return n2;
                    } else {
                        n2 = characterWalker.bytes[characterWalker.next] & 0xFF;
                        ++characterWalker.next;
                    }
                    return n2;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        CharacterSetGB18030.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182 + "destination too small");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            n2 = (characterWalker.bytes[characterWalker.next] & 0xFF) << 8 | characterWalker.bytes[characterWalker.next + 1] & 0xFF;
            characterWalker.next += 2;
            return n2;
        }
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                CharacterSetGB18030.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 182 + "destination too small");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 182, "destination too small");
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    @Override
    void encode(CharacterBuffer characterBuffer, int n2) throws SQLException {
        int n3 = 0;
        int n4 = 0;
        while (n2 >> n3 != 0) {
            n3 = (short)(n3 + 8);
            n4 = (short)(n4 + 1);
        }
        if (n2 >> 16 != 0) {
            n3 = 3;
            n4 = 4;
        } else if (n2 >> 8 != 0) {
            n3 = 1;
            n4 = 2;
        } else {
            n3 = 0;
            n4 = 1;
        }
        CharacterSetGB18030.need(characterBuffer, n4);
        while (n3 >= 0) {
            characterBuffer.bytes[characterBuffer.next++] = (byte)(n2 >> n3 & 0xFF);
            n3 = (short)(n3 - 8);
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.sql");
        }
        return LOGGER;
    }

    static {
        _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
        TRACE = false;
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.sql.CharacterSetGB18030"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

