/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Hashtable;
import java.util.Properties;
import oracle.dms.instrument.NounIntf;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.NTAdapter;

public class SdpNTAdapter
implements NTAdapter {
    static final boolean DEBUG = false;
    static final String SDP_SOCKET_CLASS_NAME = "com.oracle.net.Sdp";
    static Method OPEN_SOCKET = null;
    int port;
    String host;
    protected Socket socket;
    protected int sockTimeout;
    protected Properties socketOptions;
    private static Hashtable<String, InetAddress[]> inetaddressesCache = new Hashtable();
    private static Hashtable<String, Integer> circularOffsets = new Hashtable();

    private static Socket getSDPSocket() throws IOException {
        if (OPEN_SOCKET == null) {
            try {
                Class<?> clazz = Class.forName(SDP_SOCKET_CLASS_NAME);
                OPEN_SOCKET = clazz.getMethod("openSocket", new Class[0]);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IOException("SDP enabled, but SDP socket class not in classpath", classNotFoundException);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IOException("SDP enabled but unable to get SDP socket class", noSuchMethodException);
            }
        }
        try {
            return (Socket)OPEN_SOCKET.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IOException("SDP enabled, but SDP.openSocket could not be accessed", illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new IOException("SDP enabled, but SDP.openSocket raised an exception", invocationTargetException);
        }
    }

    public SdpNTAdapter(String string, Properties properties) throws NLException {
        this.socketOptions = properties;
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair = new NVFactory().createNVPair(string);
        NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "HOST");
        NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "PORT");
        if (nVPair2 == null) {
            throw new NLException("NoNVPair-04614", "HOST");
        }
        this.host = nVPair2.getAtom();
        if (nVPair3 != null) {
            try {
                this.port = Integer.parseInt(nVPair3.getAtom());
            }
            catch (Exception exception) {
                throw (NLException)new NLException(new NetException(116).getMessage()).initCause(exception);
            }
        } else {
            this.port = 1521;
        }
        if (this.port < 0 || this.port > 65535) {
            throw new NLException(new NetException(116).getMessage());
        }
    }

    @Override
    public void connect(NounIntf nounIntf) throws IOException {
        boolean bl = Boolean.parseBoolean((String)this.socketOptions.get(19));
        if (!bl) {
            throw new IOException("Attempt to use SDP protocol without enabling SDP support.");
        }
        String string = (String)this.socketOptions.get(2);
        boolean bl2 = Boolean.parseBoolean((String)this.socketOptions.get(18));
        InetAddress[] inetAddressArray = InetAddress.getAllByName(this.host);
        if (bl2 && inetAddressArray.length > 1) {
            inetAddressArray = SdpNTAdapter.getAddressesInCircularOrder(this.host, inetAddressArray);
        }
        int n2 = inetAddressArray.length;
        int n3 = 0;
        while (true) {
            InetAddress inetAddress = inetAddressArray[n3];
            ++n3;
            --n2;
            this.socket = SdpNTAdapter.getSDPSocket();
            try {
                this.socket.connect(new InetSocketAddress(inetAddress, this.port), Integer.parseInt(string));
            }
            catch (IOException iOException) {
                try {
                    if (this.socket != null) {
                        this.socket.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (n2 > 0) continue;
                throw iOException;
                if (n3 < inetAddressArray.length) continue;
            }
            break;
        }
        this.setOption(3, string);
        this.setSocketOptions();
    }

    public void setSocketOptions() throws IOException {
        String string = (String)this.socketOptions.get(0);
        if (string != null) {
            this.setOption(0, string);
        }
        if ((string = (String)this.socketOptions.get(1)) != null) {
            this.setOption(1, string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        try {
            this.socket.close();
        }
        finally {
            this.socket = null;
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.socket.getInputStream();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.socket.getOutputStream();
    }

    @Override
    public void setOption(int n2, Object object) throws IOException, NetException {
        switch (n2) {
            case 0: {
                String string = (String)object;
                this.socket.setTcpNoDelay(string.equals("YES"));
                break;
            }
            case 1: {
                String string = (String)object;
                if (!string.equals("YES")) break;
                this.socket.setKeepAlive(true);
                break;
            }
            case 3: {
                this.sockTimeout = Integer.parseInt((String)object);
                this.socket.setSoTimeout(this.sockTimeout);
                break;
            }
        }
    }

    @Override
    public Object getOption(int n2) throws IOException, NetException {
        switch (n2) {
            case 1: {
                return "" + this.sockTimeout;
            }
        }
        return null;
    }

    @Override
    public void abort() throws NetException, IOException {
        try {
            this.socket.setSoLinger(true, 0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.socket.close();
    }

    @Override
    public void sendUrgentByte(int n2) throws IOException {
        this.socket.sendUrgentData(n2);
    }

    @Override
    public boolean isCharacteristicUrgentSupported() throws IOException {
        try {
            return !this.socket.getOOBInline();
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public void setReadTimeoutIfRequired(Properties properties) throws IOException, NetException {
        String string = (String)properties.get("oracle.net.READ_TIMEOUT");
        if (string == null) {
            string = "0";
        }
        this.setOption(3, string);
    }

    public String toString() {
        return "host=" + this.host + ", port=" + this.port + "\n    socket_timeout=" + this.sockTimeout + ", socketOptions=" + this.socketOptions.toString() + "\n    socket=" + this.socket;
    }

    private static final synchronized InetAddress[] getAddressesInCircularOrder(String string, InetAddress[] inetAddressArray) {
        InetAddress[] inetAddressArray2 = inetaddressesCache.get(string);
        Integer n2 = circularOffsets.get(string);
        if (inetAddressArray2 == null || !SdpNTAdapter.areEquals(inetAddressArray2, inetAddressArray)) {
            n2 = new Integer(0);
            inetAddressArray2 = inetAddressArray;
            inetaddressesCache.put(string, inetAddressArray);
            circularOffsets.put(string, n2);
        }
        InetAddress[] inetAddressArray3 = SdpNTAdapter.getCopyAddresses(inetAddressArray2, n2);
        circularOffsets.put(string, new Integer((n2 + 1) % inetAddressArray2.length));
        return inetAddressArray3;
    }

    private static final boolean areEquals(InetAddress[] inetAddressArray, InetAddress[] inetAddressArray2) {
        if (inetAddressArray.length != inetAddressArray2.length) {
            return false;
        }
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            if (inetAddressArray[i2].equals(inetAddressArray2[i2])) continue;
            return false;
        }
        return true;
    }

    private static final InetAddress[] getCopyAddresses(InetAddress[] inetAddressArray, int n2) {
        InetAddress[] inetAddressArray2 = new InetAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            inetAddressArray2[i2] = inetAddressArray[(i2 + n2) % inetAddressArray.length];
        }
        return inetAddressArray2;
    }

    @Override
    public boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.socket.getKeepAlive();
    }
}

