/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.Security;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import oracle.dms.instrument.NounIntf;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.MetricsEnabledSSLSocketFactoryWrapper;

public class CustomSSLSocketFactory {
    static final boolean DEBUG = false;
    public static final String DEFAULT_SSO_WALLET_FILE_NAME = "cwallet.sso";
    public static final String DEFAULT_PKCS12_WALLET_FILE_NAME = "ewallet.p12";
    public static final String SSO_WALLET_TYPE = "SSO";
    public static final String PKCS12_WALLET_TYPE = "PKCS12";
    public static final String SUPPORTED_METHOD_TYPE = "FILE";
    public static SSLSocketFactory defSSLFactory;
    public static String defPropString;
    public static boolean initDefFactory;
    NounIntf dmsParent = null;

    private CustomSSLSocketFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory getSSLSocketFactory(Properties properties, NounIntf nounIntf) throws IOException {
        Object[] objectArray;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        String string12 = null;
        SSLSocketFactory sSLSocketFactory = null;
        string11 = (String)properties.get(5);
        string12 = (String)properties.get(16);
        if (string11 == null) {
            string3 = (String)properties.get(8);
            if (string3 != null) {
                string = (String)properties.get(9);
                if (string == null) {
                    string = KeyStore.getDefaultType();
                }
                if ((string2 = (String)properties.get(10)) == null) {
                    string2 = "";
                }
                if ((string7 = (String)properties.get(14)) == null) {
                    string7 = Security.getProperty("ssl.keyManagerFactory.algorithm");
                }
                if (string7 == null) {
                    string7 = KeyManagerFactory.getDefaultAlgorithm();
                }
            }
            if ((string6 = (String)properties.get(11)) != null) {
                string4 = (String)properties.get(12);
                if (string4 == null) {
                    string4 = KeyStore.getDefaultType();
                }
                if ((string5 = (String)properties.get(13)) == null) {
                    string5 = "";
                }
                if ((string8 = (String)properties.get(15)) == null) {
                    string8 = Security.getProperty("ssl.trustManagerFactory.algorithm");
                }
                if (string8 == null) {
                    string8 = TrustManagerFactory.getDefaultAlgorithm();
                }
            }
            string9 = string3 + "#" + string + "#" + string2 + "#" + string6 + "#" + string4 + "#" + string5 + "#" + string7 + "#" + string8;
        } else {
            boolean bl = false;
            if (string11.startsWith("(")) {
                string10 = CustomSSLSocketFactory.processWalletLocation(string11);
            } else if (string11.startsWith("file:")) {
                string10 = string11.substring("file:".length());
                objectArray = new File(string10);
                if (!objectArray.exists()) {
                    throw new NetException(407, "Couldn't find file at " + string10);
                }
                if (!objectArray.isDirectory()) {
                    bl = true;
                }
            } else {
                throw new NetException(412, "Location: " + string11);
            }
            if (string12 == null) {
                string3 = !bl ? string10 + System.getProperty("file.separator") + DEFAULT_SSO_WALLET_FILE_NAME : string10;
                string = SSO_WALLET_TYPE;
                string2 = "";
                string7 = KeyManagerFactory.getDefaultAlgorithm();
                string6 = string3;
                string4 = SSO_WALLET_TYPE;
                string5 = "";
                string8 = TrustManagerFactory.getDefaultAlgorithm();
            } else {
                string3 = !bl ? string10 + System.getProperty("file.separator") + DEFAULT_PKCS12_WALLET_FILE_NAME : string10;
                string = PKCS12_WALLET_TYPE;
                string2 = string12;
                string7 = KeyManagerFactory.getDefaultAlgorithm();
                string6 = string3;
                string4 = PKCS12_WALLET_TYPE;
                string5 = string12;
                string8 = TrustManagerFactory.getDefaultAlgorithm();
            }
            string9 = string11 + "#" + string7 + "#" + string8;
        }
        if (string9.equals(defPropString)) {
            if (initDefFactory) {
                return defSSLFactory;
            }
            Class<CustomSSLSocketFactory> clazz = CustomSSLSocketFactory.class;
            synchronized (CustomSSLSocketFactory.class) {
                if (!initDefFactory) {
                    try {
                        objectArray = null;
                        TrustManager[] trustManagerArray = null;
                        if (string3 != null) {
                            objectArray = CustomSSLSocketFactory.getKeyManagerArray(string3, string2, string, string7);
                        }
                        if (string6 != null) {
                            trustManagerArray = CustomSSLSocketFactory.getTrustManagerArray(string6, string5, string4, string8);
                        }
                        SSLContext sSLContext = SSLContext.getInstance("SSL");
                        sSLContext.init((KeyManager[])objectArray, trustManagerArray, null);
                        defSSLFactory = sSLContext.getSocketFactory();
                        if (defSSLFactory != null) {
                            initDefFactory = true;
                        }
                    }
                    catch (Exception exception) {
                        throw (NetException)new NetException(410).initCause(exception);
                    }
                }
                // ** MonitorExit[var15_16] (shouldn't be in output)
                return defSSLFactory;
            }
        }
        try {
            KeyManager[] keyManagerArray = null;
            objectArray = null;
            if (string3 != null) {
                keyManagerArray = CustomSSLSocketFactory.getKeyManagerArray(string3, string2, string, string7);
            }
            if (string6 != null) {
                objectArray = CustomSSLSocketFactory.getTrustManagerArray(string6, string5, string4, string8);
            }
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(keyManagerArray, (TrustManager[])objectArray, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
            sSLSocketFactory = new MetricsEnabledSSLSocketFactoryWrapper(sSLSocketFactory, nounIntf);
            return sSLSocketFactory;
        }
        catch (Exception exception) {
            throw (NetException)new NetException(410).initCause(exception);
        }
    }

    public static KeyManager[] getKeyManagerArray(String string, String string2, String string3, String string4) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(string3);
            fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, string2.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string4);
            keyManagerFactory.init(keyStore, string2.toCharArray());
            KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
            return keyManagerArray;
        }
        catch (Exception exception) {
            throw (NetException)new NetException(408).initCause(exception);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static TrustManager[] getTrustManagerArray(String string, String string2, String string3, String string4) throws IOException {
        FileInputStream fileInputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance(string3);
            fileInputStream = new FileInputStream(string);
            keyStore.load(fileInputStream, string2.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(string4);
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            return trustManagerArray;
        }
        catch (Exception exception) {
            throw (NetException)new NetException(409).initCause(exception);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
    }

    public static String processWalletLocation(String string) throws NetException {
        String string2 = null;
        try {
            NVNavigator nVNavigator = new NVNavigator();
            NVPair nVPair = new NVFactory().createNVPair(string);
            NVPair nVPair2 = nVNavigator.findNVPair(nVPair, "METHOD");
            NVPair nVPair3 = nVNavigator.findNVPair(nVPair, "METHOD_DATA");
            NVPair nVPair4 = nVNavigator.findNVPair(nVPair3, "DIRECTORY");
            string2 = nVPair2.getAtom();
            if (string2.equalsIgnoreCase(SUPPORTED_METHOD_TYPE)) {
                String string3 = nVPair4.getAtom();
                return string3;
            }
            throw new NetException(412, string2);
        }
        catch (Exception exception) {
            throw (NetException)new NetException(407).initCause(exception);
        }
    }

    public static String getDefaultPropertiesString() {
        String string = null;
        String string2 = null;
        Object var2_2 = null;
        String string3 = null;
        String string4 = null;
        string2 = System.getProperty("oracle.net.wallet_location");
        string = string2 != null ? string2 : System.getProperty("javax.net.ssl.keyStore", "") + "#" + System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.keyStorePassword", "") + "#" + System.getProperty("javax.net.ssl.trustStore", "") + "#" + System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType()) + "#" + System.getProperty("javax.net.ssl.trustStorePassword", "");
        if (string3 == null) {
            string3 = KeyManagerFactory.getDefaultAlgorithm();
        }
        if (string4 == null) {
            string4 = TrustManagerFactory.getDefaultAlgorithm();
        }
        return string + "#" + string3 + "#" + string4;
    }

    static {
        defPropString = CustomSSLSocketFactory.getDefaultPropertiesString();
    }
}

