/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.xa.client;

import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.transaction.xa.XAException;
import javax.transaction.xa.Xid;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.xa.OracleXAConnection;
import oracle.jdbc.xa.OracleXAException;

public class OracleXAResource
extends oracle.jdbc.xa.OracleXAResource {
    private short m_version;
    private boolean needStackingForCommitRollbackPrepare;
    private static String xa_start_816 = "begin ? := JAVA_XA.xa_start(?,?,?,?); end;";
    private static String xa_start_post_816 = "begin ? := JAVA_XA.xa_start_new(?,?,?,?,?); end;";
    private static String xa_end_816 = "begin ? := JAVA_XA.xa_end(?,?); end;";
    private static String xa_end_post_816 = "begin ? := JAVA_XA.xa_end_new(?,?,?,?); end;";
    private static String xa_commit_816 = "begin ? := JAVA_XA.xa_commit (?,?,?); end;";
    private static String xa_commit_post_816 = "begin ? := JAVA_XA.xa_commit_new (?,?,?,?); end;";
    private static String xa_prepare_816 = "begin ? := JAVA_XA.xa_prepare (?,?); end;";
    private static String xa_prepare_post_816 = "begin ? := JAVA_XA.xa_prepare_new (?,?,?); end;";
    private static String xa_rollback_816 = "begin ? := JAVA_XA.xa_rollback (?,?); end;";
    private static String xa_rollback_post_816 = "begin ? := JAVA_XA.xa_rollback_new (?,?,?); end;";
    private static String xa_forget_816 = "begin ? := JAVA_XA.xa_forget (?,?); end;";
    private static String xa_forget_post_816 = "begin ? := JAVA_XA.xa_forget_new (?,?,?); end;";
    boolean isTransLoose;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource() {
        block13: {
            this.m_version = 0;
            this.needStackingForCommitRollbackPrepare = false;
            this.isTransLoose = false;
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleXAResource(Connection connection, OracleXAConnection oracleXAConnection) throws XAException {
        block21: {
            super(connection, oracleXAConnection);
            this.m_version = 0;
            this.needStackingForCommitRollbackPrepare = false;
            this.isTransLoose = false;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(connection) + ", " + OracleLog.argument(oracleXAConnection));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                try {
                    this.m_version = ((OracleConnection)connection).getVersionNumber();
                    this.needStackingForCommitRollbackPrepare = this.m_version < 9000;
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (this.m_version >= 8170) break block21;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-6);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(Xid xid, int n2) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                int n3 = -1;
                try {
                    if (xid == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    int n4 = n2 & 0xFF00;
                    int n5 = (n2 &= 0xFFFF00FF) & 0x10000 | (this.isTransLoose ? 65536 : 0);
                    if (((n2 &= 0xFFFEFFFF) & 0x8200002) != n2 || n5 != 0 && (n5 & 0x10000) != 65536) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    if ((n4 & 0xFF00) != 0 && n4 != 256 && n4 != 512 && n4 != 1024) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    if ((n2 & 0x8200000) != 0 && ((n4 & 0xFF00) != 0 || (n5 & 0x10000) != 0)) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    n2 |= n4 | n5;
                    this.saveAndAlterAutoCommitModeForGlobalTransaction();
                    try {
                        n3 = this.doStart(xid, n2);
                    }
                    catch (SQLException sQLException) {
                        this.checkError(sQLException, -3);
                    }
                    this.checkError(n3);
                    boolean[] blArray = new boolean[]{false};
                    super.createOrUpdateXid(xid, false, blArray);
                }
                catch (XAException xAException) {
                    this.restoreAutoCommitModeForGlobalTransaction();
                    throw xAException;
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doStart(Xid xid, int n2) throws XAException, SQLException {
        int n3 = -1;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_start_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, this.timeout);
            callableStatement.setInt(6, n2);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void end(Xid xid, int n2) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                block47: {
                    int n3 = -1;
                    boolean bl = false;
                    boolean bl2 = false;
                    try {
                        if (xid == null) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            throw new XAException(-5);
                        }
                        int n4 = 638582786;
                        if ((n2 & n4) != n2) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            throw new XAException(-5);
                        }
                        Xid xid2 = null;
                        bl = (n2 & 0x4000000) != 0;
                        boolean bl3 = bl2 = (n2 & 0x20000000) != 0;
                        if (bl || bl2) {
                            xid2 = super.suspendStacked(xid);
                        }
                        try {
                            boolean bl4 = false;
                            if (bl || bl2) {
                                bl4 = this.isXidSuspended(xid);
                                if (bl4) {
                                    super.resumeStacked(xid);
                                }
                                this.removeXidFromList(xid);
                            } else if (n2 == 0x2000000) {
                                boolean[] blArray = new boolean[]{false};
                                super.createOrUpdateXid(xid, true, blArray);
                                bl4 = blArray[0];
                            }
                            n3 = this.doEnd(xid, n2, bl4);
                        }
                        catch (SQLException sQLException) {
                            this.checkError(sQLException, -3);
                        }
                        if (xid2 != null) {
                            super.resumeStacked(xid2);
                        } else if (this.isXidListEmpty()) {
                            this.exitGlobalTxnMode();
                            this.activeXid = null;
                        }
                        this.checkError(n3);
                        if ((!bl || n2 == 0x4000000) && (!bl2 || n2 == 0x20000000)) break block47;
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    finally {
                        this.restoreAutoCommitModeForGlobalTransaction();
                    }
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doEnd(Xid xid, int n2, boolean bl) throws XAException, SQLException {
        CallableStatement callableStatement = null;
        int n3 = -1;
        try {
            callableStatement = this.connection.prepareCall(xa_end_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, n2);
            callableStatement.execute();
            n3 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean bl) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid) + ", " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                if (xid == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-5);
                }
                Xid xid2 = null;
                if (this.needStackingForCommitRollbackPrepare) {
                    xid2 = super.suspendStacked(xid);
                } else {
                    this.removeXidFromList(xid);
                    if (this.activeXid == null) {
                        this.exitGlobalTxnMode();
                    }
                }
                try {
                    try {
                        this.doCommit(xid, bl);
                    }
                    catch (SQLException sQLException) {
                        this.checkError(sQLException, -3);
                    }
                }
                catch (XAException xAException) {
                    if (xAException.errorCode == -7) {
                        try {
                            this.connection.close();
                        }
                        catch (SQLException sQLException) {}
                    } else if (this.needStackingForCommitRollbackPrepare) {
                        super.resumeStacked(xid2);
                    }
                    throw xAException;
                }
                if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(xid2);
                }
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doCommit(Xid xid, boolean bl) throws XAException, SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_commit_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.setInt(5, bl ? 1 : 0);
            callableStatement.execute();
            int n2 = callableStatement.getInt(1);
            this.checkError(n2, -7);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                int n2;
                Xid xid2;
                int n3;
                block46: {
                    n3 = 0;
                    if (xid == null) {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        throw new XAException(-5);
                    }
                    xid2 = null;
                    if (this.needStackingForCommitRollbackPrepare) {
                        xid2 = super.suspendStacked(xid);
                    }
                    try {
                        try {
                            n3 = this.doPrepare(xid);
                            if (n3 == 0 || n3 == 3) break block46;
                            n2 = OracleXAException.errorConvert(n3);
                            if (n2 != 0 && n2 != 3) {
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + n3);
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                XAException xAException = OracleXAException.newXAException(this.getConnectionDuringExceptionHandling(), n3);
                                xAException.fillInStackTrace();
                                throw xAException;
                            }
                            n3 = n2;
                        }
                        catch (SQLException sQLException) {
                            this.checkError(sQLException, -3);
                        }
                    }
                    catch (XAException xAException) {
                        if (xAException.errorCode == -7) {
                            try {
                                this.connection.close();
                            }
                            catch (SQLException sQLException) {}
                        } else if (this.needStackingForCommitRollbackPrepare) {
                            super.resumeStacked(xid2);
                        }
                        throw xAException;
                    }
                }
                if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(xid2);
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = n3;
                return n2;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doPrepare(Xid xid) throws XAException, SQLException {
        int n2 = 0;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_prepare_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            n2 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forget(Xid xid) throws XAException {
        Connection connection = this.connection;
        synchronized (connection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                int n2 = 0;
                if (xid == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-5);
                }
                this.removeXidFromList(xid);
                try {
                    n2 = this.doForget(xid);
                }
                catch (SQLException sQLException) {
                    this.checkError(sQLException, -3);
                }
                this.checkError(n2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doForget(Xid xid) throws XAException, SQLException {
        int n2 = 0;
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_forget_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            n2 = callableStatement.getInt(1);
        }
        catch (SQLException sQLException) {
            n2 = sQLException.getErrorCode();
            if (n2 == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(xid));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                int n2 = 0;
                if (xid == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -5);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    throw new XAException(-5);
                }
                Xid xid2 = null;
                if (this.needStackingForCommitRollbackPrepare) {
                    xid2 = super.suspendStacked(xid);
                } else {
                    this.removeXidFromList(xid);
                    if (this.activeXid == null) {
                        this.exitGlobalTxnMode();
                    }
                }
                try {
                    this.doRollback(xid);
                }
                catch (SQLException sQLException) {
                    this.checkError(sQLException, -3);
                }
                if (this.needStackingForCommitRollbackPrepare) {
                    super.resumeStacked(xid2);
                }
                this.checkError(n2);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRollback(Xid xid) throws XAException, SQLException {
        CallableStatement callableStatement = null;
        try {
            callableStatement = this.connection.prepareCall(xa_rollback_post_816);
            callableStatement.registerOutParameter(1, 2);
            callableStatement.setInt(2, xid.getFormatId());
            callableStatement.setBytes(3, xid.getGlobalTransactionId());
            callableStatement.setBytes(4, xid.getBranchQualifier());
            callableStatement.execute();
            int n2 = callableStatement.getInt(1);
            this.checkError(n2, -7);
        }
        catch (SQLException sQLException) {
            int n3 = sQLException.getErrorCode();
            if (n3 == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw new XAException(-6);
            }
            throw sQLException;
        }
        finally {
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (SQLException sQLException) {}
            callableStatement = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(stringArray) + ", " + OracleLog.argument(xidArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Connection connection = this.connection;
            synchronized (connection) {
                this.doDoTwoPhaseAction(n2, n3, stringArray, xidArray);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleXAResource.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int doDoTwoPhaseAction(int n2, int n3, String[] stringArray, Xid[] xidArray) throws XAException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleXAResource.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing XAException: " + -6);
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        throw new XAException(-6);
    }

    private static byte[] getSerializedBytes(Xid xid) {
        try {
            return Util.serializeObject(xid);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.xa.client");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.xa.client.OracleXAResource"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

