/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.sql.SQLException;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClassRef;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CKvaldfList;
import oracle.jdbc.driver.T4CTTIfun;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.util.RepConversion;
import oracle.net.ano.AuthenticationService;
import oracle.net.nt.TcpsNTAdapter;
import oracle.security.o3logon.O3LoginClientHelper;
import oracle.security.o5logon.O5Logon;
import oracle.sql.ZONEIDMAP;
import oracle.sql.converter.CharacterSetMetaData;

final class T4CTTIoauthenticate
extends T4CTTIfun {
    byte[] terminal;
    byte[] enableTempLobRefCnt;
    byte[] machine;
    byte[] sysUserName;
    byte[] processID;
    byte[] programName;
    byte[] encryptedSK;
    byte[] internalName;
    byte[] externalName;
    byte[] alterSession;
    byte[] aclValue;
    byte[] clientname;
    byte[] editionName = null;
    byte[] driverName;
    String ressourceManagerId;
    boolean bUseO5Logon;
    int verifierType;
    static final int ZTVT_ORCL_7 = 2361;
    static final int ZTVT_SSH1 = 6949;
    static final int ZTVT_NTV = 7809;
    static final int ZTVT_SMD5 = 59694;
    static final int ZTVT_MD5 = 40674;
    static final int ZTVT_SH1 = 45394;
    byte[] salt;
    byte[] encryptedKB;
    boolean isSessionTZ = true;
    static final int SERVER_VERSION_81 = 8100;
    static final int KPZ_LOGON = 1;
    static final int KPZ_CPW = 2;
    static final int KPZ_SRVAUTH = 4;
    static final int KPZ_ENCRYPTED_PASSWD = 256;
    static final int KPZ_LOGON_MIGRATE = 16;
    static final int KPZ_LOGON_SYSDBA = 32;
    static final int KPZ_LOGON_SYSOPER = 64;
    static final int KPZ_LOGON_SYSASM = 0x400000;
    static final int KPZ_LOGON_PRELIMAUTH = 128;
    static final int KPZ_PASSWD_ENCRYPTED = 256;
    static final int KPZ_LOGON_DBCONC = 512;
    static final int KPZ_PROXY_AUTH = 1024;
    static final int KPZ_SESSION_CACHE = 2048;
    static final int KPZ_PASSWD_IS_VFR = 4096;
    static final int KPZ_SESSION_QCACHE = 0x800000;
    static final String AUTH_TERMINAL = "AUTH_TERMINAL";
    static final String AUTH_PROGRAM_NM = "AUTH_PROGRAM_NM";
    static final String AUTH_MACHINE = "AUTH_MACHINE";
    static final String AUTH_PID = "AUTH_PID";
    static final String AUTH_SID = "AUTH_SID";
    static final String AUTH_SESSKEY = "AUTH_SESSKEY";
    static final String AUTH_VFR_DATA = "AUTH_VFR_DATA";
    static final String AUTH_PASSWORD = "AUTH_PASSWORD";
    static final String AUTH_INTERNALNAME = "AUTH_INTERNALNAME_";
    static final String AUTH_EXTERNALNAME = "AUTH_EXTERNALNAME_";
    static final String AUTH_ACL = "AUTH_ACL";
    static final String AUTH_ALTER_SESSION = "AUTH_ALTER_SESSION";
    static final String AUTH_INITIAL_CLIENT_ROLE = "INITIAL_CLIENT_ROLE";
    static final String AUTH_VERSION_SQL = "AUTH_VERSION_SQL";
    static final String AUTH_VERSION_NO = "AUTH_VERSION_NO";
    static final String AUTH_XACTION_TRAITS = "AUTH_XACTION_TRAITS";
    static final String AUTH_VERSION_STATUS = "AUTH_VERSION_STATUS";
    static final String AUTH_SERIAL_NUM = "AUTH_SERIAL_NUM";
    static final String AUTH_SESSION_ID = "AUTH_SESSION_ID";
    static final String AUTH_CLIENT_CERTIFICATE = "AUTH_CLIENT_CERTIFICATE";
    static final String AUTH_PROXY_CLIENT_NAME = "PROXY_CLIENT_NAME";
    static final String AUTH_CLIENT_DN = "AUTH_CLIENT_DISTINGUISHED_NAME";
    static final String AUTH_INSTANCENAME = "AUTH_INSTANCENAME";
    static final String AUTH_DBNAME = "AUTH_DBNAME";
    static final String AUTH_INSTANCE_NO = "AUTH_INSTANCE_NO";
    static final String AUTH_SC_SERVER_HOST = "AUTH_SC_SERVER_HOST";
    static final String AUTH_SC_INSTANCE_NAME = "AUTH_SC_INSTANCE_NAME";
    static final String AUTH_SC_INSTANCE_ID = "AUTH_SC_INSTANCE_ID";
    static final String AUTH_SC_INSTANCE_START_TIME = "AUTH_SC_INSTANCE_START_TIME";
    static final String AUTH_SC_DBUNIQUE_NAME = "AUTH_SC_DBUNIQUE_NAME";
    static final String AUTH_SC_SERVICE_NAME = "AUTH_SC_SERVICE_NAME";
    static final String AUTH_SC_SVC_FLAGS = "AUTH_SC_SVC_FLAGS";
    static final String AUTH_SESSION_CLIENT_CSET = "SESSION_CLIENT_CHARSET";
    static final String AUTH_SESSION_CLIENT_LTYPE = "SESSION_CLIENT_LIB_TYPE";
    static final String AUTH_SESSION_CLIENT_DRVNM = "SESSION_CLIENT_DRIVER_NAME";
    static final String AUTH_SESSION_CLIENT_VSN = "SESSION_CLIENT_VERSION";
    static final String AUTH_NLS_LXLAN = "AUTH_NLS_LXLAN";
    static final String AUTH_NLS_LXCTERRITORY = "AUTH_NLS_LXCTERRITORY";
    static final String AUTH_NLS_LXCCURRENCY = "AUTH_NLS_LXCCURRENCY";
    static final String AUTH_NLS_LXCISOCURR = "AUTH_NLS_LXCISOCURR";
    static final String AUTH_NLS_LXCNUMERICS = "AUTH_NLS_LXCNUMERICS";
    static final String AUTH_NLS_LXCDATEFM = "AUTH_NLS_LXCDATEFM";
    static final String AUTH_NLS_LXCDATELANG = "AUTH_NLS_LXCDATELANG";
    static final String AUTH_NLS_LXCSORT = "AUTH_NLS_LXCSORT";
    static final String AUTH_NLS_LXCCALENDAR = "AUTH_NLS_LXCCALENDAR";
    static final String AUTH_NLS_LXCUNIONCUR = "AUTH_NLS_LXCUNIONCUR";
    static final String AUTH_NLS_LXCTIMEFM = "AUTH_NLS_LXCTIMEFM";
    static final String AUTH_NLS_LXCSTMPFM = "AUTH_NLS_LXCSTMPFM";
    static final String AUTH_NLS_LXCTTZNFM = "AUTH_NLS_LXCTTZNFM";
    static final String AUTH_NLS_LXCSTZNFM = "AUTH_NLS_LXCSTZNFM";
    static final String SESSION_CLIENT_LOBATTR = "SESSION_CLIENT_LOBATTR";
    static final String DRIVER_NAME_DEFAULT = "jdbcthin";
    static final int KPU_LIB_UNKN = 0;
    static final int KPU_LIB_DEF = 1;
    static final int KPU_LIB_EI = 2;
    static final int KPU_LIB_XE = 3;
    static final int KPU_LIB_ICUS = 4;
    static final int KPU_LIB_OCI = 5;
    static final int KPU_LIB_THIN = 10;
    static final String AUTH_ORA_EDITION = "AUTH_ORA_EDITION";
    static final String AUTH_COPYRIGHT = "AUTH_COPYRIGHT";
    static final String COPYRIGHT_STR = "\"Oracle\nEverybody follows\nSpeedy bits exchange\nStars await to glow\"\nThe preceding key is copyrighted by Oracle Corporation.\nDuplication of this key is not allowed without permission\nfrom Oracle Corporation. Copyright 2003 Oracle Corporation.";
    static final String SESSION_TIME_ZONE = "SESSION_TIME_ZONE";
    static final String SESSION_NLS_LXCCHARSET = "SESSION_NLS_LXCCHARSET";
    static final String SESSION_NLS_LXCNLSLENSEM = "SESSION_NLS_LXCNLSLENSEM";
    static final String SESSION_NLS_LXCNCHAREXCP = "SESSION_NLS_LXCNCHAREXCP";
    static final String SESSION_NLS_LXCNCHARIMP = "SESSION_NLS_LXCNCHARIMP";
    String sessionTimeZone = null;
    byte[] serverCompileTimeCapabilities = null;
    private T4CKvaldfList keyValList = null;
    private byte[] user = null;
    private long logonMode;
    private byte[][] outKeys = null;
    private byte[][] outValues = null;
    private int[] outFlags = new int[0];
    private int outNbPairs = 0;
    O5Logon o5logonHelper = new O5Logon();
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    T4CTTIoauthenticate(T4CConnection t4CConnection, String string, byte[] byArray) throws SQLException {
        super(t4CConnection, (byte)3);
        this.ressourceManagerId = string;
        this.serverCompileTimeCapabilities = byArray;
        this.setSessionFields(t4CConnection);
        this.isSessionTZ = true;
        this.bUseO5Logon = false;
    }

    @Override
    void marshal() throws IOException {
        if (this.user != null && this.user.length > 0) {
            this.meg.marshalPTR();
            this.meg.marshalSB4(this.user.length);
        } else {
            this.meg.marshalNULLPTR();
            this.meg.marshalSB4(0);
        }
        this.meg.marshalUB4(this.logonMode);
        this.meg.marshalPTR();
        this.meg.marshalUB4(this.keyValList.size());
        this.meg.marshalPTR();
        this.meg.marshalPTR();
        if (this.user != null && this.user.length > 0) {
            this.meg.marshalCHR(this.user);
        }
        this.meg.marshalKEYVAL(this.keyValList.getKeys(), this.keyValList.getValues(), this.keyValList.getFlags(), this.keyValList.size());
    }

    private void doOAUTH(byte[] byArray, byte[] byArray2, long l2, String string, boolean bl, byte[] byArray3, byte[] byArray4, byte[][] byArray5, int n2, int n3) throws IOException, SQLException {
        this.setFunCode((short)115);
        this.user = byArray;
        this.logonMode = l2 | 1L;
        if (bl) {
            this.logonMode |= 0x400L;
        }
        if (byArray != null && byArray.length != 0 && byArray2 != null && string != "RADIUS") {
            this.logonMode |= 0x100L;
        }
        this.keyValList = new T4CKvaldfList(this.meg.conv);
        if (byArray2 != null) {
            this.keyValList.add(AUTH_PASSWORD, byArray2);
        }
        if (byArray5 != null) {
            for (int i2 = 0; i2 < byArray5.length; ++i2) {
                this.keyValList.add(AUTH_INITIAL_CLIENT_ROLE, byArray5[i2]);
            }
        }
        if (byArray3 != null) {
            this.keyValList.add(AUTH_CLIENT_DN, byArray3);
        }
        if (byArray4 != null) {
            this.keyValList.add(AUTH_CLIENT_CERTIFICATE, byArray4);
        }
        this.keyValList.add(AUTH_TERMINAL, this.terminal);
        if (this.bUseO5Logon && this.encryptedKB != null) {
            this.keyValList.add(AUTH_SESSKEY, this.encryptedKB, (byte)1);
        }
        if (this.programName != null) {
            this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
        }
        if (this.clientname != null) {
            this.keyValList.add(AUTH_PROXY_CLIENT_NAME, this.clientname);
        }
        this.keyValList.add(AUTH_MACHINE, this.machine);
        this.keyValList.add(AUTH_PID, this.processID);
        if (!this.ressourceManagerId.equals("0000")) {
            byte[] byArray6 = this.meg.conv.StringToCharBytes(AUTH_INTERNALNAME);
            byArray6[byArray6.length - 1] = 0;
            this.keyValList.add(byArray6, this.internalName);
            byArray6 = this.meg.conv.StringToCharBytes(AUTH_EXTERNALNAME);
            byArray6[byArray6.length - 1] = 0;
            this.keyValList.add(byArray6, this.externalName);
        }
        this.keyValList.add(AUTH_ACL, this.aclValue);
        this.keyValList.add(AUTH_ALTER_SESSION, this.alterSession, (byte)1);
        if (this.editionName != null) {
            this.keyValList.add(AUTH_ORA_EDITION, this.editionName);
        }
        this.keyValList.add(SESSION_CLIENT_LOBATTR, this.enableTempLobRefCnt);
        this.keyValList.add(AUTH_SESSION_CLIENT_DRVNM, this.driverName);
        this.keyValList.add(AUTH_SESSION_CLIENT_VSN, this.meg.conv.StringToCharBytes(Integer.toString(this.versionStringToInt(this.connection.getMetaData().getDriverVersion()), 10)));
        if (n2 != -1) {
            this.keyValList.add(AUTH_SESSION_ID, this.meg.conv.StringToCharBytes(Integer.toString(n2)));
        }
        if (n3 != -1) {
            this.keyValList.add(AUTH_SERIAL_NUM, this.meg.conv.StringToCharBytes(Integer.toString(n3)));
        }
        this.keyValList.add(AUTH_COPYRIGHT, this.meg.conv.StringToCharBytes(COPYRIGHT_STR));
        this.outNbPairs = 0;
        this.outKeys = null;
        this.outValues = null;
        this.outFlags = new int[0];
        this.doRPC();
    }

    void doOSESSKEY(String string, long l2) throws IOException, SQLException {
        this.setFunCode((short)118);
        this.user = this.meg.conv.StringToCharBytes(string);
        this.logonMode = l2 | 1L;
        this.keyValList = new T4CKvaldfList(this.meg.conv);
        this.keyValList.add(AUTH_TERMINAL, this.terminal);
        if (this.programName != null) {
            this.keyValList.add(AUTH_PROGRAM_NM, this.programName);
        }
        this.keyValList.add(AUTH_MACHINE, this.machine);
        this.keyValList.add(AUTH_PID, this.processID);
        this.keyValList.add(AUTH_SID, this.sysUserName);
        this.outNbPairs = 0;
        this.outKeys = null;
        this.outValues = null;
        this.outFlags = new int[0];
        this.doRPC();
    }

    @Override
    void readRPA() throws IOException, SQLException {
        this.outNbPairs = this.meg.unmarshalUB2();
        this.outKeys = new byte[this.outNbPairs][];
        this.outValues = new byte[this.outNbPairs][];
        this.outFlags = this.meg.unmarshalKEYVAL(this.outKeys, this.outValues, this.outNbPairs);
    }

    @Override
    void processError() throws SQLException {
        if (this.getFunCode() == 118) {
            if (this.oer.getRetCode() != 28035 || this.connection.net.getAuthenticationAdaptorName() != "RADIUS") {
                this.oer.processError();
            }
        } else {
            super.processError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processRPA() throws SQLException {
        if (this.getFunCode() == 115) {
            Properties properties = new Properties();
            for (int i2 = 0; i2 < this.outNbPairs; ++i2) {
                String string = this.meg.conv.CharBytesToString(this.outKeys[i2], this.outKeys[i2].length).trim();
                String string2 = "";
                if (this.outValues[i2] != null) {
                    string2 = this.meg.conv.CharBytesToString(this.outValues[i2], this.outValues[i2].length).trim();
                }
                properties.setProperty(string, string2);
            }
            String string = properties.getProperty(AUTH_VERSION_NO);
            if (string != null) {
                try {
                    int n2 = new Integer(string);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            properties.setProperty("SERVER_HOST", properties.getProperty(AUTH_SC_SERVER_HOST, ""));
            properties.setProperty("INSTANCE_NAME", properties.getProperty(AUTH_SC_INSTANCE_NAME, ""));
            properties.setProperty("DATABASE_NAME", properties.getProperty(AUTH_SC_DBUNIQUE_NAME, ""));
            properties.setProperty("SERVICE_NAME", properties.getProperty(AUTH_SC_SERVICE_NAME, ""));
            properties.setProperty(SESSION_TIME_ZONE, this.sessionTimeZone);
            this.connection.sessionProperties = properties;
        } else if (this.getFunCode() == 118 && this.connection.net.getAuthenticationAdaptorName() != "RADIUS") {
            if (this.outKeys == null || this.outKeys.length < 1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 438);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n3 = -1;
            int n4 = -1;
            try {
                for (int i3 = 0; i3 < this.outKeys.length; ++i3) {
                    String string = new String(this.outKeys[i3], "US-ASCII");
                    if (string.equals(AUTH_SESSKEY)) {
                        n3 = i3;
                    } else if (string.equals(AUTH_VFR_DATA)) {
                        n4 = i3;
                    }
                    if (n4 == -1 || n3 == -1) {
                        continue;
                    }
                    break;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            if (n3 == -1) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 438);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.encryptedSK = this.outValues[n3];
            if (n4 != -1) {
                this.bUseO5Logon = true;
                this.salt = this.outValues[n4];
                this.verifierType = this.outFlags[n4];
            }
            if (!(this.bUseO5Logon || this.encryptedSK != null && this.encryptedSK.length == 16)) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 438);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 438);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void doOAUTH(String string, String string2, long l2) throws IOException, SQLException {
        block49: {
            Object object;
            Object object2;
            byte[] byArray = null;
            if (string != null && string.length() > 0) {
                byArray = this.meg.conv.StringToCharBytes(string);
            }
            byte[] byArray2 = null;
            byte[] byArray3 = null;
            byte[] byArray4 = null;
            String string3 = this.connection.net.getAuthenticationAdaptorName();
            if (string != null && string.length() != 0) {
                byte by;
                if (string3 != "RADIUS" && this.encryptedSK.length > 16 && !this.bUseO5Logon) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 413);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.bUseO5Logon && (this.encryptedSK == null || this.encryptedSK.length != 64 && this.encryptedSK.length != 96)) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 413);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                object2 = string.trim();
                object = null;
                if (string2 != null) {
                    object = string2.trim();
                }
                string2 = null;
                String string4 = object2;
                String string5 = object;
                if (((String)object2).startsWith("\"") || ((String)object2).endsWith("\"")) {
                    string4 = this.removeQuotes((String)object2);
                }
                if (object != null && (((String)object).startsWith("\"") || ((String)object).endsWith("\""))) {
                    string5 = this.removeQuotes((String)object);
                }
                if (string5 != null) {
                    byArray2 = this.meg.conv.StringToCharBytes(string5);
                }
                if (string3 != "RADIUS") {
                    if (byArray2 == null) {
                        byArray4 = null;
                    } else if (this.bUseO5Logon) {
                        this.encryptedKB = new byte[this.encryptedSK.length];
                        for (int i2 = 0; i2 < this.encryptedKB.length; ++i2) {
                            this.encryptedKB[i2] = 1;
                        }
                        int[] nArray = new int[1];
                        byte[] byArray5 = new byte[256];
                        for (int i3 = 0; i3 < 256; ++i3) {
                            byArray5[i3] = 0;
                        }
                        try {
                            this.o5logonHelper.generateOAuthResponse(this.verifierType, this.salt, string4, string5, byArray2, this.encryptedSK, this.encryptedKB, byArray5, nArray, this.meg.conv.isServerCSMultiByte, this.serverCompileTimeCapabilities[4]);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        byArray4 = new byte[nArray[0]];
                        System.arraycopy(byArray5, 0, byArray4, 0, nArray[0]);
                    } else {
                        O3LoginClientHelper o3LoginClientHelper = new O3LoginClientHelper(this.meg.conv.isServerCSMultiByte);
                        byte[] byArray6 = o3LoginClientHelper.getSessionKey(string4, string5, this.encryptedSK);
                        by = byArray2.length % 8 > 0 ? (byte)((byte)(8 - byArray2.length % 8)) : (byte)0;
                        byArray3 = new byte[byArray2.length + by];
                        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                        byte[] byArray7 = o3LoginClientHelper.getEPasswd(byArray6, byArray3);
                        byArray4 = new byte[2 * byArray3.length + 1];
                        if (byArray4.length < 2 * byArray7.length) {
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 413);
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 413);
                            sQLException.fillInStackTrace();
                            throw sQLException;
                        }
                        RepConversion.bArray2Nibbles(byArray7, byArray4);
                        byArray4[byArray4.length - 1] = RepConversion.nibbleToHex(by);
                    }
                } else if (byArray2 != null) {
                    if (this.connection.net.getSessionAttributes().getNTAdapter() instanceof TcpsNTAdapter) {
                        byArray4 = byArray2;
                    } else {
                        by = (byArray2.length + 1) % 8 > 0 ? (byte)((byte)(8 - (byArray2.length + 1) % 8)) : (byte)0;
                        byArray3 = new byte[byArray2.length + 1 + by];
                        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                        byte[] byArray8 = AuthenticationService.obfuscatePasswordForRadius(byArray3);
                        byArray4 = new byte[byArray8.length * 2];
                        for (int i4 = 0; i4 < byArray8.length; ++i4) {
                            byte by2 = (byte)((byArray8[i4] & 0xF0) >> 4);
                            byte by3 = (byte)(byArray8[i4] & 0xF);
                            byArray4[i4 * 2] = (byte)(by2 < 10 ? by2 + 48 : by2 - 10 + 97);
                            byArray4[i4 * 2 + 1] = (byte)(by3 < 10 ? by3 + 48 : by3 - 10 + 97);
                        }
                    }
                }
            }
            this.doOAUTH(byArray, byArray4, l2, string3, false, null, null, null, -1, -1);
            if (string3 != "RADIUS" && this.bUseO5Logon) {
                String string6 = this.connection.sessionProperties.getProperty("AUTH_SVR_RESPONSE");
                try {
                    if (this.o5logonHelper.validateServerIdentity(string6)) break block49;
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 452);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    object2 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452);
                    ((Throwable)object2).fillInStackTrace();
                    throw object2;
                }
                catch (Exception exception) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 452);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    object = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 452);
                    ((Throwable)object).fillInStackTrace();
                    throw object;
                }
            }
        }
    }

    void doOAUTH(int n2, Properties properties, int n3, int n4) throws IOException, SQLException {
        String string;
        CharSequence charSequence;
        byte[] byArray = null;
        byte[] byArray2 = null;
        String[] stringArray = null;
        Object object = null;
        byte[] byArray3 = null;
        if (n2 == 1) {
            charSequence = properties.getProperty("PROXY_USER_NAME");
            string = properties.getProperty("PROXY_USER_PASSWORD");
            if (string != null) {
                charSequence = (String)charSequence + "/" + string;
            }
            byArray3 = this.meg.conv.StringToCharBytes((String)charSequence);
        } else if (n2 == 2) {
            charSequence = properties.getProperty("PROXY_DISTINGUISHED_NAME");
            byArray = this.meg.conv.StringToCharBytes((String)charSequence);
        } else {
            try {
                byArray2 = (byte[])properties.get("PROXY_CERTIFICATE");
                charSequence = new StringBuffer();
                for (int i2 = 0; i2 < byArray2.length; ++i2) {
                    string = Integer.toHexString(0xFF & byArray2[i2]);
                    int n5 = string.length();
                    if (n5 == 0) {
                        ((StringBuffer)charSequence).append("00");
                        continue;
                    }
                    if (n5 == 1) {
                        ((StringBuffer)charSequence).append('0');
                        ((StringBuffer)charSequence).append(string);
                        continue;
                    }
                    ((StringBuffer)charSequence).append(string);
                }
                byArray2 = ((StringBuffer)charSequence).toString().getBytes();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            stringArray = (String[])properties.get("PROXY_ROLES");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (stringArray != null) {
            object = new byte[stringArray.length][];
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                object[i3] = this.meg.conv.StringToCharBytes(stringArray[i3]);
            }
        }
        this.doOAUTH(byArray3, null, 0L, null, true, byArray, byArray2, (byte[][])object, n3, n4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSessionFields(T4CConnection t4CConnection) throws SQLException {
        String string = this.connection.thinVsessionTerminal;
        String string2 = this.connection.thinVsessionMachine;
        String string3 = this.connection.thinVsessionOsuser;
        String string4 = this.connection.thinVsessionProgram;
        String string5 = this.connection.thinVsessionProcess;
        String string6 = this.connection.thinVsessionIname;
        String string7 = this.connection.thinVsessionEname;
        String string8 = this.connection.proxyClientName;
        String string9 = this.connection.driverNameAttribute;
        String string10 = this.connection.editionName;
        try {
            this.enableTempLobRefCnt = this.connection.enableTempLobRefCnt ? new String("1").getBytes("US-ASCII") : new String("0").getBytes("US-ASCII");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        if (string2 == null) {
            try {
                string2 = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception exception) {
                string2 = "jdbcclient";
            }
        }
        if (string7 == null) {
            string7 = "jdbc_" + this.ressourceManagerId;
        }
        if (string9 == null) {
            string9 = DRIVER_NAME_DEFAULT;
        }
        this.terminal = this.meg.conv.StringToCharBytes(string);
        this.machine = this.meg.conv.StringToCharBytes(string2);
        this.sysUserName = this.meg.conv.StringToCharBytes(string3);
        this.programName = this.meg.conv.StringToCharBytes(string4);
        this.processID = this.meg.conv.StringToCharBytes(string5);
        this.internalName = this.meg.conv.StringToCharBytes(string6);
        this.externalName = this.meg.conv.StringToCharBytes(string7);
        if (string8 != null) {
            this.clientname = this.meg.conv.StringToCharBytes(string8);
        }
        if (string10 != null) {
            this.editionName = this.meg.conv.StringToCharBytes(string10);
        }
        this.driverName = this.meg.conv.StringToCharBytes(string9);
        TimeZone timeZone = TimeZone.getDefault();
        String string11 = timeZone.getID();
        if (!ZONEIDMAP.isValidRegion(string11) || !t4CConnection.timezoneAsRegion) {
            int n2 = timeZone.getOffset(System.currentTimeMillis());
            int n3 = n2 / 3600000;
            int n4 = n2 / 60000 % 60;
            string11 = (n3 < 0 ? "" + n3 : "+" + n3) + (n4 < 10 ? ":0" + n4 : ":" + n4);
        }
        this.sessionTimeZone = string11;
        t4CConnection.sessionTimeZone = string11;
        String string12 = CharacterSetMetaData.getNLSLanguage(ClassRef.LOCALE.getDefault());
        String string13 = CharacterSetMetaData.getNLSTerritory(ClassRef.LOCALE.getDefault());
        if (string12 == null || string13 == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    T4CTTIoauthenticate.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 176);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 176);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.alterSession = this.meg.conv.StringToCharBytes("ALTER SESSION SET " + (this.isSessionTZ ? "TIME_ZONE='" + this.sessionTimeZone + "'" : "") + " NLS_LANGUAGE='" + string12 + "' NLS_TERRITORY='" + string13 + "' ");
        this.aclValue = this.meg.conv.StringToCharBytes("4400");
        this.alterSession[this.alterSession.length - 1] = 0;
    }

    String removeQuotes(String string) {
        int n2;
        int n3 = 0;
        int n4 = string.length() - 1;
        for (n2 = 0; n2 < string.length(); ++n2) {
            if (string.charAt(n2) == '\"') continue;
            n3 = n2;
            break;
        }
        for (n2 = string.length() - 1; n2 >= 0; --n2) {
            if (string.charAt(n2) == '\"') continue;
            n4 = n2;
            break;
        }
        String string2 = string.substring(n3, n4 + 1);
        return string2;
    }

    private int versionStringToInt(String string) throws SQLException {
        String[] stringArray = string.split("\\.");
        int n2 = Integer.parseInt(stringArray[0].replaceAll("\\D", ""));
        int n3 = Integer.parseInt(stringArray[1].replaceAll("\\D", ""));
        int n4 = Integer.parseInt(stringArray[2].replaceAll("\\D", ""));
        int n5 = Integer.parseInt(stringArray[3].replaceAll("\\D", ""));
        int n6 = Integer.parseInt(stringArray[4].replaceAll("\\D", ""));
        int n7 = n2 << 24 | n3 << 20 | n4 << 12 | n5 << 8 | n6;
        return n7;
    }

    private String versionIntToString(int n2) throws SQLException {
        int n3 = (n2 & 0xFF000000) >> 24 & 0xFF;
        int n4 = (n2 & 0xF00000) >> 20 & 0xFF;
        int n5 = (n2 & 0xFF000) >> 12 & 0xFF;
        int n6 = (n2 & 0xF00) >> 8 & 0xFF;
        int n7 = n2 & 0xFF;
        String string = "" + n3 + "." + n4 + "." + n5 + "." + n6 + "." + n7;
        return string;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return this.connection;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.T4CTTIoauthenticate"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

