/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.CHAR;
import oracle.sql.CharacterSet;
import oracle.sql.Datum;
import oracle.sql.NUMBER;

class PlsqlIndexTableAccessor
extends Accessor {
    int elementInternalType;
    int maxNumberOfElements;
    int elementMaxLen;
    int ibtValueIndex;
    int ibtIndicatorIndex;
    int ibtLengthIndex;
    int ibtMetaIndex;
    int ibtByteLength;
    int ibtCharLength;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    PlsqlIndexTableAccessor(OracleStatement oracleStatement, int n2, int n3, int n4, int n5, short s2, boolean bl) throws SQLException {
        this.init(oracleStatement, 998, 998, s2, bl);
        this.elementInternalType = n3;
        this.maxNumberOfElements = n5;
        this.elementMaxLen = n4;
        this.initForDataAccess(n2, n4, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    void initForDataAccess(int var1_1, int var2_2, String var3_3) throws SQLException {
        if (var1_1 != 0) {
            this.externalType = var1_1;
        }
        switch (this.elementInternalType) {
            case 1: 
            case 96: {
                this.internalTypeMaxLength = ((OraclePreparedStatement)this.statement).maxIbtVarcharElementLength;
                if (var2_2 <= this.internalTypeMaxLength) ** GOTO lbl18
                if (PlsqlIndexTableAccessor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PlsqlIndexTableAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 53);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_5 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 53);
                var4_5.fillInStackTrace();
                throw var4_5;
lbl18:
                // 1 sources

                this.elementMaxLen = (var2_2 == 0 ? this.internalTypeMaxLength : var2_2) + 1;
                this.ibtCharLength = this.elementMaxLen * this.maxNumberOfElements;
                this.elementInternalType = 9;
                break;
            }
            case 6: {
                this.internalTypeMaxLength = 21;
                this.elementMaxLen = this.internalTypeMaxLength + 1;
                this.ibtByteLength = this.elementMaxLen * this.maxNumberOfElements;
                break;
            }
            default: {
                if (PlsqlIndexTableAccessor.TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PlsqlIndexTableAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 97);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                var4_6 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                var4_6.fillInStackTrace();
                throw var4_6;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object[] getPlsqlIndexTable(int n2) throws SQLException {
        Object[] objectArray = null;
        short[] sArray = this.statement.ibtBindIndicators;
        int n3 = ((sArray[this.ibtMetaIndex + 4] & 0xFFFF) << 16) + (sArray[this.ibtMetaIndex + 5] & 0xFFFF);
        int n4 = this.ibtValueIndex;
        switch (this.elementInternalType) {
            case 9: {
                objectArray = new String[n3];
                char[] cArray = this.statement.ibtBindChars;
                for (int i2 = 0; i2 < n3; ++i2) {
                    objectArray[i2] = sArray[this.ibtIndicatorIndex + i2] == -1 ? null : new String(cArray, n4 + 1, cArray[n4] >> 1);
                    n4 += this.elementMaxLen;
                }
                break;
            }
            case 6: {
                objectArray = new BigDecimal[n3];
                byte[] byArray = this.statement.ibtBindBytes;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (sArray[this.ibtIndicatorIndex + i3] == -1) {
                        objectArray[i3] = null;
                    } else {
                        byte by = byArray[n4];
                        byte[] byArray2 = new byte[by];
                        System.arraycopy(byArray, n4 + 1, byArray2, 0, by);
                        objectArray[i3] = oracle.sql.NUMBER.toBigDecimal(byArray2);
                    }
                    n4 += this.elementMaxLen;
                }
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PlsqlIndexTableAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 97);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        Datum[] datumArray = null;
        short[] sArray = this.statement.ibtBindIndicators;
        int n3 = ((sArray[this.ibtMetaIndex + 4] & 0xFFFF) << 16) + (sArray[this.ibtMetaIndex + 5] & 0xFFFF);
        int n4 = this.ibtValueIndex;
        switch (this.elementInternalType) {
            case 9: {
                datumArray = new CHAR[n3];
                CharacterSet characterSet = CharacterSet.make(2000);
                char[] cArray = this.statement.ibtBindChars;
                for (int i2 = 0; i2 < n3; ++i2) {
                    if (sArray[this.ibtIndicatorIndex + i2] == -1) {
                        datumArray[i2] = null;
                    } else {
                        char c2 = cArray[n4];
                        byte[] byArray = new byte[c2];
                        DBConversion.javaCharsToUcs2Bytes(cArray, n4 + 1, byArray, 0, c2 >> 1);
                        datumArray[i2] = new CHAR(byArray, characterSet);
                    }
                    n4 += this.elementMaxLen;
                }
                break;
            }
            case 6: {
                datumArray = new NUMBER[n3];
                byte[] byArray = this.statement.ibtBindBytes;
                for (int i3 = 0; i3 < n3; ++i3) {
                    if (sArray[this.ibtIndicatorIndex + i3] == -1) {
                        datumArray[i3] = null;
                    } else {
                        byte by = byArray[n4];
                        byte[] byArray2 = new byte[by];
                        System.arraycopy(byArray, n4 + 1, byArray2, 0, by);
                        datumArray[i3] = new NUMBER(byArray2);
                    }
                    n4 += this.elementMaxLen;
                }
                break;
            }
            default: {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        PlsqlIndexTableAccessor.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 97);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 97);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
        }
        return datumArray;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.PlsqlIndexTableAccessor"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

