/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.OracleDataFactory;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.PhysicalConnection;
import oracle.jdbc.driver.PlsqlIndexTableAccessor;
import oracle.sql.ANYDATA;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BINARY_DOUBLE;
import oracle.sql.BINARY_FLOAT;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.CustomDatum;
import oracle.sql.CustomDatumFactory;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.INTERVALDS;
import oracle.sql.INTERVALYM;
import oracle.sql.NUMBER;
import oracle.sql.OPAQUE;
import oracle.sql.ORAData;
import oracle.sql.ORADataFactory;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.sql.TIMESTAMP;
import oracle.sql.TIMESTAMPLTZ;
import oracle.sql.TIMESTAMPTZ;

abstract class OracleCallableStatement
extends OraclePreparedStatement
implements oracle.jdbc.internal.OracleCallableStatement {
    boolean atLeastOneOrdinalParameter = false;
    boolean atLeastOneNamedParameter = false;
    String[] namedParameters = new String[8];
    int parameterCount = 0;
    final String errMsgMixedBind = "Ordinal binding and Named binding cannot be combined!";
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    OracleCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3) throws SQLException {
        this(physicalConnection, string, n2, n3, 1003, 1007);
    }

    OracleCallableStatement(PhysicalConnection physicalConnection, String string, int n2, int n3, int n4, int n5) throws SQLException {
        super(physicalConnection, string, 1, n3, n4, n5);
        this.statementType = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerOutParameterInternal(int n2, int n3, int n4, int n5, String string) throws SQLException {
        int n6 = n2 - 1;
        if (n6 < 0 || n2 > this.numberOfBindPositions) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (n3 == 0) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 4);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        int n7 = this.getInternalType(n3);
        this.resetBatch();
        this.currentRowNeedToPrepareBinds = true;
        if (this.currentRowBindAccessors == null) {
            this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
        }
        switch (n3) {
            case -4: 
            case -3: 
            case -1: 
            case 1: 
            case 12: 
            case 70: {
                break;
            }
            case -16: 
            case -15: 
            case -9: {
                this.currentRowFormOfUse[n6] = 2;
                break;
            }
            case 2011: {
                n5 = 0;
                this.currentRowFormOfUse[n6] = 2;
                break;
            }
            case 2009: {
                n5 = 0;
                string = "SYS.XMLTYPE";
                break;
            }
            default: {
                n5 = 0;
            }
        }
        this.currentRowBindAccessors[n6] = this.allocateAccessor(n7, n3, n6 + 1, n5, this.currentRowFormOfUse[n6], string, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int n2, int n3, String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (string == null || string.length() == 0) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 60 + "empty Object name");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 60, "empty Object name");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.registerOutParameterInternal(n2, n3, 0, 0, string);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameterBytes(int n2, int n3, int n4, int n5) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4) + ", " + OracleLog.argument(n5));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.registerOutParameterInternal(n2, n3, n4, n5, null);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameterChars(int n2, int n3, int n4, int n5) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4) + ", " + OracleLog.argument(n5));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.registerOutParameterInternal(n2, n3, n4, n5, null);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int n2, int n3, int n4, int n5) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4) + ", " + OracleLog.argument(n5));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.registerOutParameterInternal(n2, n3, n4, n5, null);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(String string, int n2, int n3, int n4) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.registerOutParameterInternal(string, n2, n3, n4, null);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    @Override
    boolean isOracleBatchStyle() {
        return false;
    }

    @Override
    void resetBatch() {
        this.batch = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setExecuteBatch(int n2) throws SQLException {
        block13: {
            try {
                if (!TRACE || !OracleLog.recursiveEnter()) break block13;
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int sendBatch() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + this.validRows);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = this.validRows;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.registerOutParameter(n2, n3, 0, -1);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(int n2, int n3, int n4) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.registerOutParameter(n2, n3, n4, -1);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean wasNull() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl = this.wasNullValue();
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            String string = accessor.getString(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum getOracleObject(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Datum datum = accessor.getOracleObject(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datum);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Datum datum2 = datum;
            return datum2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ROWID getROWID(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            ROWID rOWID = accessor.getROWID(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rOWID);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ROWID rOWID2 = rOWID;
            return rOWID2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NUMBER getNUMBER(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            NUMBER nUMBER = accessor.getNUMBER(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nUMBER);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NUMBER nUMBER2 = nUMBER;
            return nUMBER2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DATE getDATE(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            DATE dATE = accessor.getDATE(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dATE);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            DATE dATE2 = dATE;
            return dATE2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALYM getINTERVALYM(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            INTERVALYM iNTERVALYM = accessor.getINTERVALYM(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + iNTERVALYM);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            INTERVALYM iNTERVALYM2 = iNTERVALYM;
            return iNTERVALYM2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public INTERVALDS getINTERVALDS(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            INTERVALDS iNTERVALDS = accessor.getINTERVALDS(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + iNTERVALDS);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            INTERVALDS iNTERVALDS2 = iNTERVALDS;
            return iNTERVALDS2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMP getTIMESTAMP(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            TIMESTAMP tIMESTAMP = accessor.getTIMESTAMP(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tIMESTAMP);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMP tIMESTAMP2 = tIMESTAMP;
            return tIMESTAMP2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPTZ getTIMESTAMPTZ(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            TIMESTAMPTZ tIMESTAMPTZ = accessor.getTIMESTAMPTZ(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tIMESTAMPTZ);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPTZ tIMESTAMPTZ2 = tIMESTAMPTZ;
            return tIMESTAMPTZ2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TIMESTAMPLTZ getTIMESTAMPLTZ(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            TIMESTAMPLTZ tIMESTAMPLTZ = accessor.getTIMESTAMPLTZ(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + tIMESTAMPLTZ);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            TIMESTAMPLTZ tIMESTAMPLTZ2 = tIMESTAMPLTZ;
            return tIMESTAMPLTZ2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public REF getREF(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            REF rEF = accessor.getREF(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rEF);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            REF rEF2 = rEF;
            return rEF2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ARRAY getARRAY(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            ARRAY aRRAY = accessor.getARRAY(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + aRRAY);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY aRRAY2 = aRRAY;
            return aRRAY2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public STRUCT getSTRUCT(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            STRUCT sTRUCT = accessor.getSTRUCT(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sTRUCT);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            STRUCT sTRUCT2 = sTRUCT;
            return sTRUCT2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OPAQUE getOPAQUE(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            OPAQUE oPAQUE = accessor.getOPAQUE(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oPAQUE);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            OPAQUE oPAQUE2 = oPAQUE;
            return oPAQUE2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CHAR getCHAR(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            CHAR cHAR = accessor.getCHAR(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cHAR);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CHAR cHAR2 = cHAR;
            return cHAR2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Reader reader = accessor.getCharacterStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader2 = reader;
            return reader2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RAW getRAW(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            RAW rAW = accessor.getRAW(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rAW);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            RAW rAW2 = rAW;
            return rAW2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BLOB getBLOB(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            BLOB bLOB = accessor.getBLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bLOB);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BLOB bLOB2 = bLOB;
            return bLOB2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CLOB getCLOB(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            CLOB cLOB = accessor.getCLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cLOB);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB2 = cLOB;
            return cLOB2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBFILE(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            BFILE bFILE = accessor.getBFILE(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bFILE);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BFILE bFILE2 = bFILE;
            return bFILE2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BFILE getBfile(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            BFILE bFILE = accessor.getBFILE(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bFILE);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BFILE bFILE2 = bFILE;
            return bFILE2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            boolean bl = accessor.getBoolean(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            byte by = accessor.getByte(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by2 = by;
            return by2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            short s2 = accessor.getShort(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + s2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s3 = s2;
            return s3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            int n3 = accessor.getInt(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = n3;
            return n4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            long l2 = accessor.getLong(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = l2;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            float f2 = accessor.getFloat(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + f2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float f3 = f2;
            return f3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            double d2 = accessor.getDouble(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double d3 = d2;
            return d3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            BigDecimal bigDecimal = accessor.getBigDecimal(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal2 = bigDecimal;
            return bigDecimal2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            byte[] byArray = accessor.getBytes(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] privateGetBytes(int n2) throws SQLException {
        if (this.closed) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        if (this.atLeastOneNamedParameter) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        Accessor accessor = null;
        if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.lastIndex = n2;
        if (this.streamList != null) {
            this.closeUsedStreams(n2);
        }
        return accessor.privateGetBytes(this.currentRank);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Date date = accessor.getDate(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date date2 = date;
            return date2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Time time = accessor.getTime(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time2 = time;
            return time2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Timestamp timestamp = accessor.getTimestamp(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            InputStream inputStream = accessor.getAsciiStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            InputStream inputStream = accessor.getUnicodeStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            InputStream inputStream = accessor.getBinaryStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Object object = accessor.getObject(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getAnyDataEmbeddedObject(int n2) throws SQLException {
        try {
            Datum datum;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object = null;
            Object object2 = this.getObject(n2);
            if (object2 instanceof ANYDATA && (datum = ((ANYDATA)object2).accessDatum()) != null) {
                object = datum.toJdbc();
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            datum = object;
            return datum;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getCustomDatum(int n2, CustomDatumFactory customDatumFactory) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(customDatumFactory));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            CustomDatum customDatum = accessor.getCustomDatum(this.currentRank, customDatumFactory);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + customDatum);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CustomDatum customDatum2 = customDatum;
            return customDatum2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(int n2, OracleDataFactory oracleDataFactory) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(oracleDataFactory));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Object object = accessor.getObject(this.currentRank, oracleDataFactory);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getORAData(int n2, ORADataFactory oRADataFactory) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(oRADataFactory));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            ORAData oRAData = accessor.getORAData(this.currentRank, oRADataFactory);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + oRAData);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ORAData oRAData2 = oRAData;
            return oRAData2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResultSet getCursor(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            ResultSet resultSet = accessor.getCursor(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + resultSet);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearParameters() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                super.clearParameters();
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(int n2, Map map) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(map));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Object object = accessor.getObject(this.currentRank, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            REF rEF = accessor.getREF(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rEF);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            REF rEF2 = rEF;
            return rEF2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            BLOB bLOB = accessor.getBLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bLOB);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BLOB bLOB2 = bLOB;
            return bLOB2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            CLOB cLOB = accessor.getCLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cLOB);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB2 = cLOB;
            return cLOB2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            ARRAY aRRAY = accessor.getARRAY(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + aRRAY);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY aRRAY2 = aRRAY;
            return aRRAY2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            BigDecimal bigDecimal = accessor.getBigDecimal(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal2 = bigDecimal;
            return bigDecimal2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(int n2, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Date date = accessor.getDate(this.currentRank, calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date date2 = date;
            return date2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(int n2, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Time time = accessor.getTime(this.currentRank, calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time2 = time;
            return time2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(int n2, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Timestamp timestamp = accessor.getTimestamp(this.currentRank, calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addBatch() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.currentRowBindAccessors != null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Stored procedure with out or inout parameters cannot be batched");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Stored procedure with out or inout parameters cannot be batched");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            super.addBatch();
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    @Override
    protected void alwaysOnClose() throws SQLException {
        this.sqlObject.resetNamedParameters();
        this.namedParameters = new String[8];
        this.parameterCount = 0;
        this.atLeastOneOrdinalParameter = false;
        this.atLeastOneNamedParameter = false;
        super.alwaysOnClose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(String string, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.registerOutParameterInternal(string, n2, 0, -1, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(String string, int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.registerOutParameterInternal(string, n2, n3, -1, null);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerOutParameter(String string, int n2, String string2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(string2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.registerOutParameterInternal(string, n2, 0, -1, string2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    void registerOutParameterInternal(String string, int n2, int n3, int n4, String string2) throws SQLException {
        int n5 = this.addNamedPara(string);
        this.registerOutParameterInternal(n5, n2, n3, n4, string2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            URL uRL = accessor.getURL(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + uRL);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            URL uRL2 = uRL;
            return uRL2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringForClob(String string, String string2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            if (string2 == null || string2.length() == 0) {
                this.setNull(n2, 2005);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            this.setStringForClob(n2, string2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStringForClob(int n2, String string) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (string == null || string.length() == 0) {
                this.setNull(n2, 2005);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.setStringForClobCritical(n2, string);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytesForBlob(String string, byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(byArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBytesForBlob(n2, byArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytesForBlob(int n2, byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (byArray == null || byArray.length == 0) {
                this.setNull(n2, 2004);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: ");
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                return;
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.setBytesForBlobCritical(n2, byArray);
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getString(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            String string3 = accessor.getString(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string3);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string4 = string3;
            return string4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean getBoolean(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            boolean bl = accessor.getBoolean(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte getByte(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            byte by = accessor.getByte(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + by);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte by2 = by;
            return by2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short getShort(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            short s2 = accessor.getShort(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + s2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            short s3 = s2;
            return s3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getInt(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            int n3 = accessor.getInt(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = n3;
            return n4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getLong(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            long l2 = accessor.getLong(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + l2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            long l3 = l2;
            return l3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float getFloat(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            float f2 = accessor.getFloat(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + f2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            float f3 = f2;
            return f3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getDouble(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            double d2 = accessor.getDouble(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + d2);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            double d3 = d2;
            return d3;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] getBytes(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            byte[] byArray = accessor.getBytes(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Date date = accessor.getDate(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date date2 = date;
            return date2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Time time = accessor.getTime(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time2 = time;
            return time2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Timestamp timestamp = accessor.getTimestamp(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getObject(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Object object = accessor.getObject(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            BigDecimal bigDecimal = accessor.getBigDecimal(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal2 = bigDecimal;
            return bigDecimal2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal getBigDecimal(String string, int n2) throws SQLException {
        try {
            int n3;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n3 = 0; n3 < this.parameterCount && string2 != this.namedParameters[n3]; ++n3) {
            }
            Accessor accessor = null;
            if (++n3 <= 0 || n3 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n3 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n3;
            if (this.streamList != null) {
                this.closeUsedStreams(n3);
            }
            BigDecimal bigDecimal = accessor.getBigDecimal(this.currentRank, n2);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bigDecimal);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BigDecimal bigDecimal2 = bigDecimal;
            return bigDecimal2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getObject(String string, Map map) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(map));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Object object = accessor.getObject(this.currentRank, map);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + object);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Object object2 = object;
            return object2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Ref getRef(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            REF rEF = accessor.getREF(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rEF);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            REF rEF2 = rEF;
            return rEF2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Blob getBlob(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            BLOB bLOB = accessor.getBLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bLOB);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            BLOB bLOB2 = bLOB;
            return bLOB2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clob getClob(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            CLOB cLOB = accessor.getCLOB(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cLOB);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            CLOB cLOB2 = cLOB;
            return cLOB2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Array getArray(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            ARRAY aRRAY = accessor.getARRAY(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + aRRAY);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ARRAY aRRAY2 = aRRAY;
            return aRRAY2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Date date = accessor.getDate(this.currentRank, calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + date);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Date date2 = date;
            return date2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Time time = accessor.getTime(this.currentRank, calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + time);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Time time2 = time;
            return time2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Timestamp timestamp = accessor.getTimestamp(this.currentRank, calendar);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + timestamp);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Timestamp timestamp2 = timestamp;
            return timestamp2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getURL(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            URL uRL = accessor.getURL(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + uRL);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            URL uRL2 = uRL;
            return uRL2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        if (TRACE && OracleLog.recursiveEnter()) {
            try {
                OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing Unsupported Feature: " + "");
            }
            finally {
                OracleLog.recursiveExit();
            }
        }
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerIndexTableOutParameter(int n2, int n3, int n4, int n5) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                int n6;
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4) + ", " + OracleLog.argument(n5));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if ((n6 = n2 - 1) < 0 || n2 > this.numberOfBindPositions) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                int n7 = this.getInternalType(n4);
                this.resetBatch();
                this.currentRowNeedToPrepareBinds = true;
                if (this.currentRowBindAccessors == null) {
                    this.currentRowBindAccessors = new Accessor[this.numberOfBindPositions];
                }
                this.currentRowBindAccessors[n6] = this.allocateIndexTableAccessor(n4, n7, n5, n3, this.currentRowFormOfUse[n6], true);
                this.hasIbtBind = true;
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    PlsqlIndexTableAccessor allocateIndexTableAccessor(int n2, int n3, int n4, int n5, short s2, boolean bl) throws SQLException {
        return new PlsqlIndexTableAccessor(this, n2, n3, n4, n5, s2, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getPlsqlIndexTable(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Object[] objectArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                Datum[] datumArray = this.getOraclePlsqlIndexTable(n2);
                PlsqlIndexTableAccessor plsqlIndexTableAccessor = (PlsqlIndexTableAccessor)this.outBindAccessors[n2 - 1];
                int n3 = plsqlIndexTableAccessor.elementInternalType;
                Object[] objectArray2 = null;
                switch (n3) {
                    case 9: {
                        objectArray2 = new String[datumArray.length];
                        break;
                    }
                    case 6: {
                        objectArray2 = new BigDecimal[datumArray.length];
                        break;
                    }
                    default: {
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 1 + "Invalid column type");
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 1, "Invalid column type");
                        sQLException.fillInStackTrace();
                        throw sQLException;
                    }
                }
                for (int i2 = 0; i2 < objectArray2.length; ++i2) {
                    objectArray2[i2] = datumArray[i2] != null && datumArray[i2].getLength() != 0L ? datumArray[i2].toJdbc() : null;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + objectArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                objectArray = objectArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return objectArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object getPlsqlIndexTable(int n2, Class clazz) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            boolean[] blArray;
            Datum[] datumArray;
            block123: {
                short[] sArray;
                block122: {
                    long[] lArray;
                    block120: {
                        int[] nArray;
                        block118: {
                            float[] fArray;
                            block116: {
                                double[] dArray;
                                block114: {
                                    char[] cArray;
                                    block112: {
                                        byte[] byArray;
                                        block110: {
                                            String string;
                                            block121: {
                                                block119: {
                                                    block117: {
                                                        block115: {
                                                            block113: {
                                                                block111: {
                                                                    block109: {
                                                                        if (TRACE && OracleLog.recursiveEnter()) {
                                                                            try {
                                                                                if (OracleLog.enter()) {
                                                                                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(clazz));
                                                                                }
                                                                            }
                                                                            finally {
                                                                                OracleLog.recursiveExit();
                                                                            }
                                                                        }
                                                                        datumArray = this.getOraclePlsqlIndexTable(n2);
                                                                        if (clazz == null || !clazz.isPrimitive()) {
                                                                            if (TRACE && OracleLog.recursiveEnter()) {
                                                                                try {
                                                                                    OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68);
                                                                                }
                                                                                finally {
                                                                                    OracleLog.recursiveExit();
                                                                                }
                                                                            }
                                                                            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68);
                                                                            sQLException.fillInStackTrace();
                                                                            throw sQLException;
                                                                        }
                                                                        string = clazz.getName();
                                                                        if (!string.equals("byte")) break block109;
                                                                        byArray = new byte[datumArray.length];
                                                                        break block110;
                                                                    }
                                                                    if (!string.equals("char")) break block111;
                                                                    cArray = new char[datumArray.length];
                                                                    break block112;
                                                                }
                                                                if (!string.equals("double")) break block113;
                                                                dArray = new double[datumArray.length];
                                                                break block114;
                                                            }
                                                            if (!string.equals("float")) break block115;
                                                            fArray = new float[datumArray.length];
                                                            break block116;
                                                        }
                                                        if (!string.equals("int")) break block117;
                                                        nArray = new int[datumArray.length];
                                                        break block118;
                                                    }
                                                    if (!string.equals("long")) break block119;
                                                    lArray = new long[datumArray.length];
                                                    break block120;
                                                }
                                                if (!string.equals("short")) break block121;
                                                sArray = new short[datumArray.length];
                                                break block122;
                                            }
                                            if (string.equals("boolean")) {
                                                blArray = new boolean[datumArray.length];
                                                break block123;
                                            } else {
                                                if (TRACE && OracleLog.recursiveEnter()) {
                                                    try {
                                                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 23);
                                                    }
                                                    finally {
                                                        OracleLog.recursiveExit();
                                                    }
                                                }
                                                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 23);
                                                sQLException.fillInStackTrace();
                                                throw sQLException;
                                            }
                                            finally {
                                                if (TRACE && OracleLog.recursiveEnter()) {
                                                    try {
                                                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                                                    }
                                                    finally {
                                                        OracleLog.recursiveExit();
                                                    }
                                                }
                                            }
                                        }
                                        for (int i2 = 0; i2 < datumArray.length; ++i2) {
                                            byArray[i2] = datumArray[i2] != null ? datumArray[i2].byteValue() : (byte)0;
                                        }
                                        if (TRACE && OracleLog.recursiveEnter()) {
                                            try {
                                                if (OracleLog.isPublic()) {
                                                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + byArray);
                                                }
                                            }
                                            finally {
                                                OracleLog.recursiveExit();
                                            }
                                        }
                                        byte[] byArray2 = byArray;
                                        return byArray2;
                                    }
                                    for (int i3 = 0; i3 < datumArray.length; ++i3) {
                                        cArray[i3] = datumArray[i3] != null && datumArray[i3].getLength() != 0L ? (char)datumArray[i3].intValue() : (char)'\u0000';
                                    }
                                    if (TRACE && OracleLog.recursiveEnter()) {
                                        try {
                                            if (OracleLog.isPublic()) {
                                                OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + cArray);
                                            }
                                        }
                                        finally {
                                            OracleLog.recursiveExit();
                                        }
                                    }
                                    char[] cArray2 = cArray;
                                    return cArray2;
                                }
                                for (int i4 = 0; i4 < datumArray.length; ++i4) {
                                    dArray[i4] = datumArray[i4] != null && datumArray[i4].getLength() != 0L ? datumArray[i4].doubleValue() : 0.0;
                                }
                                if (TRACE && OracleLog.recursiveEnter()) {
                                    try {
                                        if (OracleLog.isPublic()) {
                                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + dArray);
                                        }
                                    }
                                    finally {
                                        OracleLog.recursiveExit();
                                    }
                                }
                                double[] dArray2 = dArray;
                                return dArray2;
                            }
                            for (int i5 = 0; i5 < datumArray.length; ++i5) {
                                fArray[i5] = datumArray[i5] != null && datumArray[i5].getLength() != 0L ? datumArray[i5].floatValue() : 0.0f;
                            }
                            if (TRACE && OracleLog.recursiveEnter()) {
                                try {
                                    if (OracleLog.isPublic()) {
                                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + fArray);
                                    }
                                }
                                finally {
                                    OracleLog.recursiveExit();
                                }
                            }
                            float[] fArray2 = fArray;
                            return fArray2;
                        }
                        for (int i6 = 0; i6 < datumArray.length; ++i6) {
                            nArray[i6] = datumArray[i6] != null && datumArray[i6].getLength() != 0L ? datumArray[i6].intValue() : 0;
                        }
                        if (TRACE && OracleLog.recursiveEnter()) {
                            try {
                                if (OracleLog.isPublic()) {
                                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nArray);
                                }
                            }
                            finally {
                                OracleLog.recursiveExit();
                            }
                        }
                        int[] nArray2 = nArray;
                        return nArray2;
                    }
                    for (int i7 = 0; i7 < datumArray.length; ++i7) {
                        lArray[i7] = datumArray[i7] != null && datumArray[i7].getLength() != 0L ? datumArray[i7].longValue() : 0L;
                    }
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            if (OracleLog.isPublic()) {
                                OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + lArray);
                            }
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    long[] lArray2 = lArray;
                    return lArray2;
                }
                for (int i8 = 0; i8 < datumArray.length; ++i8) {
                    sArray[i8] = datumArray[i8] != null && datumArray[i8].getLength() != 0L ? (short)datumArray[i8].intValue() : (short)0;
                }
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sArray);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                short[] sArray2 = sArray;
                return sArray2;
            }
            for (int i9 = 0; i9 < datumArray.length; ++i9) {
                blArray[i9] = datumArray[i9] != null && datumArray[i9].getLength() != 0L ? datumArray[i9].booleanValue() : false;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + blArray);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            boolean[] blArray2 = blArray;
            return blArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datum[] getOraclePlsqlIndexTable(int n2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            Datum[] datumArray;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (this.closed) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.atLeastOneNamedParameter) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                Accessor accessor = null;
                if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.lastIndex = n2;
                if (this.streamList != null) {
                    this.closeUsedStreams(n2);
                }
                Datum[] datumArray2 = accessor.getOraclePlsqlIndexTable(this.currentRank);
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + datumArray2);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                datumArray = datumArray2;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return datumArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute() throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            PhysicalConnection physicalConnection = this.connection;
            synchronized (physicalConnection) {
                this.ensureOpen();
                if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) {
                    this.needToParse = true;
                }
                boolean bl = super.execute();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + bl);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                boolean bl2 = bl;
                return bl2;
            }
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int executeUpdate() throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            int n2;
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument());
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.ensureOpen();
                if (this.atLeastOneNamedParameter && this.atLeastOneOrdinalParameter) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                if (this.sqlObject.setNamedParameters(this.parameterCount, this.namedParameters)) {
                    this.needToParse = true;
                }
                int n3 = super.executeUpdate();
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.isPublic()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + n3);
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                n2 = n3;
            }
            catch (Throwable throwable) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                throw throwable;
            }
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            return n2;
        }
    }

    @Override
    void releaseBuffers() {
        if (this.outBindAccessors != null) {
            int n2 = this.outBindAccessors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.outBindAccessors[i2] == null) continue;
                this.outBindAccessors[i2].rowSpaceByte = null;
                this.outBindAccessors[i2].rowSpaceChar = null;
            }
        }
        super.releaseBuffers();
    }

    @Override
    void doLocalInitialization() {
        if (this.outBindAccessors != null) {
            int n2 = this.outBindAccessors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.outBindAccessors[i2] == null) continue;
                this.outBindAccessors[i2].rowSpaceByte = this.bindBytes;
                this.outBindAccessors[i2].rowSpaceChar = this.bindChars;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArray(int n2, Array array) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(array));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setArrayInternal(n2, array);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(int n2, BigDecimal bigDecimal) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bigDecimal));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBigDecimalInternal(n2, bigDecimal);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, Blob blob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(blob));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBlobInternal(n2, blob);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(int n2, boolean bl) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bl));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBooleanInternal(n2, bl);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(int n2, byte by) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(by));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setByteInternal(n2, by);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(int n2, byte[] byArray) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(byArray));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBytesInternal(n2, byArray);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Clob clob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(clob));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setClobInternal(n2, clob);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int n2, Date date) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(date));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setDateInternal(n2, date);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(int n2, Date date, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(date));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setDateInternal(n2, date, calendar);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(int n2, double d2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(d2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setDoubleInternal(n2, d2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(int n2, float f2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(f2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setFloatInternal(n2, f2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(int n2, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setIntInternal(n2, n3);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(int n2, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(l2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setLongInternal(n2, l2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, NClob nClob) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(nClob));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setNClobInternal(n2, nClob);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNString(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setNStringInternal(n2, string);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int n2, Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setObjectInternal(n2, object);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(int n2, Object object, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setObjectInternal(n2, object, n3);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRef(int n2, Ref ref) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(ref));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setRefInternal(n2, ref);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowId(int n2, RowId rowId) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(rowId));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setRowIdInternal(n2, rowId);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(int n2, short s2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(s2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setShortInternal(n2, s2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSQLXML(int n2, SQLXML sQLXML) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(sQLXML));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setSQLXMLInternal(n2, sQLXML);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setStringInternal(n2, string);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int n2, Time time) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(time));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTimeInternal(n2, time);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(int n2, Time time, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(time));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTimeInternal(n2, time, calendar);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int n2, Timestamp timestamp) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(timestamp));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTimestampInternal(n2, timestamp);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(int n2, Timestamp timestamp, Calendar calendar) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(timestamp));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTimestampInternal(n2, timestamp, calendar);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(int n2, URL uRL) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(uRL));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setURLInternal(n2, uRL);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setARRAY(int n2, ARRAY aRRAY) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(aRRAY));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setARRAYInternal(n2, aRRAY);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBFILE(int n2, BFILE bFILE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bFILE));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBFILEInternal(n2, bFILE);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBfile(int n2, BFILE bFILE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bFILE));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBfileInternal(n2, bFILE);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloat(int n2, float f2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(f2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryFloatInternal(n2, f2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloat(int n2, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bINARY_FLOAT));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryFloatInternal(n2, bINARY_FLOAT);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDouble(int n2, double d2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(d2));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryDoubleInternal(n2, d2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDouble(int n2, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bINARY_DOUBLE));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryDoubleInternal(n2, bINARY_DOUBLE);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBLOB(int n2, BLOB bLOB) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(bLOB));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBLOBInternal(n2, bLOB);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCHAR(int n2, CHAR cHAR) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(cHAR));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setCHARInternal(n2, cHAR);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCLOB(int n2, CLOB cLOB) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(cLOB));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setCLOBInternal(n2, cLOB);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursor(int n2, ResultSet resultSet) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(resultSet));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setCursorInternal(n2, resultSet);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCustomDatum(int n2, CustomDatum customDatum) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(customDatum));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setCustomDatumInternal(n2, customDatum);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDATE(int n2, DATE dATE) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(dATE));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setDATEInternal(n2, dATE);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFixedCHAR(int n2, String string) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(string));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setFixedCHARInternal(n2, string);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALDS(int n2, INTERVALDS iNTERVALDS) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(iNTERVALDS));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setINTERVALDSInternal(n2, iNTERVALDS);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALYM(int n2, INTERVALYM iNTERVALYM) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(iNTERVALYM));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setINTERVALYMInternal(n2, iNTERVALYM);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNUMBER(int n2, NUMBER nUMBER) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(nUMBER));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setNUMBERInternal(n2, nUMBER);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOPAQUE(int n2, OPAQUE oPAQUE) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(oPAQUE));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setOPAQUEInternal(n2, oPAQUE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOracleObject(int n2, Datum datum) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(datum));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setOracleObjectInternal(n2, datum);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setORAData(int n2, ORAData oRAData) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(oRAData));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setORADataInternal(n2, oRAData);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRAW(int n2, RAW rAW) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(rAW));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setRAWInternal(n2, rAW);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setREF(int n2, REF rEF) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(rEF));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setREFInternal(n2, rEF);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefType(int n2, REF rEF) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(rEF));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setRefTypeInternal(n2, rEF);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setROWID(int n2, ROWID rOWID) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(rOWID));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setROWIDInternal(n2, rOWID);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSTRUCT(int n2, STRUCT sTRUCT) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(sTRUCT));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            this.atLeastOneOrdinalParameter = true;
            this.setSTRUCTInternal(n2, sTRUCT);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPLTZ(int n2, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(tIMESTAMPLTZ));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTIMESTAMPLTZInternal(n2, tIMESTAMPLTZ);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPTZ(int n2, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(tIMESTAMPTZ));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTIMESTAMPTZInternal(n2, tIMESTAMPTZ);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMP(int n2, TIMESTAMP tIMESTAMP) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(tIMESTAMP));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setTIMESTAMPInternal(n2, tIMESTAMP);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, InputStream inputStream) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBlobInternal(n2, inputStream);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(int n2, InputStream inputStream, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (l2 < 0L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "length for setBlob() cannot be negative");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setBlob() cannot be negative");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBlobInternal(n2, inputStream, l2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setClobInternal(n2, reader);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(int n2, Reader reader, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                if (l2 < 0L) {
                    if (TRACE && OracleLog.recursiveEnter()) {
                        try {
                            OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "length for setClob() cannot be negative");
                        }
                        finally {
                            OracleLog.recursiveExit();
                        }
                    }
                    SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative");
                    sQLException.fillInStackTrace();
                    throw sQLException;
                }
                this.atLeastOneOrdinalParameter = true;
                this.setClobInternal(n2, reader, l2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setNClobInternal(n2, reader);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(int n2, Reader reader, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setNClobInternal(n2, reader, l2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n2, InputStream inputStream) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setAsciiStreamInternal(n2, inputStream);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setAsciiStreamInternal(n2, inputStream, n3);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(int n2, InputStream inputStream, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setAsciiStreamInternal(n2, inputStream, l2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n2, InputStream inputStream) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryStreamInternal(n2, inputStream);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryStreamInternal(n2, inputStream, n3);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(int n2, InputStream inputStream, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setBinaryStreamInternal(n2, inputStream, l2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setCharacterStreamInternal(n2, reader);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n2, Reader reader, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setCharacterStreamInternal(n2, reader, n3);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setCharacterStreamInternal(n2, reader, l2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int n2, Reader reader) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setNCharacterStreamInternal(n2, reader);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(int n2, Reader reader, long l2) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(reader));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setNCharacterStreamInternal(n2, reader, l2);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnicodeStream(int n2, InputStream inputStream, int n3) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(inputStream));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setUnicodeStreamInternal(n2, inputStream, n3);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setArray(String string, Array array) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(array));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setArrayInternal(n2, array);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bigDecimal));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBigDecimalInternal(n2, bigDecimal);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(String string, Blob blob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(blob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBlobInternal(n2, blob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBoolean(String string, boolean bl) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bl));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBooleanInternal(n2, bl);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setByte(String string, byte by) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(by));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setByteInternal(n2, by);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBytes(String string, byte[] byArray) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(byArray));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBytesInternal(n2, byArray);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(String string, Clob clob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(clob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setClobInternal(n2, clob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(String string, Date date) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(date));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setDateInternal(n2, date);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDate(String string, Date date, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(date) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setDateInternal(n2, date, calendar);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDouble(String string, double d2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(d2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setDoubleInternal(n2, d2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFloat(String string, float f2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(f2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setFloatInternal(n2, f2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setInt(String string, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.addNamedPara(string);
            this.setIntInternal(n3, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLong(String string, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setLongInternal(n2, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(String string, NClob nClob) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(nClob));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setNClobInternal(n2, nClob);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNString(String string, String string2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setNStringInternal(n2, string2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(String string, Object object) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(object));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setObjectInternal(n2, object);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(String string, Object object, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.addNamedPara(string);
            this.setObjectInternal(n3, object, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRef(String string, Ref ref) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(ref));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setRefInternal(n2, ref);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRowId(String string, RowId rowId) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(rowId));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setRowIdInternal(n2, rowId);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setShort(String string, short s2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(s2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setShortInternal(n2, s2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSQLXML(String string, SQLXML sQLXML) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(sQLXML));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setSQLXMLInternal(n2, sQLXML);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setString(String string, String string2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setStringInternal(n2, string2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(String string, Time time) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(time));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setTimeInternal(n2, time);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTime(String string, Time time, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(time) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setTimeInternal(n2, time, calendar);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(String string, Timestamp timestamp) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(timestamp));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setTimestampInternal(n2, timestamp);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTimestamp(String string, Timestamp timestamp, Calendar calendar) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(timestamp) + ", " + OracleLog.argument(calendar));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setTimestampInternal(n2, timestamp, calendar);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setURL(String string, URL uRL) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(uRL));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setURLInternal(n2, uRL);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setARRAY(String string, ARRAY aRRAY) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(aRRAY));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setARRAYInternal(n2, aRRAY);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBFILE(String string, BFILE bFILE) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bFILE));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBFILEInternal(n2, bFILE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBfile(String string, BFILE bFILE) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bFILE));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBfileInternal(n2, bFILE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloat(String string, float f2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(f2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBinaryFloatInternal(n2, f2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryFloat(String string, BINARY_FLOAT bINARY_FLOAT) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bINARY_FLOAT));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBinaryFloatInternal(n2, bINARY_FLOAT);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDouble(String string, double d2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(d2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBinaryDoubleInternal(n2, d2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryDouble(String string, BINARY_DOUBLE bINARY_DOUBLE) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bINARY_DOUBLE));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBinaryDoubleInternal(n2, bINARY_DOUBLE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBLOB(String string, BLOB bLOB) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(bLOB));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBLOBInternal(n2, bLOB);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCHAR(String string, CHAR cHAR) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(cHAR));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setCHARInternal(n2, cHAR);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCLOB(String string, CLOB cLOB) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(cLOB));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setCLOBInternal(n2, cLOB);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCursor(String string, ResultSet resultSet) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(resultSet));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setCursorInternal(n2, resultSet);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCustomDatum(String string, CustomDatum customDatum) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(customDatum));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setCustomDatumInternal(n2, customDatum);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDATE(String string, DATE dATE) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(dATE));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setDATEInternal(n2, dATE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFixedCHAR(String string, String string2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(string2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setFixedCHARInternal(n2, string2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALDS(String string, INTERVALDS iNTERVALDS) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(iNTERVALDS));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setINTERVALDSInternal(n2, iNTERVALDS);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setINTERVALYM(String string, INTERVALYM iNTERVALYM) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(iNTERVALYM));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setINTERVALYMInternal(n2, iNTERVALYM);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNUMBER(String string, NUMBER nUMBER) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(nUMBER));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setNUMBERInternal(n2, nUMBER);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOPAQUE(String string, OPAQUE oPAQUE) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(oPAQUE));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setOPAQUEInternal(n2, oPAQUE);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOracleObject(String string, Datum datum) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(datum));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setOracleObjectInternal(n2, datum);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setORAData(String string, ORAData oRAData) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(oRAData));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setORADataInternal(n2, oRAData);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRAW(String string, RAW rAW) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(rAW));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setRAWInternal(n2, rAW);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setREF(String string, REF rEF) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(rEF));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setREFInternal(n2, rEF);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRefType(String string, REF rEF) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(rEF));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setRefTypeInternal(n2, rEF);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setROWID(String string, ROWID rOWID) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(rOWID));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setROWIDInternal(n2, rOWID);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSTRUCT(String string, STRUCT sTRUCT) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(sTRUCT));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setSTRUCTInternal(n2, sTRUCT);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPLTZ(String string, TIMESTAMPLTZ tIMESTAMPLTZ) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(tIMESTAMPLTZ));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setTIMESTAMPLTZInternal(n2, tIMESTAMPLTZ);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMPTZ(String string, TIMESTAMPTZ tIMESTAMPTZ) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(tIMESTAMPTZ));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setTIMESTAMPTZInternal(n2, tIMESTAMPTZ);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTIMESTAMP(String string, TIMESTAMP tIMESTAMP) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(tIMESTAMP));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setTIMESTAMPInternal(n2, tIMESTAMP);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(String string, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBlobInternal(n2, inputStream);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlob(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (l2 < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "length for setBlob() cannot be negative");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setBlob() cannot be negative");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n2 = this.addNamedPara(string);
            this.setBlobInternal(n2, inputStream, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(String string, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setClobInternal(n2, reader);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setClob(String string, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (l2 < 0L) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 68 + "length for setClob() cannot be negative");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 68, "length for setClob() cannot be negative");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            int n2 = this.addNamedPara(string);
            this.setClobInternal(n2, reader, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(String string, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setNClobInternal(n2, reader);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNClob(String string, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setNClobInternal(n2, reader, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(String string, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setAsciiStreamInternal(n2, inputStream);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.addNamedPara(string);
            this.setAsciiStreamInternal(n3, inputStream, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAsciiStream(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setAsciiStreamInternal(n2, inputStream, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(String string, InputStream inputStream) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBinaryStreamInternal(n2, inputStream);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.addNamedPara(string);
            this.setBinaryStreamInternal(n3, inputStream, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBinaryStream(String string, InputStream inputStream, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setBinaryStreamInternal(n2, inputStream, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(String string, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setCharacterStreamInternal(n2, reader);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(String string, Reader reader, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.addNamedPara(string);
            this.setCharacterStreamInternal(n3, reader, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCharacterStream(String string, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setCharacterStreamInternal(n2, reader, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(String string, Reader reader) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setNCharacterStreamInternal(n2, reader);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNCharacterStream(String string, Reader reader, long l2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(reader) + ", " + OracleLog.argument(l2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setNCharacterStreamInternal(n2, reader, l2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnicodeStream(String string, InputStream inputStream, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(inputStream) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.addNamedPara(string);
            this.setUnicodeStreamInternal(n3, inputStream, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(String string, int n2, String string2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(string2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.addNamedPara(string);
            this.setNullInternal(n3, n2, string2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setNull(String string, int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n3 = this.addNamedPara(string);
            this.setNullInternal(n3, n2);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setStructDescriptor(String string, StructDescriptor structDescriptor) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(structDescriptor));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n2 = this.addNamedPara(string);
            this.setStructDescriptorInternal(n2, structDescriptor);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setObject(String string, Object object, int n2, int n3) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n2) + ", " + OracleLog.argument(n3));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            int n4 = this.addNamedPara(string);
            this.setObjectInternal(n4, object, n2, n3);
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPlsqlIndexTable(int n2, Object object, int n3, int n4, int n5, int n6) throws SQLException {
        PhysicalConnection physicalConnection = this.connection;
        synchronized (physicalConnection) {
            try {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        if (OracleLog.enter()) {
                            OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2) + ", " + OracleLog.argument(object) + ", " + OracleLog.argument(n3) + ", " + OracleLog.argument(n4) + ", " + OracleLog.argument(n5) + ", " + OracleLog.argument(n6));
                        }
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                this.atLeastOneOrdinalParameter = true;
                this.setPlsqlIndexTableInternal(n2, object, n3, n4, n5, n6);
            }
            finally {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int addNamedPara(String string) throws SQLException {
        if (this.closed) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        String string2 = string.toUpperCase().intern();
        for (int i2 = 0; i2 < this.parameterCount; ++i2) {
            if (string2 != this.namedParameters[i2]) continue;
            return i2 + 1;
        }
        if (this.parameterCount >= this.namedParameters.length) {
            String[] stringArray = new String[this.namedParameters.length * 2];
            System.arraycopy(this.namedParameters, 0, stringArray, 0, this.namedParameters.length);
            this.namedParameters = stringArray;
        }
        this.namedParameters[this.parameterCount++] = string2;
        this.atLeastOneNamedParameter = true;
        return this.parameterCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Reader reader = accessor.getCharacterStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader2 = reader;
            return reader2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            InputStream inputStream = accessor.getUnicodeStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            InputStream inputStream = accessor.getBinaryStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + inputStream);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            InputStream inputStream2 = inputStream;
            return inputStream2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            ROWID rOWID = accessor.getROWID(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rOWID);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ROWID rOWID2 = rOWID;
            return rOWID2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RowId getRowId(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            ROWID rOWID = accessor.getROWID(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + rOWID);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            ROWID rOWID2 = rOWID;
            return rOWID2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            NClob nClob = accessor.getNClob(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nClob);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NClob nClob2 = nClob;
            return nClob2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob getNClob(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            NClob nClob = accessor.getNClob(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + nClob);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            NClob nClob2 = nClob;
            return nClob2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            SQLXML sQLXML = accessor.getSQLXML(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sQLXML);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLXML sQLXML2 = sQLXML;
            return sQLXML2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML getSQLXML(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            SQLXML sQLXML = accessor.getSQLXML(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + sQLXML);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLXML sQLXML2 = sQLXML;
            return sQLXML2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            String string = accessor.getNString(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string2 = string;
            return string2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNString(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            String string3 = accessor.getNString(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + string3);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            String string4 = string3;
            return string4;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(int n2) throws SQLException {
        try {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(n2));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (this.closed) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 9);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 9);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            if (this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            Accessor accessor = null;
            if (n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 3);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 3);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Reader reader = accessor.getNCharacterStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader2 = reader;
            return reader2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        try {
            int n2;
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.enter()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Public Enter: " + OracleLog.argument(string));
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            if (!this.atLeastOneNamedParameter) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 90 + "Ordinal binding and Named binding cannot be combined!");
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 90, "Ordinal binding and Named binding cannot be combined!");
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            String string2 = string.toUpperCase().intern();
            for (n2 = 0; n2 < this.parameterCount && string2 != this.namedParameters[n2]; ++n2) {
            }
            Accessor accessor = null;
            if (++n2 <= 0 || n2 > this.numberOfBindPositions || this.outBindAccessors == null || (accessor = this.outBindAccessors[n2 - 1]) == null) {
                if (TRACE && OracleLog.recursiveEnter()) {
                    try {
                        OracleCallableStatement.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 6);
                    }
                    finally {
                        OracleLog.recursiveExit();
                    }
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 6);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            this.lastIndex = n2;
            if (this.streamList != null) {
                this.closeUsedStreams(n2);
            }
            Reader reader = accessor.getNCharacterStream(this.currentRank);
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    if (OracleLog.isPublic()) {
                        OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Return: " + reader);
                    }
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            Reader reader2 = reader;
            return reader2;
        }
        finally {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    OracleCallableStatement.logger().log(Level.FINE, Integer.toHexString(this.hashCode()).toUpperCase() + " Exit");
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
        }
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.OracleCallableStatement"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

