/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.SQLException;
import java.util.EventListener;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.aq.AQNotificationListener;
import oracle.jdbc.dcn.DatabaseChangeListener;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleLog;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.internal.XSEventListener;

class NTFEventListener {
    private final AQNotificationListener aqlistener;
    private final DatabaseChangeListener dcnlistener;
    private final XSEventListener xslistener;
    private Executor executor = null;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Jun_28_00:48:08_PDT_2012";
    public static boolean TRACE = false;
    private static Logger LOGGER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFEventListener(DatabaseChangeListener databaseChangeListener) throws SQLException {
        if (databaseChangeListener == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 246);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.dcnlistener = databaseChangeListener;
        this.aqlistener = null;
        this.xslistener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFEventListener(AQNotificationListener aQNotificationListener) throws SQLException {
        if (aQNotificationListener == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 246);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.aqlistener = aQNotificationListener;
        this.dcnlistener = null;
        this.xslistener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NTFEventListener(XSEventListener xSEventListener) throws SQLException {
        if (xSEventListener == null) {
            if (TRACE && OracleLog.recursiveEnter()) {
                try {
                    NTFEventListener.logger().log(Level.SEVERE, Integer.toHexString(this.hashCode()).toUpperCase() + " Throwing SQLException: " + 246);
                }
                finally {
                    OracleLog.recursiveExit();
                }
            }
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 246);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.aqlistener = null;
        this.dcnlistener = null;
        this.xslistener = xSEventListener;
    }

    void setExecutor(Executor executor) {
        this.executor = executor;
    }

    Executor getExecutor() {
        return this.executor;
    }

    EventListener getListener() {
        EventListener eventListener = this.dcnlistener;
        if (eventListener == null) {
            eventListener = this.aqlistener;
        }
        return eventListener;
    }

    AQNotificationListener getAQListener() {
        return this.aqlistener;
    }

    DatabaseChangeListener getDCNListener() {
        return this.dcnlistener;
    }

    XSEventListener getXSEventListener() {
        return this.xslistener;
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }

    private static Logger logger() {
        if (LOGGER == null) {
            LOGGER = Logger.getLogger("oracle.jdbc.driver.ntf");
        }
        return LOGGER;
    }

    static {
        try {
            TRACE = OracleLog.registerClassNameAndGetCurrentTraceSetting(Class.forName("oracle.jdbc.driver.NTFEventListener"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

